/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.mina.core.buffer.IoBuffer;

@Converter(generateLoader=true)
public final class MinaConverter {
    private MinaConverter() {
    }

    @Converter
    public static byte[] toByteArray(IoBuffer buffer) {
        byte[] answer = new byte[buffer.remaining()];
        buffer.get(answer);
        return answer;
    }

    @Converter
    public static String toString(IoBuffer buffer, Exchange exchange) {
        byte[] bytes = MinaConverter.toByteArray(buffer);
        return (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, (Object)bytes);
    }

    @Converter
    public static InputStream toInputStream(IoBuffer buffer) {
        return buffer.asInputStream();
    }

    @Converter
    public static ObjectInput toObjectInput(IoBuffer buffer) throws IOException {
        InputStream is = MinaConverter.toInputStream(buffer);
        return new ObjectInputStream(is);
    }

    @Converter
    public static IoBuffer toIoBuffer(byte[] bytes) {
        IoBuffer buf = IoBuffer.allocate((int)bytes.length);
        buf.put(bytes);
        return buf;
    }

    @Converter
    public static IoBuffer toIoBuffer(StreamCache cache, Exchange exchange) throws Exception {
        byte[] arr = (byte[])exchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, exchange, (Object)cache);
        return MinaConverter.toIoBuffer(arr);
    }
}

