/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.io.InputStream;
import java.io.ObjectInput;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.mina.MinaConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.mina.core.buffer.IoBuffer;

@DeferredContextBinding
public final class MinaConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        MinaConverterLoader.addTypeConverter(registry, byte[].class, IoBuffer.class, false, (type, exchange, value) -> {
            byte[] answer = MinaConverter.toByteArray((IoBuffer)value);
            return answer;
        });
        MinaConverterLoader.addTypeConverter(registry, InputStream.class, IoBuffer.class, false, (type, exchange, value) -> {
            InputStream answer = MinaConverter.toInputStream((IoBuffer)value);
            return answer;
        });
        MinaConverterLoader.addTypeConverter(registry, ObjectInput.class, IoBuffer.class, false, (type, exchange, value) -> {
            ObjectInput answer = MinaConverter.toObjectInput((IoBuffer)value);
            return answer;
        });
        MinaConverterLoader.addTypeConverter(registry, String.class, IoBuffer.class, false, (type, exchange, value) -> {
            String answer = MinaConverter.toString((IoBuffer)value, exchange);
            return answer;
        });
        MinaConverterLoader.addTypeConverter(registry, IoBuffer.class, byte[].class, false, (type, exchange, value) -> {
            IoBuffer answer = MinaConverter.toIoBuffer((byte[])value);
            return answer;
        });
        MinaConverterLoader.addTypeConverter(registry, IoBuffer.class, StreamCache.class, false, (type, exchange, value) -> {
            IoBuffer answer = MinaConverter.toIoBuffer((StreamCache)value, exchange);
            return answer;
        });
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

