/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.StreamCache;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MinaHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MinaHelper.class);

    private MinaHelper() {
    }

    public static void writeBody(IoSession session, Object body, Exchange exchange, long writeTimeout) throws CamelExchangeException {
        if (body instanceof StreamCache) {
            try {
                body = exchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, exchange, body);
            }
            catch (NoTypeConversionAvailableException e) {
                throw new CamelExchangeException("Error converting body to byte[]", exchange, (Throwable)e);
            }
        }
        WriteFuture future = session.write(body);
        LOG.trace("Waiting for write to complete for body: {} using session: {}", body, (Object)session);
        if (!future.awaitUninterruptibly(writeTimeout)) {
            String message = "Cannot write body: " + body.getClass().getCanonicalName() + " using session: " + String.valueOf(session);
            if (future.getException() != null) {
                throw new CamelExchangeException(message, exchange, future.getException());
            }
            throw new CamelExchangeException(message, exchange);
        }
    }
}

