/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milvus;

import io.milvus.client.MilvusClient;
import io.milvus.param.R;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.dml.DeleteParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.UpsertParam;
import io.milvus.param.highlevel.dml.SearchSimpleParam;
import io.milvus.param.index.CreateIndexParam;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.milvus.MilvusAction;
import org.apache.camel.component.milvus.MilvusEndpoint;
import org.apache.camel.support.DefaultProducer;

public class MilvusProducer
extends DefaultProducer {
    private MilvusClient client;
    private ExecutorService executor;

    public MilvusProducer(MilvusEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public MilvusEndpoint getEndpoint() {
        return (MilvusEndpoint)super.getEndpoint();
    }

    public void doStart() throws Exception {
        super.doStart();
        this.client = this.getEndpoint().getClient();
    }

    public void process(Exchange exchange) {
        Message in = exchange.getMessage();
        MilvusAction action = (MilvusAction)((Object)in.getHeader("CamelMilvusAction", MilvusAction.class));
        try {
            if (action == null) {
                throw new NoSuchHeaderException("The action is a required header", exchange, "CamelMilvusAction");
            }
            switch (action) {
                case CREATE_COLLECTION: {
                    this.createCollection(exchange);
                    break;
                }
                case CREATE_INDEX: {
                    this.createIndex(exchange);
                    break;
                }
                case UPSERT: {
                    this.upsert(exchange);
                    break;
                }
                case INSERT: {
                    this.insert(exchange);
                    break;
                }
                case SEARCH: {
                    this.search(exchange);
                    break;
                }
                case QUERY: {
                    this.query(exchange);
                    break;
                }
                case DELETE: {
                    this.delete(exchange);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported action: " + action.name());
                }
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
    }

    private void upsert(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        UpsertParam upsert = (UpsertParam)in.getMandatoryBody(UpsertParam.class);
        R result = this.client.upsert(upsert);
        this.handleResponseStatus(result);
        this.populateResponse(result, exchange);
    }

    private void insert(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        InsertParam insert = (InsertParam)in.getMandatoryBody(InsertParam.class);
        R result = this.client.insert(insert);
        this.handleResponseStatus(result);
        this.populateResponse(result, exchange);
    }

    private void createCollection(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        CreateCollectionParam body = (CreateCollectionParam)in.getMandatoryBody(CreateCollectionParam.class);
        R result = this.client.createCollection(body);
        this.handleResponseStatus(result);
        this.populateResponse(result, exchange);
    }

    private void createIndex(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        CreateIndexParam body = (CreateIndexParam)in.getMandatoryBody(CreateIndexParam.class);
        R result = this.client.createIndex(body);
        this.handleResponseStatus(result);
        this.populateResponse(result, exchange);
    }

    private void search(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        SearchSimpleParam body = (SearchSimpleParam)in.getMandatoryBody(SearchSimpleParam.class);
        this.client.loadCollection(LoadCollectionParam.newBuilder().withCollectionName(this.getEndpoint().getCollection()).withSyncLoad(Boolean.valueOf(true)).build());
        R result = this.client.search(body);
        this.handleResponseStatus(result);
        this.populateResponse(result, exchange);
    }

    private void query(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        QueryParam body = (QueryParam)in.getMandatoryBody(QueryParam.class);
        this.client.loadCollection(LoadCollectionParam.newBuilder().withCollectionName(this.getEndpoint().getCollection()).withSyncLoad(Boolean.valueOf(true)).build());
        R result = this.client.query(body);
        this.handleResponseStatus(result);
        this.populateResponse(result, exchange);
    }

    private void delete(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        DeleteParam body = (DeleteParam)in.getMandatoryBody(DeleteParam.class);
        R result = this.client.delete(body);
        this.handleResponseStatus(result);
        this.populateResponse(result, exchange);
    }

    private CamelContext getCamelContext() {
        return this.getEndpoint().getCamelContext();
    }

    private void handleResponseStatus(R<?> r) {
        if (r.getStatus().intValue() != R.Status.Success.getCode()) {
            throw new RuntimeException(r.getMessage());
        }
    }

    private void populateResponse(R<?> r, Exchange exchange) {
        Message out = exchange.getMessage();
        out.setHeader("CamelMilvusOperationStatus", (Object)r.getStatus());
        out.setHeader("CamelMilvusOperationStatusValue", (Object)r.getStatus());
        out.setBody(r.getData());
    }
}

