/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.server.internal;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.camel.RuntimeCamelException;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilterContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelServerItem {
    private static final Logger LOG = LoggerFactory.getLogger(CamelServerItem.class);
    private final String itemId;
    private final UaObjectNode baseNode;
    private final UaVariableNode item;
    private final Set<Consumer<DataValue>> listeners = new CopyOnWriteArraySet<Consumer<DataValue>>();
    private DataValue value = new DataValue(StatusCode.BAD);

    public CamelServerItem(String itemId, UaNodeContext nodeContext, UShort namespaceIndex, UaObjectNode baseNode) {
        this.itemId = itemId;
        this.baseNode = baseNode;
        NodeId nodeId = new NodeId(namespaceIndex, itemId);
        QualifiedName qname = new QualifiedName(namespaceIndex, itemId);
        LocalizedText displayName = LocalizedText.english((String)itemId);
        final Predicate<AttributeId> filter = arg_0 -> AttributeId.Value.equals(arg_0);
        this.item = UaVariableNode.build((UaNodeContext)nodeContext, builder -> builder.setNodeId(nodeId).setBrowseName(qname).setDisplayName(displayName).setAccessLevel(AccessLevel.toValue((Set)AccessLevel.READ_WRITE)).setUserAccessLevel(AccessLevel.toValue((Set)AccessLevel.READ_WRITE)).addAttributeFilter(new AttributeFilter(){

            public @Nullable Object getAttribute(AttributeFilterContext ctx, AttributeId attributeId) {
                if (filter.test(attributeId) && ctx.getSession().isPresent()) {
                    return CamelServerItem.this.getDataValue();
                }
                return ctx.getAttribute(attributeId);
            }

            public void setAttribute(AttributeFilterContext ctx, AttributeId attributeId, @Nullable Object value) {
                if (filter.test(attributeId) && ctx.getSession().isPresent()) {
                    CamelServerItem.this.setDataValue((DataValue)value);
                }
                ctx.setAttribute(attributeId, value);
            }
        }).buildAndAdd());
        baseNode.addComponent((UaNode)this.item);
    }

    public void dispose() {
        this.baseNode.removeComponent((UaNode)this.item);
        this.listeners.clear();
    }

    public void addWriteListener(Consumer<DataValue> consumer) {
        this.listeners.add(consumer);
    }

    public void removeWriteListener(Consumer<DataValue> consumer) {
        this.listeners.remove(consumer);
    }

    protected void setDataValue(DataValue value) {
        LOG.debug("setValue -> {}", (Object)value);
        this.runThrough(this.listeners, c -> c.accept(value));
    }

    protected <T> void runThrough(Collection<Consumer<T>> list, Consumer<Consumer<T>> consumer) {
        LinkedList<Exception> errors = null;
        for (Consumer<T> listener : list) {
            try {
                consumer.accept(listener);
            }
            catch (Exception e) {
                if (errors == null) {
                    errors = new LinkedList<Exception>();
                }
                errors.add(e);
            }
        }
        if (errors == null || errors.isEmpty()) {
            return;
        }
        RuntimeCamelException ex = new RuntimeCamelException((Throwable)errors.pollFirst());
        errors.forEach(((RuntimeException)ex)::addSuppressed);
        throw ex;
    }

    protected DataValue getDataValue() {
        return this.value;
    }

    public void update(Object value) {
        this.value = value instanceof DataValue ? (DataValue)value : (value instanceof Variant ? new DataValue((Variant)value, StatusCode.GOOD, DateTime.now()) : new DataValue(new Variant(value), StatusCode.GOOD, DateTime.now()));
    }

    public String toString() {
        return "[CamelServerItem - '" + this.itemId + "']";
    }
}

