/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.server.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.milo.server.internal.CamelServerItem;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.AddressSpace;
import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.opcua.sdk.server.ManagedNamespaceWithLifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.dtd.BinaryDataTypeDictionaryManager;
import org.eclipse.milo.opcua.sdk.server.items.DataItem;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.nodes.UaFolderNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.util.SubscriptionModel;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelNamespace
extends ManagedNamespaceWithLifecycle {
    private final SubscriptionModel subscriptionModel;
    private UaObjectNode itemsObject;
    private UaFolderNode folder;
    private final Map<String, CamelServerItem> itemMap = new HashMap<String, CamelServerItem>();
    private final BinaryDataTypeDictionaryManager dictionaryManager;
    private final Logger log = LoggerFactory.getLogger(CamelNamespace.class);

    public CamelNamespace(String namespaceUri, OpcUaServer server) {
        super(server, namespaceUri);
        this.subscriptionModel = new SubscriptionModel(server, (AddressSpace)this);
        this.dictionaryManager = new BinaryDataTypeDictionaryManager(this.getNodeContext(), namespaceUri);
        this.getLifecycleManager().addLifecycle((Lifecycle)this.dictionaryManager);
        this.getLifecycleManager().addLifecycle((Lifecycle)this.subscriptionModel);
        this.getLifecycleManager().addStartupTask(this::createNodes);
    }

    protected void createNodes() {
        NodeId nodeId = this.newNodeId("camel");
        QualifiedName name = this.newQualifiedName("camel");
        LocalizedText displayName = LocalizedText.english((String)"Camel");
        this.folder = new UaFolderNode(this.getNodeContext(), nodeId, name, displayName);
        this.getNodeManager().addNode((Node)this.folder);
        NodeId nodeId2 = this.newNodeId("items");
        QualifiedName name2 = this.newQualifiedName("items");
        LocalizedText displayName2 = LocalizedText.english((String)"Items");
        this.itemsObject = UaObjectNode.build((UaNodeContext)this.getNodeContext(), builder -> builder.setNodeId(nodeId2).setBrowseName(name2).setDisplayName(displayName2).setTypeDefinition(Identifiers.FolderType).buildAndAdd());
        this.folder.addComponent((UaNode)this.itemsObject);
        this.getNodeManager().addNode((Node)this.itemsObject);
        this.folder.addReference(new Reference(this.folder.getNodeId(), Identifiers.Organizes, Identifiers.ObjectsFolder.expanded(), false));
        this.itemsObject.addReference(new Reference(nodeId, Identifiers.HasComponent, Identifiers.ObjectNode.expanded(), Reference.Direction.INVERSE));
    }

    public void onDataItemsCreated(List<DataItem> dataItems) {
        this.log.trace("onDataItemsCreated");
        this.subscriptionModel.onDataItemsCreated(dataItems);
    }

    public void onDataItemsModified(List<DataItem> dataItems) {
        this.log.trace("onDataItemsModified");
        this.subscriptionModel.onDataItemsModified(dataItems);
    }

    public void onDataItemsDeleted(List<DataItem> dataItems) {
        this.log.trace("onDataItemsDeleted");
        this.subscriptionModel.onDataItemsDeleted(dataItems);
    }

    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        this.log.trace("onMonitoringModeChanged");
        this.subscriptionModel.onMonitoringModeChanged(monitoredItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CamelServerItem getOrAddItem(String itemId) {
        CamelNamespace camelNamespace = this;
        synchronized (camelNamespace) {
            return this.itemMap.computeIfAbsent(itemId, k -> new CamelServerItem(itemId, this.getNodeContext(), this.getNamespaceIndex(), this.itemsObject));
        }
    }
}

