/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.server;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.milo.server.MiloServerEndpoint;
import org.apache.camel.component.milo.server.internal.CamelServerItem;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiloServerProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MiloServerProducer.class);
    private CamelServerItem item;

    public MiloServerProducer(MiloServerEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public MiloServerEndpoint getEndpoint() {
        return (MiloServerEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.item = this.getEndpoint().getItem();
    }

    public void process(Exchange exchange) throws Exception {
        Object value = exchange.getIn().getBody();
        LOG.trace("Update item value - {} = {}", (Object)this.item, value);
        this.item.update(value);
    }
}

