/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.server;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.milo.KeyStoreLoader;
import org.apache.camel.component.milo.server.MiloServerEndpoint;
import org.apache.camel.component.milo.server.internal.CamelNamespace;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.eclipse.milo.opcua.sdk.server.EndpointConfig;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.OpcUaServerConfig;
import org.eclipse.milo.opcua.sdk.server.OpcUaServerConfigBuilder;
import org.eclipse.milo.opcua.sdk.server.identity.AnonymousIdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.UsernameIdentityValidator;
import org.eclipse.milo.opcua.sdk.server.util.HostnameUtil;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.CertificateFactory;
import org.eclipse.milo.opcua.stack.core.security.CertificateGroup;
import org.eclipse.milo.opcua.stack.core.security.CertificateManager;
import org.eclipse.milo.opcua.stack.core.security.CertificateQuarantine;
import org.eclipse.milo.opcua.stack.core.security.CertificateStore;
import org.eclipse.milo.opcua.stack.core.security.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.DefaultApplicationGroup;
import org.eclipse.milo.opcua.stack.core.security.DefaultCertificateManager;
import org.eclipse.milo.opcua.stack.core.security.DefaultServerCertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.FileBasedCertificateQuarantine;
import org.eclipse.milo.opcua.stack.core.security.FileBasedTrustListManager;
import org.eclipse.milo.opcua.stack.core.security.MemoryCertificateStore;
import org.eclipse.milo.opcua.stack.core.security.RsaSha256CertificateFactory;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.security.TrustListManager;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.transport.server.tcp.OpcTcpServerTransport;
import org.eclipse.milo.opcua.stack.transport.server.tcp.OpcTcpServerTransportConfig;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="milo-server")
public class MiloServerComponent
extends DefaultComponent {
    public static final String DEFAULT_NAMESPACE_URI = "urn:org:apache:camel";
    private static final Logger LOG = LoggerFactory.getLogger(MiloServerComponent.class);
    private static final String URL_CHARSET = "UTF-8";
    private final List<Runnable> runOnStop = new LinkedList<Runnable>();
    private OpcUaServerConfigBuilder opcServerConfig;
    private OpcUaServer server;
    private CamelNamespace namespace;
    @Metadata
    private int port;
    @Metadata
    private List<String> bindAddresses;
    @Metadata(defaultValue="urn:org:apache:camel")
    private String namespaceUri = "urn:org:apache:camel";
    @Metadata
    private String productUri;
    @Metadata
    private String applicationUri;
    @Metadata
    private String applicationName;
    @Metadata
    private String path;
    @Metadata
    private BuildInfo buildInfo;
    @Metadata(label="security")
    private Boolean enableAnonymousAuthentication;
    @Metadata(label="security")
    private CertificateManager certificateManager;
    @Metadata(label="security")
    private String securityPoliciesById;
    @Metadata(label="security")
    private Set<SecurityPolicy> securityPolicies;
    @Metadata(label="security", secret=true)
    private String userAuthenticationCredentials;
    @Metadata(label="security")
    private String usernameSecurityPolicyUri = OpcUaServerConfig.USER_TOKEN_POLICY_USERNAME.getSecurityPolicyUri();
    @Metadata(label="security")
    private String defaultCertificateValidator;
    @Metadata(label="security")
    private CertificateValidator certificateValidator;
    @Metadata(label="security")
    private X509Certificate certificate;
    @Metadata(label="security")
    private CertificateQuarantine certificateQuarantine;
    @Metadata(label="security")
    private CertificateGroup certificateGroup;

    public MiloServerComponent() {
        this.opcServerConfig = null;
    }

    public MiloServerComponent(OpcUaServerConfig serverConfig) {
        this.opcServerConfig = OpcUaServerConfig.copy((OpcUaServerConfig)serverConfig);
    }

    public CamelNamespace getNamespace() {
        return this.namespace;
    }

    protected void doStart() throws Exception {
        OpcUaServerConfig serverConfig = this.buildServerConfig();
        this.server = new OpcUaServer(serverConfig, transportProfile -> {
            if (transportProfile == TransportProfile.TCP_UASC_UABINARY || transportProfile == TransportProfile.HTTPS_UABINARY) {
                OpcTcpServerTransportConfig transportConfig = OpcTcpServerTransportConfig.newBuilder().build();
                return new OpcTcpServerTransport(transportConfig);
            }
            throw new UnsupportedOperationException("Unsupported transport profile: " + String.valueOf(transportProfile));
        });
        this.namespace = new CamelNamespace(this.namespaceUri, this.server);
        this.namespace.startup();
        super.doStart();
        this.server.startup().get();
    }

    private OpcUaServerConfig buildServerConfig() {
        OpcUaServerConfigBuilder serverConfig = this.opcServerConfig != null ? this.opcServerConfig : this.createDefaultConfiguration();
        this.securityPolicies = this.createSecurityPolicies();
        Map userMap = this.createUserMap();
        if (!userMap.isEmpty() || this.enableAnonymousAuthentication != null) {
            boolean allowAnonymous = Boolean.TRUE.equals(this.enableAnonymousAuthentication);
            UsernameIdentityValidator identityValidator = new UsernameIdentityValidator(challenge -> {
                String pwd = (String)userMap.get(challenge.getUsername());
                if (pwd == null) {
                    return false;
                }
                return pwd.equals(challenge.getPassword());
            });
            serverConfig.setIdentityValidator((IdentityValidator)identityValidator);
            LinkedList<UserTokenPolicy> tokenPolicies = new LinkedList<UserTokenPolicy>();
            if (allowAnonymous) {
                tokenPolicies.add(OpcUaServerConfig.USER_TOKEN_POLICY_ANONYMOUS);
            }
            if (!userMap.isEmpty()) {
                tokenPolicies.add(this.getUsernamePolicy());
            }
            serverConfig.setEndpoints(this.createEndpointConfigs(tokenPolicies));
        } else {
            serverConfig.setEndpoints(this.createEndpointConfigs(null, this.securityPolicies));
        }
        if (this.certificateValidator != null) {
            LOG.debug("Using validator: {}", (Object)this.certificateValidator);
            if (this.certificateValidator instanceof Closeable) {
                this.runOnStop(() -> {
                    try {
                        LOG.debug("Closing: {}", (Object)this.certificateValidator);
                        ((Closeable)this.certificateValidator).close();
                    }
                    catch (IOException e) {
                        LOG.debug("Failed to close. This exception is ignored.", (Throwable)e);
                    }
                });
            }
            serverConfig.setCertificateManager((CertificateManager)new DefaultCertificateManager(this.certificateQuarantine, this.certificateGroup));
        }
        return serverConfig.build();
    }

    private OpcUaServerConfigBuilder createDefaultConfiguration() {
        OpcUaServerConfigBuilder cfg = OpcUaServerConfig.builder();
        cfg.setEndpoints(this.createEndpointConfigs(null));
        cfg.setApplicationName(LocalizedText.english((String)(this.applicationName == null ? "Apache Camel Milo Server" : this.applicationName)));
        cfg.setApplicationUri("urn:org:apache:camel:milo:server");
        cfg.setProductUri("urn:org:apache:camel:milo");
        cfg.setCertificateManager(this.certificateManager);
        if (this.productUri != null) {
            cfg.setProductUri(this.productUri);
        }
        if (this.applicationUri != null) {
            cfg.setApplicationUri(this.applicationUri);
        }
        if (this.buildInfo != null) {
            cfg.setBuildInfo(this.buildInfo);
        }
        if (Boolean.getBoolean("org.apache.camel.milo.server.default.enableAnonymous")) {
            cfg.setIdentityValidator((IdentityValidator)AnonymousIdentityValidator.INSTANCE);
        }
        return cfg;
    }

    private Set<EndpointConfig> createEndpointConfigs(List<UserTokenPolicy> userTokenPolicies) {
        return this.createEndpointConfigs(userTokenPolicies, this.securityPolicies);
    }

    private Set<EndpointConfig> createEndpointConfigs(List<UserTokenPolicy> userTokenPolicies, Set<SecurityPolicy> securityPolicies) {
        LinkedHashSet<EndpointConfig> endpointConfigs = new LinkedHashSet<EndpointConfig>();
        if (this.bindAddresses == null) {
            this.bindAddresses = Arrays.asList("localhost");
        }
        for (String bindAddress : this.bindAddresses) {
            UserTokenPolicy[] userTokenPolicyArray;
            boolean anonymous;
            LinkedHashSet<String> hostnames = new LinkedHashSet<String>();
            hostnames.add(HostnameUtil.getHostname());
            hostnames.addAll(HostnameUtil.getHostnames((String)bindAddress));
            boolean bl = anonymous = this.enableAnonymousAuthentication != null && this.enableAnonymousAuthentication != false || Boolean.getBoolean("org.apache.camel.milo.server.default.enableAnonymous");
            if (userTokenPolicies != null) {
                userTokenPolicyArray = userTokenPolicies.toArray(new UserTokenPolicy[userTokenPolicies.size()]);
            } else if (anonymous) {
                UserTokenPolicy[] userTokenPolicyArray2 = new UserTokenPolicy[3];
                userTokenPolicyArray2[0] = OpcUaServerConfig.USER_TOKEN_POLICY_ANONYMOUS;
                userTokenPolicyArray2[1] = OpcUaServerConfig.USER_TOKEN_POLICY_USERNAME;
                userTokenPolicyArray = userTokenPolicyArray2;
                userTokenPolicyArray2[2] = OpcUaServerConfig.USER_TOKEN_POLICY_X509;
            } else {
                UserTokenPolicy[] userTokenPolicyArray3 = new UserTokenPolicy[2];
                userTokenPolicyArray3[0] = OpcUaServerConfig.USER_TOKEN_POLICY_USERNAME;
                userTokenPolicyArray = userTokenPolicyArray3;
                userTokenPolicyArray3[1] = OpcUaServerConfig.USER_TOKEN_POLICY_X509;
            }
            UserTokenPolicy[] tokenPolicies = userTokenPolicyArray;
            for (String hostname : hostnames) {
                EndpointConfig.Builder builder = EndpointConfig.newBuilder().setBindAddress(bindAddress).setHostname(hostname).setCertificate(this.certificate).setPath(this.path == null ? "" : this.path).addTokenPolicies(tokenPolicies);
                if (securityPolicies == null || securityPolicies.contains(SecurityPolicy.None)) {
                    EndpointConfig.Builder noSecurityBuilder = builder.copy().setSecurityPolicy(SecurityPolicy.None).setSecurityMode(MessageSecurityMode.None);
                    endpointConfigs.add(this.buildTcpEndpoint(noSecurityBuilder));
                    endpointConfigs.add(this.buildHttpsEndpoint(noSecurityBuilder));
                } else if (securityPolicies.contains(SecurityPolicy.Basic256Sha256)) {
                    endpointConfigs.add(this.buildTcpEndpoint(builder.copy().setSecurityPolicy(SecurityPolicy.Basic256Sha256).setSecurityMode(MessageSecurityMode.SignAndEncrypt)));
                } else if (securityPolicies.contains(SecurityPolicy.Basic256Sha256)) {
                    endpointConfigs.add(this.buildHttpsEndpoint(builder.copy().setSecurityPolicy(SecurityPolicy.Basic256Sha256).setSecurityMode(MessageSecurityMode.Sign)));
                }
                EndpointConfig.Builder discoveryBuilder = builder.copy().setPath("/discovery").setSecurityPolicy(SecurityPolicy.None).setSecurityMode(MessageSecurityMode.None);
                endpointConfigs.add(this.buildTcpEndpoint(discoveryBuilder));
                endpointConfigs.add(this.buildHttpsEndpoint(discoveryBuilder));
            }
        }
        return endpointConfigs;
    }

    private EndpointConfig buildTcpEndpoint(EndpointConfig.Builder base) {
        return base.copy().setTransportProfile(TransportProfile.TCP_UASC_UABINARY).setBindPort(this.port).build();
    }

    private EndpointConfig buildHttpsEndpoint(EndpointConfig.Builder base) {
        return base.copy().setTransportProfile(TransportProfile.HTTPS_UABINARY).setBindPort(this.port).build();
    }

    private UserTokenPolicy getUsernamePolicy() {
        if (this.usernameSecurityPolicyUri == null || this.usernameSecurityPolicyUri.isEmpty()) {
            return OpcUaServerConfig.USER_TOKEN_POLICY_USERNAME;
        }
        return new UserTokenPolicy("username", UserTokenType.UserName, null, null, this.usernameSecurityPolicyUri);
    }

    private void runOnStop(Runnable runnable) {
        this.runOnStop.add(runnable);
    }

    private Map createUserMap() {
        Map<String, String> userMap = null;
        if (this.userAuthenticationCredentials != null) {
            userMap = new HashMap();
            for (String creds : this.userAuthenticationCredentials.split(",")) {
                String[] toks = creds.split(":", 2);
                if (toks.length != 2) continue;
                try {
                    userMap.put(URLDecoder.decode(toks[0], URL_CHARSET), URLDecoder.decode(toks[1], URL_CHARSET));
                }
                catch (UnsupportedEncodingException e) {
                    LOG.warn("Failed to decode user map entry", (Throwable)e);
                }
            }
        }
        return userMap != null ? userMap : Collections.emptyMap();
    }

    protected void doStop() throws Exception {
        if (this.server != null) {
            this.server.shutdown();
        }
        super.doStop();
        this.runOnStop.forEach(runnable -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOG.warn("Failed to run on stop", (Throwable)e);
            }
        });
        this.runOnStop.clear();
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MiloServerEndpoint endpoint = new MiloServerEndpoint(uri, remaining, (Component)this);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public void loadServerCertificate(KeyStoreLoader.Result result) {
        Objects.requireNonNull(result, "Setting a null is not supported. call setCertificateManager(null) instead.)");
        this.loadServerCertificate(result.getKeyPair(), result.getCertificate());
    }

    public void loadServerCertificate(KeyPair keyPair, X509Certificate certificate) {
        this.certificate = certificate;
        if (this.certificateGroup != null) {
            try {
                this.certificateGroup.updateCertificate(NodeIds.ServerConfiguration_CertificateGroups_DefaultApplicationGroup, keyPair, new X509Certificate[]{certificate});
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    private Set<SecurityPolicy> createSecurityPolicies() {
        if (this.securityPoliciesById != null) {
            String[] ids = this.securityPoliciesById.split(",");
            EnumSet<SecurityPolicy> policies = EnumSet.noneOf(SecurityPolicy.class);
            for (String policyName : ids) {
                SecurityPolicy policy = SecurityPolicy.fromUriSafe((String)policyName).orElseGet(() -> SecurityPolicy.valueOf((String)policyName));
                policies.add(policy);
            }
            if (this.securityPolicies == null) {
                this.securityPolicies = new HashSet<SecurityPolicy>();
            }
            this.securityPolicies.addAll(policies);
        }
        return this.securityPolicies;
    }

    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    public void setApplicationName(String applicationName) {
        Objects.requireNonNull(applicationName);
        this.applicationName = applicationName;
    }

    public void setPath(String path) {
        Objects.requireNonNull(path);
        this.path = path;
    }

    public void setApplicationUri(String applicationUri) {
        Objects.requireNonNull(applicationUri);
        this.applicationUri = applicationUri;
    }

    public void setProductUri(String productUri) {
        Objects.requireNonNull(productUri);
        this.productUri = productUri;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSecurityPolicies(Set<SecurityPolicy> securityPolicies) {
        this.securityPolicies = securityPolicies == null || securityPolicies.isEmpty() ? EnumSet.noneOf(SecurityPolicy.class) : EnumSet.copyOf(securityPolicies);
        this.securityPoliciesById = null;
    }

    public void setSecurityPoliciesById(String securityPoliciesById) {
        this.securityPoliciesById = securityPoliciesById;
    }

    public String getSecurityPoliciesById() {
        return this.securityPoliciesById;
    }

    public void setUserAuthenticationCredentials(String userAuthenticationCredentials) {
        this.userAuthenticationCredentials = userAuthenticationCredentials;
    }

    public String getUserAuthenticationCredentials() {
        return this.userAuthenticationCredentials;
    }

    public void setEnableAnonymousAuthentication(boolean enableAnonymousAuthentication) {
        this.enableAnonymousAuthentication = enableAnonymousAuthentication;
    }

    public void setUsernameSecurityPolicyUri(SecurityPolicy usernameSecurityPolicy) {
        this.usernameSecurityPolicyUri = usernameSecurityPolicy.getUri();
    }

    public void setUsernameSecurityPolicyUri(String usernameSecurityPolicyUri) {
        this.usernameSecurityPolicyUri = usernameSecurityPolicyUri;
    }

    public void setBindAddresses(String bindAddresses) {
        this.bindAddresses = bindAddresses != null ? Arrays.asList(bindAddresses.split(",")) : null;
    }

    public void setBuildInfo(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    public void setCertificateManager(CertificateManager certificateManager) {
        this.certificateManager = certificateManager != null ? certificateManager : new DefaultCertificateManager(this.certificateQuarantine);
    }

    public void setCertificateValidator(CertificateValidator certificateValidator) {
        this.certificateValidator = certificateValidator;
    }

    public void setDefaultCertificateValidator(String defaultCertificateValidator) {
        this.defaultCertificateValidator = defaultCertificateValidator;
        try {
            Path certificateConfigurationPath = new File(defaultCertificateValidator).toPath();
            FileBasedTrustListManager trustListManager = FileBasedTrustListManager.createAndInitialize((Path)certificateConfigurationPath);
            this.certificateQuarantine = this.createCertificateQuarantine(certificateConfigurationPath);
            this.certificateValidator = new DefaultServerCertificateValidator((TrustListManager)trustListManager, this.certificateQuarantine);
            this.certificateGroup = DefaultApplicationGroup.createAndInitialize((TrustListManager)trustListManager, (CertificateStore)new MemoryCertificateStore(), (CertificateFactory)new RsaSha256CertificateFactory(){

                protected X509Certificate[] createRsaSha256CertificateChain(KeyPair keyPair) {
                    return new X509Certificate[]{MiloServerComponent.this.certificate};
                }
            }, (CertificateValidator)this.certificateValidator);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private CertificateQuarantine createCertificateQuarantine(Path certificateConfigurationPath) throws IOException {
        Path certificateQuarantineDir = certificateConfigurationPath.resolve("rejected").resolve("certs");
        FileBasedCertificateQuarantine certificateQuarantine = FileBasedCertificateQuarantine.create((Path)certificateQuarantineDir);
        if (!Files.exists(certificateConfigurationPath, new LinkOption[0])) {
            Files.createDirectories(certificateConfigurationPath, new FileAttribute[0]);
        }
        return certificateQuarantine;
    }

    public String getDefaultCertificateValidator() {
        return this.defaultCertificateValidator;
    }

    public int getPort() {
        return this.port;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public OpcUaServer getServer() {
        return this.server;
    }

    public Boolean isEnableAnonymousAuthentication() {
        return this.enableAnonymousAuthentication;
    }

    public CertificateManager getCertificateManager() {
        return this.certificateManager;
    }

    public Set<SecurityPolicy> getSecurityPolicies() {
        return this.securityPolicies;
    }

    public String getUsernameSecurityPolicyUri() {
        return this.usernameSecurityPolicyUri;
    }

    public List<String> getBindAddresses() {
        return this.bindAddresses;
    }

    public CertificateValidator getCertificateValidator() {
        return this.certificateValidator;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public String getProductUri() {
        return this.productUri;
    }

    public String getApplicationUri() {
        return this.applicationUri;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getPath() {
        return this.path;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    private static final class DenyAllCertificateValidator
    implements CertificateValidator {
        public static final CertificateValidator INSTANCE = new DenyAllCertificateValidator();

        private DenyAllCertificateValidator() {
        }

        public void validateCertificateChain(List<X509Certificate> certificateChain, @Nullable String applicationUri, @Nullable String[] validHostnames) throws UaException {
            throw new UaException(0x80180000L);
        }
    }
}

