/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.browse;

import java.util.Objects;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.milo.MiloConstants;
import org.apache.camel.component.milo.browse.MiloBrowseComponent;
import org.apache.camel.component.milo.browse.MiloBrowseProducer;
import org.apache.camel.component.milo.client.MiloClientConfiguration;
import org.apache.camel.component.milo.client.MiloClientConnection;
import org.apache.camel.component.milo.client.MiloClientConnectionManager;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.15.0", scheme="milo-browse", syntax="milo-browse:endpointUri", title="OPC UA Browser", category={Category.IOT}, producerOnly=true, headersClass=MiloConstants.class)
public class MiloBrowseEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(MiloBrowseEndpoint.class);
    private final MiloClientConnectionManager connectionManager;
    @UriPath
    @Metadata(required=true)
    private final String endpointUri;
    @UriParam(defaultValue="ns=0;id=84", defaultValueNote="Root folder as per OPC-UA spec")
    private String node = Identifiers.RootFolder.toParseableString();
    @UriParam(defaultValue="Forward", enums="Forward,Inverse,Both", defaultValueNote="The direction to browse; see org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection")
    private BrowseDirection direction = BrowseDirection.Forward;
    @UriParam(defaultValue="true")
    private boolean includeSubTypes = true;
    @UriParam(defaultValue="Variable,Object,DataType", defaultValueNote="Comma-separated node class list; see org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass")
    private String nodeClasses = String.valueOf(NodeClass.Variable) + "," + String.valueOf(NodeClass.Object) + "," + String.valueOf(NodeClass.DataType);
    private int nodeClassMask = NodeClass.Variable.getValue() | NodeClass.Object.getValue() | NodeClass.DataType.getValue();
    @UriParam(defaultValue="false", defaultValueNote="Whether to recursively browse sub-types: true|false")
    private boolean recursive;
    @UriParam(defaultValue="3", defaultValueNote="Maximum depth for browsing recursively (only if recursive = true)")
    private int depth = 3;
    @UriParam(defaultValue="None", defaultValueNote="Regular filter expression matching node ids")
    private String filter;
    @UriParam(defaultValue="10", defaultValueNote="Maximum number of node ids requested per browse call (applies to browsing sub-types only; only if recursive = true)")
    private int maxNodeIdsPerRequest = 10;
    @UriParam
    private MiloClientConfiguration configuration;

    public MiloBrowseEndpoint(String uri, MiloBrowseComponent component, String endpointUri, MiloClientConnectionManager connectionManager) {
        super(uri, (Component)component);
        Objects.requireNonNull(component);
        Objects.requireNonNull(endpointUri);
        Objects.requireNonNull(connectionManager);
        this.endpointUri = endpointUri;
        this.connectionManager = connectionManager;
    }

    public void setConfiguration(MiloClientConfiguration configuration) {
        this.configuration = configuration;
    }

    public MiloClientConfiguration getConfiguration() {
        return this.configuration;
    }

    public Producer createProducer() throws Exception {
        return new MiloBrowseProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException(MiloBrowseEndpoint.class.getName() + " doesn't support a consumer");
    }

    public MiloClientConnection createConnection() {
        return this.connectionManager.createConnection(this.configuration, null);
    }

    public void releaseConnection(MiloClientConnection connection) {
        this.connectionManager.releaseConnection(connection);
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getNode() {
        return this.node;
    }

    NodeId getNodeId() {
        return this.getNodeId(this.node);
    }

    NodeId getNodeId(String nodeId) {
        if (nodeId != null) {
            return NodeId.parse((String)nodeId);
        }
        return null;
    }

    public BrowseDirection getDirection() {
        return this.direction;
    }

    public boolean isIncludeSubTypes() {
        return this.includeSubTypes;
    }

    public void setIncludeSubTypes(boolean includeSubTypes) {
        this.includeSubTypes = includeSubTypes;
    }

    public String getNodeClasses() {
        return this.nodeClasses;
    }

    public void setNodeClasses(String nodeClasses) {
        this.nodeClasses = nodeClasses;
        String[] nodeClassArray = nodeClasses.split(",");
        int mask = 0;
        try {
            for (String nodeClass : nodeClassArray) {
                mask |= NodeClass.valueOf((String)nodeClass).getValue();
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid node class specified: " + nodeClasses, e);
        }
        LOG.debug("Node class list conversion {} -> {}", (Object)nodeClasses, (Object)mask);
        this.nodeClassMask = mask;
    }

    public int getNodeClassMask() {
        return this.nodeClassMask;
    }

    public void setDirection(BrowseDirection direction) {
        this.direction = direction;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public int getMaxNodeIdsPerRequest() {
        return this.maxNodeIdsPerRequest;
    }

    public void setMaxNodeIdsPerRequest(int maxNodeIdsPerRequest) {
        this.maxNodeIdsPerRequest = maxNodeIdsPerRequest;
    }
}

