/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.microprofile.health;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.microprofile.health.CamelMicroProfileHealthHelper;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

final class CamelMicroProfileHealthCheck
implements org.eclipse.microprofile.health.HealthCheck {
    private final CamelContext camelContext;
    private final HealthCheck camelHealthCheck;

    CamelMicroProfileHealthCheck(CamelContext camelContext, HealthCheck camelHealthCheck) {
        this.camelContext = camelContext;
        this.camelHealthCheck = camelHealthCheck;
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.builder();
        builder.name(this.camelHealthCheck.getId());
        builder.up();
        HealthCheck.Result result = this.camelHealthCheck.call();
        Map details = result.getDetails();
        boolean enabled = true;
        if (details.containsKey("check.enabled")) {
            enabled = (Boolean)details.get("check.enabled");
        }
        if (enabled) {
            HealthCheckRegistry registry = HealthCheckRegistry.get((CamelContext)this.camelContext);
            CamelMicroProfileHealthHelper.applyHealthDetail(builder, result, registry.getExposureLevel());
            if (result.getState() == HealthCheck.State.DOWN) {
                builder.down();
            }
        } else {
            builder.withData("check.enabled", false);
        }
        return builder.build();
    }
}

