/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.faulttolerance;

import io.smallrye.faulttolerance.api.CircuitBreakerMaintenance;
import io.smallrye.faulttolerance.api.CircuitBreakerState;
import io.smallrye.faulttolerance.api.TypedGuard;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.Traceable;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.microprofile.faulttolerance.FaultToleranceConfiguration;
import org.apache.camel.processor.PooledExchangeTask;
import org.apache.camel.processor.PooledExchangeTaskFactory;
import org.apache.camel.processor.PooledTaskFactory;
import org.apache.camel.processor.PrototypeTaskFactory;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.UnitOfWorkHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed FaultTolerance Processor")
public class FaultToleranceProcessor
extends AsyncProcessorSupport
implements CamelContextAware,
Navigate<Processor>,
Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(FaultToleranceProcessor.class);
    private CamelContext camelContext;
    private String id;
    private String routeId;
    private final FaultToleranceConfiguration config;
    private final Processor processor;
    private final Processor fallbackProcessor;
    private ExecutorService executorService;
    private boolean shutdownExecutorService;
    private ProcessorExchangeFactory processorExchangeFactory;
    private PooledExchangeTaskFactory taskFactory;
    private PooledExchangeTaskFactory fallbackTaskFactory;
    private TypedGuard.Builder<Exchange> typedGuardBuilder;
    private TypedGuard<Exchange> typedGuard;

    public FaultToleranceProcessor(FaultToleranceConfiguration config, Processor processor, Processor fallbackProcessor) {
        this.config = config;
        this.processor = processor;
        this.fallbackProcessor = fallbackProcessor;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public TypedGuard<Exchange> getTypedGuard() {
        return this.typedGuard;
    }

    public void setTypedGuard(TypedGuard<Exchange> typedGuard) {
        this.typedGuard = typedGuard;
    }

    public boolean isShutdownExecutorService() {
        return this.shutdownExecutorService;
    }

    public void setShutdownExecutorService(boolean shutdownExecutorService) {
        this.shutdownExecutorService = shutdownExecutorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getTraceLabel() {
        return "faultTolerance";
    }

    @ManagedAttribute(description="Returns the current delay in milliseconds.")
    public long getDelay() {
        return this.config.getDelay();
    }

    @ManagedAttribute(description="Returns the current failure rate in percentage.")
    public float getFailureRate() {
        return this.config.getFailureRatio();
    }

    @ManagedAttribute(description="Returns the current request volume threshold.")
    public int getRequestVolumeThreshold() {
        return this.config.getRequestVolumeThreshold();
    }

    @ManagedAttribute(description="Returns the current success threshold.")
    public int getSuccessThreshold() {
        return this.config.getSuccessThreshold();
    }

    @ManagedAttribute(description="Is timeout enabled")
    public boolean isTimeoutEnabled() {
        return this.config.isTimeoutEnabled();
    }

    @ManagedAttribute(description="The timeout wait duration")
    public long getTimeoutDuration() {
        return this.config.getTimeoutDuration();
    }

    @ManagedAttribute(description="The timeout pool size for the thread pool")
    public int getTimeoutPoolSize() {
        return this.config.getTimeoutPoolSize();
    }

    @ManagedAttribute(description="Is bulkhead enabled")
    public boolean isBulkheadEnabled() {
        return this.config.isBulkheadEnabled();
    }

    @ManagedAttribute(description="The max amount of concurrent calls the bulkhead will support.")
    public int getBulkheadMaxConcurrentCalls() {
        return this.config.getBulkheadMaxConcurrentCalls();
    }

    @ManagedAttribute(description="The task queue size for holding waiting tasks to be processed by the bulkhead")
    public int getBulkheadWaitingTaskQueue() {
        return this.config.getBulkheadWaitingTaskQueue();
    }

    @ManagedAttribute(description="Returns the current state of the circuit breaker")
    public String getCircuitBreakerState() {
        try {
            CircuitBreakerState circuitBreakerState = CircuitBreakerMaintenance.get().currentState(this.id);
            return circuitBreakerState.name();
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        answer.add(this.processor);
        if (this.fallbackProcessor != null) {
            answer.add(this.fallbackProcessor);
        }
        return answer;
    }

    public boolean hasNext() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        block14: {
            exchange.setProperty(ExchangePropertyKey.TRY_ROUTE_BLOCK, (Object)true);
            task = (CircuitBreakerTask)this.taskFactory.acquire(exchange, callback);
            fallbackTask = null;
            try {
                try {
                    this.typedGuard.call((Callable)task);
                }
                catch (Exception e) {
                    if (this.fallbackProcessor != null) {
                        fallbackTask = (CircuitBreakerFallbackTask)this.fallbackTaskFactory.acquire(exchange, null);
                        fallbackTask.call();
                    }
                    throw e;
                }
                if (task == null) break block14;
            }
            catch (CircuitBreakerOpenException e) {
                block15: {
                    exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SUCCESSFUL_EXECUTION, (Object)false);
                    exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_FROM_FALLBACK, (Object)false);
                    exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SHORT_CIRCUITED, (Object)true);
                    exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_REJECTED, (Object)true);
                    if (task == null) break block15;
                    this.taskFactory.release((PooledExchangeTask)task);
                }
                if (fallbackTask != null) {
                    this.fallbackTaskFactory.release((PooledExchangeTask)fallbackTask);
                }
            }
            catch (Exception e) {
                block16: {
                    exchange.setException((Throwable)e);
                    if (task == null) break block16;
                    {
                        catch (Throwable var6_8) {
                            if (task != null) {
                                this.taskFactory.release((PooledExchangeTask)task);
                            }
                            if (fallbackTask != null) {
                                this.fallbackTaskFactory.release(fallbackTask);
                            }
                            throw var6_8;
                        }
                    }
                    this.taskFactory.release((PooledExchangeTask)task);
                }
                if (fallbackTask != null) {
                    this.fallbackTaskFactory.release((PooledExchangeTask)fallbackTask);
                } else {
                    ** GOTO lbl57
                }
            }
            this.taskFactory.release((PooledExchangeTask)task);
        }
        if (fallbackTask != null) {
            this.fallbackTaskFactory.release((PooledExchangeTask)fallbackTask);
        }
        exchange.removeProperty(ExchangePropertyKey.TRY_ROUTE_BLOCK);
        callback.done(true);
        return true;
    }

    protected void doBuild() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        boolean pooled = this.camelContext.getCamelContextExtension().getExchangeFactory().isPooled();
        if (pooled) {
            int capacity = this.camelContext.getCamelContextExtension().getExchangeFactory().getCapacity();
            this.taskFactory = new PooledTaskFactory(this.getId()){

                public PooledExchangeTask create(Exchange exchange, AsyncCallback callback) {
                    return new CircuitBreakerTask();
                }
            };
            this.taskFactory.setCapacity(capacity);
            this.fallbackTaskFactory = new PooledTaskFactory(this.getId()){

                public PooledExchangeTask create(Exchange exchange, AsyncCallback callback) {
                    return new CircuitBreakerFallbackTask();
                }
            };
            this.fallbackTaskFactory.setCapacity(capacity);
        } else {
            this.taskFactory = new PrototypeTaskFactory(){

                public PooledExchangeTask create(Exchange exchange, AsyncCallback callback) {
                    return new CircuitBreakerTask();
                }
            };
            this.fallbackTaskFactory = new PrototypeTaskFactory(){

                public PooledExchangeTask create(Exchange exchange, AsyncCallback callback) {
                    return new CircuitBreakerFallbackTask();
                }
            };
        }
        this.processorExchangeFactory = this.getCamelContext().getCamelContextExtension().getProcessorExchangeFactory().newProcessorExchangeFactory((Processor)this);
        this.processorExchangeFactory.setRouteId(this.getRouteId());
        this.processorExchangeFactory.setId(this.getId());
        ServiceHelper.buildService((Object[])new Object[]{this.processorExchangeFactory, this.taskFactory, this.fallbackTaskFactory, this.processor});
    }

    protected void doInit() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        ServiceHelper.initService((Object[])new Object[]{this.processorExchangeFactory, this.taskFactory, this.fallbackTaskFactory, this.processor});
        if (this.typedGuard == null) {
            this.typedGuardBuilder = TypedGuard.create(Exchange.class).withThreadOffload(true).withCircuitBreaker().name(this.id).delay(this.config.getDelay(), ChronoUnit.MILLIS).failureRatio((double)this.config.getFailureRatio()).requestVolumeThreshold(this.config.getRequestVolumeThreshold()).successThreshold(this.config.getSuccessThreshold()).done();
            if (this.config.isTimeoutEnabled()) {
                this.typedGuardBuilder.withTimeout().duration(this.config.getTimeoutDuration(), ChronoUnit.MILLIS).done();
            }
            if (this.config.isBulkheadEnabled()) {
                this.typedGuardBuilder.withBulkhead().queueSize(this.config.getBulkheadWaitingTaskQueue()).limit(this.config.getBulkheadMaxConcurrentCalls()).done();
            }
        }
    }

    protected void doStart() throws Exception {
        if (this.typedGuard == null) {
            if (this.executorService == null) {
                this.executorService = this.getCamelContext().getExecutorServiceManager().newCachedThreadPool((Object)this, "CamelMicroProfileFaultTolerance");
                this.shutdownExecutorService = true;
            }
            this.typedGuardBuilder.withThreadOffloadExecutor((Executor)this.executorService);
            this.typedGuard = this.typedGuardBuilder.build();
        }
        ServiceHelper.startService((Object[])new Object[]{this.processorExchangeFactory, this.taskFactory, this.fallbackTaskFactory, this.processor});
    }

    protected void doStop() throws Exception {
        if (this.shutdownExecutorService && this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
            this.executorService = null;
        }
        ServiceHelper.stopService((Object[])new Object[]{this.processorExchangeFactory, this.taskFactory, this.fallbackTaskFactory, this.processor});
        try {
            CircuitBreakerMaintenance.get().reset(this.id);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.processorExchangeFactory, this.taskFactory, this.fallbackTaskFactory, this.processor});
    }

    private final class CircuitBreakerTask
    implements PooledExchangeTask,
    Callable<Exchange> {
        private Exchange exchange;

        private CircuitBreakerTask() {
        }

        public void prepare(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
        }

        public void reset() {
            this.exchange = null;
        }

        public void run() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Exchange call() throws Exception {
            Exception cause;
            block12: {
                Exchange copy = null;
                UnitOfWork uow = null;
                this.exchange.getExchangeExtension().setInterruptable(false);
                try {
                    LOG.debug("Running processor: {} with exchange: {}", (Object)FaultToleranceProcessor.this.processor, (Object)this.exchange);
                    copy = FaultToleranceProcessor.this.processorExchangeFactory.createCorrelatedCopy(this.exchange, false);
                    if (copy.getUnitOfWork() != null) {
                        uow = copy.getUnitOfWork();
                    } else {
                        uow = PluginHelper.getUnitOfWorkFactory((CamelContext)copy.getContext()).createUnitOfWork(copy);
                        copy.getExchangeExtension().setUnitOfWork(uow);
                        Route route = ExchangeHelper.getRoute((Exchange)this.exchange);
                        if (route != null) {
                            uow.pushRoute(route);
                        }
                    }
                    FaultToleranceProcessor.this.processor.process(copy);
                    if (copy.getException() != null) {
                        this.exchange.setException((Throwable)copy.getException());
                    } else {
                        ExchangeHelper.copyResults((Exchange)this.exchange, (Exchange)copy);
                        this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SUCCESSFUL_EXECUTION, (Object)true);
                        this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_FROM_FALLBACK, (Object)false);
                        String state = FaultToleranceProcessor.this.getCircuitBreakerState();
                        if (state != null) {
                            this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_STATE, (Object)state);
                        }
                    }
                    UnitOfWorkHelper.doneUow((UnitOfWork)uow, (Exchange)copy);
                }
                catch (Exception e) {
                    this.exchange.setException((Throwable)e);
                    break block12;
                }
                finally {
                    UnitOfWorkHelper.doneUow(uow, copy);
                    cause = this.exchange.getException();
                }
                cause = this.exchange.getException();
            }
            FaultToleranceProcessor.this.processorExchangeFactory.release(this.exchange);
            if (cause != null) {
                throw RuntimeExchangeException.wrapRuntimeException((Throwable)cause);
            }
            return this.exchange;
        }
    }

    private final class CircuitBreakerFallbackTask
    implements PooledExchangeTask,
    Callable<Exchange> {
        private Exchange exchange;

        private CircuitBreakerFallbackTask() {
        }

        public void prepare(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
        }

        public void reset() {
            this.exchange = null;
        }

        public void run() {
        }

        @Override
        public Exchange call() throws Exception {
            String state = FaultToleranceProcessor.this.getCircuitBreakerState();
            if (state != null) {
                this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_STATE, (Object)state);
            }
            Exception throwable = this.exchange.getException();
            if (FaultToleranceProcessor.this.fallbackProcessor == null) {
                if (throwable instanceof TimeoutException) {
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SUCCESSFUL_EXECUTION, (Object)false);
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_FROM_FALLBACK, (Object)false);
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SHORT_CIRCUITED, (Object)false);
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_TIMED_OUT, (Object)true);
                    this.exchange.setException((Throwable)throwable);
                    return this.exchange;
                }
                if (throwable instanceof CircuitBreakerOpenException) {
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SUCCESSFUL_EXECUTION, (Object)false);
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_FROM_FALLBACK, (Object)false);
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SHORT_CIRCUITED, (Object)true);
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_REJECTED, (Object)true);
                    return this.exchange;
                }
                throw RuntimeExchangeException.wrapRuntimeException((Throwable)throwable);
            }
            this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SUCCESSFUL_EXECUTION, (Object)false);
            this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_FROM_FALLBACK, (Object)true);
            this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SHORT_CIRCUITED, (Object)true);
            if (this.exchange.getProperty(ExchangePropertyKey.FAILURE_ENDPOINT) == null) {
                this.exchange.setProperty(ExchangePropertyKey.FAILURE_ENDPOINT, this.exchange.getProperty(ExchangePropertyKey.TO_ENDPOINT));
            }
            this.exchange.setProperty(ExchangePropertyKey.EXCEPTION_HANDLED, (Object)true);
            this.exchange.setProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, (Object)this.exchange.getException());
            this.exchange.setRouteStop(false);
            this.exchange.setException(null);
            this.exchange.getExchangeExtension().setRedeliveryExhausted(false);
            try {
                LOG.debug("Running fallback: {} with exchange: {}", (Object)FaultToleranceProcessor.this.fallbackProcessor, (Object)this.exchange);
                FaultToleranceProcessor.this.fallbackProcessor.process(this.exchange);
                LOG.debug("Running fallback: {} with exchange: {} done", (Object)FaultToleranceProcessor.this.fallbackProcessor, (Object)this.exchange);
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
            }
            return this.exchange;
        }
    }
}

