/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.config;

import java.util.Properties;
import java.util.function.Predicate;
import org.apache.camel.spi.LoadablePropertiesSource;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.util.OrderedProperties;
import org.eclipse.microprofile.config.ConfigProvider;

@JdkService(value="properties-source-factory")
public class CamelMicroProfilePropertiesSource
implements LoadablePropertiesSource {
    public String getName() {
        return "CamelMicroProfilePropertiesSource";
    }

    public String getProperty(String name) {
        return ConfigProvider.getConfig().getOptionalValue(name, String.class).orElse(null);
    }

    public Properties loadProperties() {
        return this.loadProperties(s -> true);
    }

    public Properties loadProperties(Predicate<String> filter) {
        OrderedProperties answer = new OrderedProperties();
        for (String name : ConfigProvider.getConfig().getPropertyNames()) {
            String value;
            if (!filter.test(name) || (value = this.getProperty(name)) == null) continue;
            answer.put(name, this.getProperty(name));
        }
        return answer;
    }

    public void reloadProperties(String location) {
    }

    public String toString() {
        return "camel-microprofile-config";
    }
}

