/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.spi;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.component.micrometer.spi.TimedScheduledExecutorService;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.support.DefaultThreadPoolFactory;
import org.apache.camel.util.ObjectHelper;

public class InstrumentedThreadPoolFactory
implements ThreadPoolFactory {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final MeterRegistry meterRegistry;
    private final ThreadPoolFactory threadPoolFactory;
    private String prefix = "instrumented-delegate-";

    public InstrumentedThreadPoolFactory(MeterRegistry meterRegistry) {
        this(meterRegistry, (ThreadPoolFactory)new DefaultThreadPoolFactory());
    }

    public InstrumentedThreadPoolFactory(MeterRegistry metricRegistry, ThreadPoolFactory threadPoolFactory) {
        ObjectHelper.notNull((Object)metricRegistry, (String)"meterRegistry", (Object)this);
        ObjectHelper.notNull((Object)threadPoolFactory, (String)"threadPoolFactory", (Object)this);
        this.meterRegistry = metricRegistry;
        this.threadPoolFactory = threadPoolFactory;
    }

    public ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        ExecutorService executorService = this.threadPoolFactory.newCachedThreadPool(threadFactory);
        return ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ExecutorService)executorService, (String)this.name(this.prefix), (Tag[])new Tag[0]);
    }

    public ExecutorService newThreadPool(ThreadPoolProfile profile, ThreadFactory threadFactory) {
        ExecutorService executorService = this.threadPoolFactory.newThreadPool(profile, threadFactory);
        return ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ExecutorService)executorService, (String)this.name(profile.getId()), (Tag[])new Tag[0]);
    }

    public ScheduledExecutorService newScheduledThreadPool(ThreadPoolProfile profile, ThreadFactory threadFactory) {
        ScheduledExecutorService executorService = this.threadPoolFactory.newScheduledThreadPool(profile, threadFactory);
        String executorServiceName = this.name(profile.getId());
        return new TimedScheduledExecutorService(this.meterRegistry, executorService, executorServiceName, (Iterable<Tag>)Tags.empty());
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private String name(String prefix) {
        return prefix + COUNTER.incrementAndGet();
    }

    void reset() {
        COUNTER.set(0L);
    }
}

