/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.routepolicy;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.util.function.Predicate;
import org.apache.camel.Route;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyService;

public interface MicrometerRoutePolicyNamingStrategy {
    public static final Predicate<Meter.Id> ROUTE_POLICIES = id -> MicrometerRoutePolicyService.class.getSimpleName().equals(id.getTag("serviceName"));
    public static final MicrometerRoutePolicyNamingStrategy DEFAULT = route -> "camel.route.policy";
    public static final MicrometerRoutePolicyNamingStrategy LEGACY = new MicrometerRoutePolicyNamingStrategy(){

        @Override
        public String getName(Route route) {
            return this.formatName("camel.route.policy");
        }

        @Override
        public String formatName(String name) {
            return MicrometerUtils.legacyName(name);
        }
    };

    public String getName(Route var1);

    default public String formatName(String name) {
        return name;
    }

    default public String getExchangesSucceededName(Route route) {
        return this.formatName("camel.exchanges.succeeded");
    }

    default public String getExchangesFailedName(Route route) {
        return this.formatName("camel.exchanges.failed");
    }

    default public String getExchangesTotalName(Route route) {
        return this.formatName("camel.exchanges.total");
    }

    default public String getFailuresHandledName(Route route) {
        return this.formatName("camel.exchanges.failures.handled");
    }

    default public String getExternalRedeliveriesName(Route route) {
        return this.formatName("camel.exchanges.external.redeliveries");
    }

    default public String getLongTaskName(Route route) {
        return this.formatName("camel.route.policy.long.task");
    }

    default public Tags getTags(Route route) {
        return Tags.of((String[])new String[]{"camelContext", route.getCamelContext().getName(), "serviceName", MicrometerRoutePolicyService.class.getSimpleName(), "routeId", route.getId()});
    }

    default public Tags getExchangeStatusTags(Route route) {
        return Tags.of((String[])new String[]{"camelContext", route.getCamelContext().getName(), "serviceName", MicrometerRoutePolicyService.class.getSimpleName(), "routeId", route.getId()});
    }
}

