/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.routepolicy;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.component.micrometer.MicrometerUtils;

public interface MicrometerRoutePolicyNamingStrategy {
    public static final Predicate<Meter.Id> ROUTE_POLICIES = id -> "CamelRoute".equals(id.getTag("kind"));
    public static final MicrometerRoutePolicyNamingStrategy DEFAULT = route -> "camel.route.policy";
    public static final MicrometerRoutePolicyNamingStrategy LEGACY = new MicrometerRoutePolicyNamingStrategy(){

        @Override
        public String getName(Route route) {
            return this.formatName("camel.route.policy");
        }

        @Override
        public String formatName(String name) {
            return MicrometerUtils.legacyName(name);
        }
    };

    public String getName(Route var1);

    default public String formatName(String name) {
        return name;
    }

    default public String getExchangesSucceededName(Route route) {
        return this.formatName("camel.exchanges.succeeded");
    }

    default public String getExchangesFailedName(Route route) {
        return this.formatName("camel.exchanges.failed");
    }

    default public String getExchangesTotalName(Route route) {
        return this.formatName("camel.exchanges.total");
    }

    default public String getFailuresHandledName(Route route) {
        return this.formatName("camel.exchanges.failures.handled");
    }

    default public String getExternalRedeliveriesName(Route route) {
        return this.formatName("camel.exchanges.external.redeliveries");
    }

    default public String getLongTaskName(Route route) {
        return this.formatName("camel.route.policy.long.task");
    }

    default public Tags getTags(Route route) {
        return Tags.of((String[])new String[]{"camelContext", route.getCamelContext().getName(), "kind", "CamelRoute", "routeId", route.getId(), "eventType", "route"});
    }

    default public Tags getTags(CamelContext camelContext) {
        return Tags.of((String[])new String[]{"camelContext", camelContext.getName(), "kind", "CamelRoute", "routeId", "", "eventType", "context"});
    }

    default public Tags getExchangeStatusTags(Route route) {
        return Tags.of((String[])new String[]{"camelContext", route.getCamelContext().getName(), "kind", "CamelRoute", "routeId", route.getId(), "eventType", "route"});
    }

    default public Tags getExchangeStatusTags(CamelContext camelContext) {
        return Tags.of((String[])new String[]{"camelContext", camelContext.getName(), "kind", "CamelRoute", "routeId", "", "eventType", "context"});
    }
}

