/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.micrometer.observability;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.observation.DefaultMeterObservationHandler;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.DefaultTracingObservationHandler;
import io.micrometer.tracing.handler.PropagatingReceiverTracingObservationHandler;
import io.micrometer.tracing.handler.PropagatingSenderTracingObservationHandler;
import io.micrometer.tracing.propagation.Propagator;
import io.micrometer.tracing.test.simple.SimpleTracer;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.micrometer.observability.MicrometerObservabilitySpanAdapter;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.telemetry.SpanContextPropagationExtractor;
import org.apache.camel.telemetry.SpanContextPropagationInjector;
import org.apache.camel.telemetry.SpanLifecycleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="micrometer-observability-tracer")
@Configurer
@ManagedResource(description="MicrometerObservabilityTracer")
public class MicrometerObservabilityTracer
extends org.apache.camel.telemetry.Tracer {
    private static final Logger LOG = LoggerFactory.getLogger(MicrometerObservabilityTracer.class);
    private Tracer tracer;
    private ObservationRegistry observationRegistry;
    private Propagator propagator;

    public Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public ObservationRegistry getObservationRegistry() {
        return this.observationRegistry;
    }

    public void setObservationRegistry(ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
    }

    public Propagator getPropagator() {
        return this.propagator;
    }

    public void setPropagator(Propagator propagator) {
        this.propagator = propagator;
    }

    protected void initTracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)CamelContextHelper.findSingleByType((CamelContext)this.getCamelContext(), Tracer.class);
        }
        if (this.tracer == null) {
            this.tracer = new SimpleTracer();
            LOG.warn("No tracer was provided. A default inmemory tracer is used. This can be useful for development only, avoid this in a production environment.");
        }
        if (this.observationRegistry == null) {
            this.observationRegistry = (ObservationRegistry)CamelContextHelper.findSingleByType((CamelContext)this.getCamelContext(), ObservationRegistry.class);
        }
        if (this.observationRegistry == null) {
            SimpleMeterRegistry meterRegistry = new SimpleMeterRegistry();
            this.observationRegistry = ObservationRegistry.create();
            this.observationRegistry.observationConfig().observationHandler((ObservationHandler)new DefaultMeterObservationHandler((MeterRegistry)meterRegistry));
            LOG.warn("No observation registry was provided. A default inmemory observation registry is used. This can be useful for development only, avoid this in a production environment.");
        }
        if (this.propagator == null) {
            this.propagator = (Propagator)CamelContextHelper.findSingleByType((CamelContext)this.getCamelContext(), Propagator.class);
        }
        if (this.propagator == null) {
            this.propagator = Propagator.NOOP;
            LOG.warn("No propagator was provided. A NOOP implementation is used, you won't be able to trace upstream activity. This can be useful for development only, avoid this in a production environment.");
        }
        this.setSpanLifecycleManager(new MicrometerObservabilitySpanLifecycleManager());
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.info("Micrometer Observability enabled");
    }

    private class MicrometerObservabilitySpanLifecycleManager
    implements SpanLifecycleManager {
        private MicrometerObservabilitySpanLifecycleManager() {
            MicrometerObservabilityTracer.this.observationRegistry.observationConfig().observationHandler((ObservationHandler)new ObservationHandler.FirstMatchingCompositeObservationHandler(new ObservationHandler[]{new PropagatingSenderTracingObservationHandler(MicrometerObservabilityTracer.this.tracer, MicrometerObservabilityTracer.this.propagator), new PropagatingReceiverTracingObservationHandler(MicrometerObservabilityTracer.this.tracer, MicrometerObservabilityTracer.this.propagator), new DefaultTracingObservationHandler(MicrometerObservabilityTracer.this.tracer)}));
        }

        public org.apache.camel.telemetry.Span create(String spanName, org.apache.camel.telemetry.Span parent, SpanContextPropagationExtractor extractor) {
            Span span;
            if (parent != null) {
                MicrometerObservabilitySpanAdapter microObsParentSpan = (MicrometerObservabilitySpanAdapter)parent;
                span = MicrometerObservabilityTracer.this.tracer.nextSpan(microObsParentSpan.getSpan());
            } else if (extractor.get("traceparent") != null || extractor.get("X-B3-TraceId") != null) {
                Span.Builder builder = MicrometerObservabilityTracer.this.propagator.extract((Object)extractor, (carrier, key) -> extractor.get(key) == null ? null : (String)extractor.get(key));
                span = builder.start();
            } else {
                span = MicrometerObservabilityTracer.this.tracer.nextSpan();
            }
            span.name(spanName);
            return new MicrometerObservabilitySpanAdapter(span);
        }

        public void activate(org.apache.camel.telemetry.Span span) {
            MicrometerObservabilitySpanAdapter microObsSpan = (MicrometerObservabilitySpanAdapter)span;
            microObsSpan.activate();
        }

        public void close(org.apache.camel.telemetry.Span span) {
            MicrometerObservabilitySpanAdapter microObsSpan = (MicrometerObservabilitySpanAdapter)span;
            microObsSpan.close();
        }

        public void deactivate(org.apache.camel.telemetry.Span span) {
            MicrometerObservabilitySpanAdapter microObsSpan = (MicrometerObservabilitySpanAdapter)span;
            microObsSpan.deactivate();
        }

        public void inject(org.apache.camel.telemetry.Span span, SpanContextPropagationInjector injector) {
            MicrometerObservabilitySpanAdapter microObsSpan = (MicrometerObservabilitySpanAdapter)span;
            MicrometerObservabilityTracer.this.propagator.inject(microObsSpan.getSpan().context(), (Object)injector, (carrier, key, value) -> carrier.put(key, value));
        }
    }
}

