/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.micrometer.observability;

import io.micrometer.tracing.Span;
import java.util.Map;

public class MicrometerObservabilitySpanAdapter
implements org.apache.camel.telemetry.Span {
    private static final String DEFAULT_EVENT_NAME = "log";
    private final Span span;

    public MicrometerObservabilitySpanAdapter(Span span) {
        this.span = span;
    }

    public void log(Map<String, String> fields) {
        String event = fields.get("event");
        if ("error".equalsIgnoreCase(event)) {
            this.setError(true);
        } else if (fields.get("message") != null) {
            this.span.event("message=" + fields.get("message"));
        } else {
            this.span.event(DEFAULT_EVENT_NAME);
        }
    }

    public void setComponent(String component) {
        this.span.tag("component", component);
    }

    public void setError(boolean isError) {
        this.span.tag("error", isError);
    }

    public void setTag(String key, String value) {
        this.span.tag(key, value);
    }

    protected Span getSpan() {
        return this.span;
    }

    protected void activate() {
        this.span.start();
    }

    protected void close() {
        this.span.end();
    }

    protected void deactivate() {
    }

    public String toString() {
        return "MicrometerObservabilitySpanAdapter [traceId=" + this.span.context().traceId() + " spanId=" + this.span.context().spanId() + "]";
    }
}

