/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.metrics.AbstractMetricsProducer;
import org.apache.camel.component.metrics.MetricsEndpoint;
import org.apache.camel.component.metrics.MetricsTimerAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerProducer
extends AbstractMetricsProducer {
    private static final Logger LOG = LoggerFactory.getLogger(TimerProducer.class);

    public TimerProducer(MetricsEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected void doProcess(Exchange exchange, MetricsEndpoint endpoint, MetricRegistry registry, String metricsName) throws Exception {
        MetricsTimerAction action;
        Message in = exchange.getIn();
        MetricsTimerAction finalAction = (MetricsTimerAction)((Object)in.getHeader("CamelMetricsTimerAction", (Object)(action = endpoint.getAction()), MetricsTimerAction.class));
        if (finalAction == MetricsTimerAction.start) {
            this.handleStart(exchange, registry, metricsName);
        } else if (finalAction == MetricsTimerAction.stop) {
            this.handleStop(exchange, metricsName);
        } else {
            LOG.warn("No action provided for timer \"{}\"", (Object)metricsName);
        }
    }

    void handleStart(Exchange exchange, MetricRegistry registry, String metricsName) {
        String propertyName = this.getPropertyName(metricsName);
        Timer.Context context = this.getTimerContextFromExchange(exchange, propertyName);
        if (context == null) {
            Timer timer = registry.timer(metricsName);
            context = timer.time();
            exchange.setProperty(propertyName, (Object)context);
        } else {
            LOG.warn("Timer \"{}\" already running", (Object)metricsName);
        }
    }

    void handleStop(Exchange exchange, String metricsName) {
        String propertyName = this.getPropertyName(metricsName);
        Timer.Context context = this.getTimerContextFromExchange(exchange, propertyName);
        if (context != null) {
            context.stop();
            exchange.removeProperty(propertyName);
        } else {
            LOG.warn("Timer \"{}\" not found", (Object)metricsName);
        }
    }

    String getPropertyName(String metricsName) {
        return "timer" + ":" + metricsName;
    }

    Timer.Context getTimerContextFromExchange(Exchange exchange, String propertyName) {
        return (Timer.Context)exchange.getProperty(propertyName, Timer.Context.class);
    }
}

