/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.camel.maven.DevMojo;
import org.apache.camel.util.CastUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectBuilder;

@Mojo(name="debug", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DebugMojo
extends DevMojo {
    @Parameter(property="camel.suspend", defaultValue="true")
    private boolean suspend;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojo;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;

    @Inject
    public DebugMojo(ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, ArtifactMetadataSource metadataSource, MavenProjectBuilder projectBuilder) {
        super(artifactResolver, artifactFactory, metadataSource, projectBuilder);
    }

    @Override
    protected void beforeBootstrapCamel() throws Exception {
        super.beforeBootstrapCamel();
        System.setProperty("org.apache.camel.jmx.disabled", "false");
        System.setProperty("org.apache.camel.debugger.suspend", Boolean.toString(this.suspend));
        String suspendMode = System.getenv("CAMEL_DEBUGGER_SUSPEND");
        if (suspendMode != null && Boolean.parseBoolean(suspendMode) != this.suspend) {
            throw new MojoExecutionException(String.format("The environment variable %s has been set and prevents to configure the suspend mode. Please remove it first.", "CAMEL_DEBUGGER_SUSPEND"));
        }
    }

    @Override
    protected String goal() {
        return "camel:debug";
    }

    @Override
    protected List<Artifact> getClasspath() throws MojoExecutionException, MojoFailureException {
        List<Artifact> classpath = super.getClasspath();
        if (classpath.stream().anyMatch(artifact -> "org.apache.camel".equals(artifact.getGroupId()) && "camel-debug".equals(artifact.getArtifactId()))) {
            this.getLog().debug((CharSequence)"The component camel-debug has been detected in the classpath so no need to add it");
            return classpath;
        }
        this.getLog().info((CharSequence)"The component camel-debug is not available in the classpath, it will be added automatically");
        Optional<String> camelCoreVersion = classpath.stream().filter(artifact -> "org.apache.camel".equals(artifact.getGroupId()) && Objects.nonNull(artifact.getArtifactId()) && artifact.getArtifactId().startsWith("camel-core")).map(Artifact::getBaseVersion).filter(Objects::nonNull).findAny();
        if (camelCoreVersion.isEmpty()) {
            this.getLog().info((CharSequence)"The version of Camel could not be detected, the version of the plugin will be used instead");
            this.addCamelDebug(classpath, this.mojo.getVersion());
            return classpath;
        }
        this.addCamelDebug(classpath, camelCoreVersion.get());
        return classpath;
    }

    private void addCamelDebug(List<Artifact> classpath, String version) {
        this.getLog().debug((CharSequence)String.format("Trying to retrieve the version %s of camel-debug", version));
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setResolveRoot(true);
        request.setResolveTransitively(true);
        request.setLocalRepository(this.session.getLocalRepository());
        request.setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories());
        request.setOffline(this.session.isOffline());
        request.setForceUpdate(this.session.getRequest().isUpdateSnapshots());
        request.setServers(this.session.getRequest().getServers());
        request.setMirrors(this.session.getRequest().getMirrors());
        request.setProxies(this.session.getRequest().getProxies());
        request.setManagedVersionMap(Collections.emptyMap());
        request.setArtifact((Artifact)new DefaultArtifact("org.apache.camel", "camel-debug", version, "runtime", "jar", null, (ArtifactHandler)new DefaultArtifactHandler("jar")));
        request.setResolutionFilter((ArtifactFilter)new ScopeArtifactFilter("runtime"));
        ArtifactResolutionResult result = this.artifactResolver.resolve(request);
        if (result.isSuccess()) {
            this.getLog().info((CharSequence)String.format("Adding the version %s of camel-debug", version));
            classpath.addAll(CastUtils.cast((Set)result.getArtifacts()));
            return;
        }
        if (result.hasMissingArtifacts()) {
            this.getLog().warn((CharSequence)String.format("Could not find the artifacts: %s", result.getMissingArtifacts().stream().map(Objects::toString).collect(Collectors.joining(", "))));
        }
        if (result.hasExceptions()) {
            result.getExceptions().forEach(ex -> this.getLog().warn((CharSequence)String.format("An error occurred while retrieving camel-debug: %s", ex.getMessage())));
        }
    }
}

