/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.master;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.master.MasterEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.cluster.ClusterServiceHelper;
import org.apache.camel.support.cluster.ClusterServiceSelectors;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

@Component(value="master")
public class MasterComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private CamelClusterService service;
    @Metadata(label="advanced")
    private CamelClusterService.Selector serviceSelector = ClusterServiceSelectors.DEFAULT_SELECTOR;
    @Metadata(label="advanced")
    private long backOffDelay = 5000L;
    @Metadata(label="advanced")
    private int backOffMaxAttempts = 10;

    public MasterComponent() {
        this(null);
    }

    public MasterComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> params) throws Exception {
        String namespace = StringHelper.before((String)remaining, (String)":");
        Object delegateUri = StringHelper.after((String)remaining, (String)":");
        if (ObjectHelper.isEmpty((String)namespace) || ObjectHelper.isEmpty((String)delegateUri)) {
            throw new IllegalArgumentException("Wrong uri syntax : master:namespace:uri, got " + remaining);
        }
        if (params != null && params.size() > 0) {
            delegateUri = (String)delegateUri + "?" + uri.substring(uri.indexOf(63) + 1);
        }
        return new MasterEndpoint(uri, this, this.service, namespace, (String)delegateUri);
    }

    public boolean useRawUri() {
        return true;
    }

    public CamelClusterService getService() {
        return this.service;
    }

    public void setService(CamelClusterService service) {
        this.service = service;
    }

    public CamelClusterService.Selector getServiceSelector() {
        return this.serviceSelector;
    }

    public void setServiceSelector(CamelClusterService.Selector serviceSelector) {
        this.serviceSelector = serviceSelector;
    }

    public long getBackOffDelay() {
        return this.backOffDelay;
    }

    public void setBackOffDelay(long backOffDelay) {
        this.backOffDelay = backOffDelay;
    }

    public int getBackOffMaxAttempts() {
        return this.backOffMaxAttempts;
    }

    public void setBackOffMaxAttempts(int backOffMaxAttempts) {
        this.backOffMaxAttempts = backOffMaxAttempts;
    }

    protected void doInit() throws Exception {
        CamelContext context = this.getCamelContext();
        ObjectHelper.notNull((Object)context, (String)"Camel Context");
        if (this.service == null) {
            this.service = (CamelClusterService)ClusterServiceHelper.lookupService((CamelContext)context, (CamelClusterService.Selector)this.serviceSelector).orElseThrow(() -> new IllegalStateException("No cluster service found"));
        }
    }
}

