/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.mbean.ManagedClusterServiceMBean;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.cluster.ClusterServiceHelper;

public class ManagedClusterService
implements ManagedClusterServiceMBean {
    private final CamelContext context;
    private final CamelClusterService service;

    public ManagedClusterService(CamelContext context, CamelClusterService service) {
        this.context = context;
        this.service = service;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.context;
    }

    public CamelClusterService getService() {
        return this.service;
    }

    public void start() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.service.start();
    }

    public void stop() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.service.stop();
    }

    public String getState() {
        CamelClusterService camelClusterService = this.service;
        if (camelClusterService instanceof StatefulService) {
            StatefulService statefulService = (StatefulService)camelClusterService;
            ServiceStatus status = statefulService.getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    public String getCamelId() {
        return this.context.getName();
    }

    public Collection<String> getNamespaces() {
        return ClusterServiceHelper.lookupService((CamelContext)this.context).map(CamelClusterService::getNamespaces).orElseGet(Collections::emptyList);
    }

    public void startView(String namespace) throws Exception {
        Optional service = ClusterServiceHelper.lookupService((CamelContext)this.context);
        if (service.isPresent()) {
            ((CamelClusterService)service.get()).startView(namespace);
        }
    }

    public void stopView(String namespace) throws Exception {
        Optional service = ClusterServiceHelper.lookupService((CamelContext)this.context);
        if (service.isPresent()) {
            ((CamelClusterService)service.get()).stopView(namespace);
        }
    }

    public boolean isLeader(String namespace) {
        return ClusterServiceHelper.lookupService((CamelContext)this.context).map(s -> s.isLeader(namespace)).orElse(false);
    }
}

