/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.net.UnknownHostException;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.StaticService;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.management.JmxNotificationEventNotifier;
import org.apache.camel.management.mbean.ManagedBacklogDebugger;
import org.apache.camel.management.mbean.ManagedBacklogTracer;
import org.apache.camel.management.mbean.ManagedCamelContext;
import org.apache.camel.management.mbean.ManagedCamelHealth;
import org.apache.camel.management.mbean.ManagedClusterService;
import org.apache.camel.management.mbean.ManagedComponent;
import org.apache.camel.management.mbean.ManagedConsumer;
import org.apache.camel.management.mbean.ManagedDataFormat;
import org.apache.camel.management.mbean.ManagedDumpRouteStrategy;
import org.apache.camel.management.mbean.ManagedEndpoint;
import org.apache.camel.management.mbean.ManagedEventNotifier;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.management.mbean.ManagedProducer;
import org.apache.camel.management.mbean.ManagedRoute;
import org.apache.camel.management.mbean.ManagedRouteController;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.management.mbean.ManagedStep;
import org.apache.camel.management.mbean.ManagedSupervisingRouteController;
import org.apache.camel.management.mbean.ManagedThreadPool;
import org.apache.camel.management.mbean.ManagedTracer;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementObjectNameStrategy;
import org.apache.camel.spi.RouteController;
import org.apache.camel.util.InetAddressUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public class DefaultManagementObjectNameStrategy
implements ManagementObjectNameStrategy,
CamelContextAware {
    public static final String VALUE_UNKNOWN = "unknown";
    public static final String KEY_NAME = "name";
    public static final String KEY_TYPE = "type";
    public static final String KEY_CONTEXT = "context";
    public static final String TYPE_CONTEXT = "context";
    public static final String TYPE_HEALTH = "health";
    public static final String TYPE_ENDPOINT = "endpoints";
    public static final String TYPE_DATAFORMAT = "dataformats";
    public static final String TYPE_PROCESSOR = "processors";
    public static final String TYPE_CONSUMER = "consumers";
    public static final String TYPE_PRODUCER = "producers";
    public static final String TYPE_ROUTE = "routes";
    public static final String TYPE_COMPONENT = "components";
    public static final String TYPE_STEP = "steps";
    public static final String TYPE_TRACER = "tracer";
    public static final String TYPE_EVENT_NOTIFIER = "eventnotifiers";
    public static final String TYPE_THREAD_POOL = "threadpools";
    public static final String TYPE_SERVICE = "services";
    public static final String TYPE_HA = "clusterservices";
    protected String domainName;
    protected String hostName = "localhost";
    protected CamelContext camelContext;

    public DefaultManagementObjectNameStrategy() {
        this(null);
    }

    public DefaultManagementObjectNameStrategy(String domainName) {
        this.domainName = domainName != null ? domainName : "org.apache.camel";
        try {
            this.hostName = InetAddressUtil.getLocalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public ObjectName getObjectName(Object managedObject) throws MalformedObjectNameException {
        if (managedObject == null) {
            return null;
        }
        ObjectName objectName = null;
        if (managedObject instanceof ManagedCamelContext) {
            ManagedCamelContext mcc = (ManagedCamelContext)managedObject;
            objectName = this.getObjectNameForCamelContext(mcc.getContext());
        } else if (managedObject instanceof ManagedCamelHealth) {
            ManagedCamelHealth mch = (ManagedCamelHealth)managedObject;
            objectName = this.getObjectNameForCamelHealth(mch.getContext());
        } else if (managedObject instanceof ManagedRouteController) {
            ManagedRouteController mrc = (ManagedRouteController)managedObject;
            objectName = this.getObjectNameForRouteController(mrc.getContext(), mrc.getRouteController());
        } else if (managedObject instanceof ManagedSupervisingRouteController) {
            ManagedSupervisingRouteController mrc = (ManagedSupervisingRouteController)managedObject;
            objectName = this.getObjectNameForRouteController(mrc.getContext(), (RouteController)mrc.getRouteController());
        } else if (managedObject instanceof ManagedComponent) {
            ManagedComponent mc = (ManagedComponent)managedObject;
            objectName = this.getObjectNameForComponent(mc.getComponent(), mc.getComponentName());
        } else if (managedObject instanceof ManagedDataFormat) {
            ManagedDataFormat md = (ManagedDataFormat)managedObject;
            objectName = this.getObjectNameForDataFormat(md.getContext(), md.getDataFormat());
        } else if (managedObject instanceof ManagedEndpoint) {
            ManagedEndpoint me = (ManagedEndpoint)managedObject;
            objectName = this.getObjectNameForEndpoint(me.getEndpoint());
        } else if (managedObject instanceof Endpoint) {
            objectName = this.getObjectNameForEndpoint((Endpoint)managedObject);
        } else if (managedObject instanceof ManagedRoute) {
            ManagedRoute mr = (ManagedRoute)managedObject;
            objectName = this.getObjectNameForRoute(mr.getRoute());
        } else if (managedObject instanceof ManagedStep) {
            ManagedStep mp = (ManagedStep)managedObject;
            objectName = this.getObjectNameForStep(mp.getContext(), mp.getProcessor(), (NamedNode)mp.getDefinition());
        } else if (managedObject instanceof ManagedProcessor) {
            ManagedProcessor mp = (ManagedProcessor)managedObject;
            objectName = this.getObjectNameForProcessor(mp.getContext(), mp.getProcessor(), (NamedNode)mp.getDefinition());
        } else if (managedObject instanceof ManagedConsumer) {
            ManagedConsumer ms = (ManagedConsumer)managedObject;
            objectName = this.getObjectNameForConsumer(ms.getContext(), ms.getConsumer());
        } else if (managedObject instanceof ManagedProducer) {
            ManagedProducer ms = (ManagedProducer)managedObject;
            objectName = this.getObjectNameForProducer(ms.getContext(), ms.getProducer());
        } else if (managedObject instanceof ManagedBacklogTracer) {
            ManagedBacklogTracer mt = (ManagedBacklogTracer)managedObject;
            objectName = this.getObjectNameForTracer(mt.getContext(), (Service)mt.getBacklogTracer());
        } else if (managedObject instanceof ManagedBacklogDebugger) {
            ManagedBacklogDebugger md = (ManagedBacklogDebugger)managedObject;
            objectName = this.getObjectNameForTracer(md.getContext(), (Service)md.getBacklogDebugger());
        } else if (managedObject instanceof ManagedDumpRouteStrategy) {
            ManagedDumpRouteStrategy md = (ManagedDumpRouteStrategy)managedObject;
            objectName = this.getObjectNameForService(md.getContext(), (Service)md.getDumpRoutesStrategy());
        } else if (managedObject instanceof ManagedEventNotifier) {
            ManagedEventNotifier men = (ManagedEventNotifier)managedObject;
            objectName = this.getObjectNameForEventNotifier(men.getContext(), men.getEventNotifier());
        } else if (managedObject instanceof ManagedTracer) {
            ManagedTracer mt = (ManagedTracer)managedObject;
            objectName = this.getObjectNameForTracer(mt.getContext(), (Service)mt.getTracer());
        } else if (managedObject instanceof ManagedThreadPool) {
            ManagedThreadPool mes = (ManagedThreadPool)managedObject;
            objectName = this.getObjectNameForThreadPool(mes.getContext(), mes.getThreadPool(), mes.getId(), mes.getSourceId());
        } else if (managedObject instanceof ManagedClusterService) {
            ManagedClusterService mcs = (ManagedClusterService)managedObject;
            objectName = this.getObjectNameForClusterService(mcs.getContext(), mcs.getService());
        } else if (managedObject instanceof ManagedService) {
            ManagedService ms = (ManagedService)managedObject;
            if (ms.getService() instanceof Endpoint) {
                return null;
            }
            objectName = this.getObjectNameForService(ms.getContext(), ms.getService());
        }
        return objectName;
    }

    public ObjectName getObjectNameForCamelContext(String managementName, String name) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(managementName)).append(",");
        buffer.append("type=context,");
        buffer.append("name=").append(ObjectName.quote(name));
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectNameForCamelContext(CamelContext context) throws MalformedObjectNameException {
        String managementName = context.getManagementName();
        if (managementName == null) {
            managementName = context.getManagementNameStrategy().getName();
        }
        String name = context.getName();
        return this.getObjectNameForCamelContext(managementName, name);
    }

    public ObjectName getObjectNameForCamelHealth(CamelContext context) throws MalformedObjectNameException {
        String managementName = context.getManagementName();
        if (managementName == null) {
            managementName = context.getManagementNameStrategy().getName();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(managementName)).append(",");
        buffer.append("type=health,");
        buffer.append("name=").append("DefaultHealthCheck");
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectNameForRouteController(CamelContext context, RouteController routeController) throws MalformedObjectNameException {
        String managementName = context.getManagementName();
        if (managementName == null) {
            managementName = context.getManagementNameStrategy().getName();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(managementName)).append(",");
        buffer.append("type=services,");
        buffer.append("name=").append(routeController.getClass().getSimpleName());
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectNameForEndpoint(Endpoint endpoint) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(endpoint.getCamelContext())).append(",");
        buffer.append("type=endpoints,");
        buffer.append("name=").append(ObjectName.quote(this.getEndpointId(endpoint)));
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectNameForDataFormat(CamelContext context, DataFormat dataFormat) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=dataformats,");
        buffer.append("name=").append(dataFormat.getClass().getSimpleName());
        if (!(dataFormat instanceof StaticService)) {
            buffer.append("(").append(ObjectHelper.getIdentityHashCode((Object)dataFormat)).append(")");
        }
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectNameForComponent(Component component, String name) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(component.getCamelContext())).append(",");
        buffer.append("type=components,");
        buffer.append("name=").append(ObjectName.quote(name));
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectNameForProcessor(CamelContext context, Processor processor, NamedNode definition) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=").append(TYPE_PROCESSOR).append(",");
        buffer.append("name=").append(ObjectName.quote(definition.getId()));
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectNameForStep(CamelContext context, Processor processor, NamedNode definition) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=").append(TYPE_STEP).append(",");
        buffer.append("name=").append(ObjectName.quote(definition.getId()));
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectNameForConsumer(CamelContext context, Consumer consumer) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=").append(TYPE_CONSUMER).append(",");
        String name = consumer.getClass().getSimpleName();
        if (ObjectHelper.isEmpty((String)name)) {
            name = "Consumer";
        }
        buffer.append("name=").append(name).append("(").append(ObjectHelper.getIdentityHashCode((Object)consumer)).append(")");
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectNameForProducer(CamelContext context, Producer producer) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=").append(TYPE_PRODUCER).append(",");
        String name = producer.getClass().getSimpleName();
        if (ObjectHelper.isEmpty((String)name)) {
            name = "Producer";
        }
        buffer.append("name=").append(name).append("(").append(ObjectHelper.getIdentityHashCode((Object)producer)).append(")");
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectNameForTracer(CamelContext context, Service tracer) throws MalformedObjectNameException {
        String name = tracer.getClass().getSimpleName();
        if ("DefaultBacklogDebugger".equals(name)) {
            name = "BacklogDebugger";
        } else if ("DefaultBacklogTracer".equals(name)) {
            name = "BacklogTracer";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=tracer,");
        buffer.append("name=").append(name);
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectNameForEventNotifier(CamelContext context, EventNotifier eventNotifier) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=eventnotifiers,");
        if (eventNotifier instanceof JmxNotificationEventNotifier) {
            buffer.append("name=").append("JmxEventNotifier");
        } else {
            buffer.append("name=").append("EventNotifier").append("(").append(ObjectHelper.getIdentityHashCode((Object)eventNotifier)).append(")");
        }
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectNameForRoute(Route route) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(route.getCamelContext())).append(",");
        buffer.append("type=routes,");
        buffer.append("name=").append(ObjectName.quote(route.getId()));
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectNameForService(CamelContext context, Service service) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=services,");
        buffer.append("name=").append(service.getClass().getSimpleName());
        if (!(service instanceof StaticService)) {
            buffer.append("(").append(ObjectHelper.getIdentityHashCode((Object)service)).append(")");
        }
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectNameForClusterService(CamelContext context, CamelClusterService service) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=clusterservices,");
        buffer.append("name=").append(service.getClass().getSimpleName());
        if (!(service instanceof StaticService)) {
            buffer.append("(").append(ObjectHelper.getIdentityHashCode((Object)service)).append(")");
        }
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectNameForThreadPool(CamelContext context, ThreadPoolExecutor threadPool, String id, String sourceId) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=threadpools,");
        Object name = id;
        if (sourceId != null) {
            name = (String)name + "(" + sourceId + ")";
        }
        buffer.append("name=").append(ObjectName.quote((String)name));
        return this.createObjectName(buffer);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    protected String getContextId(CamelContext context) {
        if (context == null) {
            return this.getContextId(VALUE_UNKNOWN);
        }
        String name = context.getManagementName() != null ? context.getManagementName() : context.getName();
        return this.getContextId(name);
    }

    protected String getContextId(String name) {
        boolean includeHostName;
        boolean bl = includeHostName = this.camelContext != null && this.camelContext.getManagementStrategy().getManagementAgent().getIncludeHostName() != false;
        if (includeHostName) {
            return this.hostName + "/" + (name != null ? name : VALUE_UNKNOWN);
        }
        return name != null ? name : VALUE_UNKNOWN;
    }

    protected String getEndpointId(Endpoint ep) {
        boolean sanitize;
        String answer = this.doGetEndpointId(ep);
        boolean bl = sanitize = this.camelContext != null && this.camelContext.getManagementStrategy().getManagementAgent().getMask() != false;
        if (sanitize) {
            answer = URISupport.sanitizeUri((String)answer);
        }
        return answer;
    }

    private String doGetEndpointId(Endpoint ep) {
        if (ep.isSingleton()) {
            return ep.getEndpointKey();
        }
        String uri = ep.getEndpointKey();
        Object id = StringHelper.before((String)uri, (String)"?", (String)uri);
        id = (String)id + "?id=" + ObjectHelper.getIdentityHashCode((Object)ep);
        return id;
    }

    protected ObjectName createObjectName(StringBuilder buffer) throws MalformedObjectNameException {
        String text = buffer.toString();
        try {
            return new ObjectName(text);
        }
        catch (MalformedObjectNameException e) {
            throw new MalformedObjectNameException("Could not create ObjectName from: " + text + ". Reason: " + e);
        }
    }
}

