/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.TimerListener;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedRouteGroupMBean;
import org.apache.camel.management.mbean.LoadThroughput;
import org.apache.camel.management.mbean.LoadTriplet;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.TimeUtils;

@ManagedResource(description="Managed Route Group")
public class ManagedRouteGroup
extends ManagedPerformanceCounter
implements TimerListener,
ManagedRouteGroupMBean {
    public static final String VALUE_UNKNOWN = "Unknown";
    protected final String group;
    protected final CamelContext context;
    private final LoadTriplet load = new LoadTriplet();
    private final LoadThroughput thp = new LoadThroughput();
    private final String jmxDomain;

    public ManagedRouteGroup(CamelContext context, String group) {
        this.context = context;
        this.group = group;
        this.jmxDomain = context.getManagementStrategy().getManagementAgent().getMBeanObjectDomainName();
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        boolean enabled = this.context.getManagementStrategy().getManagementAgent().getStatisticsLevel() != ManagementStatisticsLevel.Off;
        this.setStatisticsEnabled(enabled);
    }

    public CamelContext getContext() {
        return this.context;
    }

    public String getRouteGroup() {
        return this.group;
    }

    public int getGroupSize() {
        return this.context.getRoutesByGroup(this.group).size();
    }

    public String[] getGroupIds() {
        List<String> list = this.context.getRoutesByGroup(this.group).stream().map(Route::getRouteId).toList();
        return list.toArray(new String[0]);
    }

    public String getState() {
        String answer = null;
        for (Route route : this.context.getRoutesByGroup(this.group)) {
            ServiceStatus status = this.context.getRouteController().getRouteStatus(route.getId());
            if (status == null) continue;
            if (answer == null) {
                answer = status.name();
                continue;
            }
            if (status.name().equals(answer)) continue;
            answer = VALUE_UNKNOWN;
        }
        return answer;
    }

    public String getUptime() {
        long delta = this.getUptimeMillis();
        if (delta == 0L) {
            return "";
        }
        return TimeUtils.printDuration((long)delta);
    }

    public long getUptimeMillis() {
        long answer = -1L;
        for (Route route : this.context.getRoutesByGroup(this.group)) {
            answer = Math.max(answer, route.getUptimeMillis());
        }
        return answer;
    }

    public String getCamelId() {
        return this.context.getName();
    }

    public String getCamelManagementName() {
        return this.context.getManagementName();
    }

    public String getLoad01() {
        double load1 = this.load.getLoad1();
        if (Double.isNaN(load1)) {
            return "";
        }
        return String.format("%.2f", load1);
    }

    public String getLoad05() {
        double load5 = this.load.getLoad5();
        if (Double.isNaN(load5)) {
            return "";
        }
        return String.format("%.2f", load5);
    }

    public String getLoad15() {
        double load15 = this.load.getLoad15();
        if (Double.isNaN(load15)) {
            return "";
        }
        return String.format("%.2f", load15);
    }

    public String getThroughput() {
        double d = this.thp.getThroughput();
        if (Double.isNaN(d)) {
            return "";
        }
        return String.format("%.2f", d);
    }

    public void onTimer() {
        this.load.update(this.getInflightExchanges());
        this.thp.update(this.getExchangesTotal());
    }

    private Integer getInflightExchanges() {
        return (int)super.getExchangesInflight();
    }

    public void start() throws Exception {
        this.context.getRouteController().startRouteGroup(this.group);
    }

    public void stop() throws Exception {
        this.context.getRouteController().stopRouteGroup(this.group);
    }
}

