/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedResequencerMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Resequencer;
import org.apache.camel.processor.StreamResequencer;

@ManagedResource(description="Managed Resequencer")
public class ManagedResequencer
extends ManagedProcessor
implements ManagedResequencerMBean {
    private final String expression;

    public ManagedResequencer(CamelContext context, Resequencer processor, ProcessorDefinition<?> definition) {
        super(context, (Processor)processor, definition);
        this.expression = processor.getExpression().toString();
    }

    public ManagedResequencer(CamelContext context, StreamResequencer processor, ProcessorDefinition<?> definition) {
        super(context, (Processor)processor, definition);
        this.expression = processor.getExpression().toString();
    }

    public String getExpression() {
        return this.expression;
    }

    private Resequencer getResequencer() {
        Processor processor = this.getProcessor();
        if (processor instanceof Resequencer) {
            Resequencer r = (Resequencer)processor;
            return r;
        }
        return null;
    }

    private StreamResequencer getStreamResequencer() {
        Processor processor = this.getProcessor();
        if (processor instanceof StreamResequencer) {
            StreamResequencer r = (StreamResequencer)processor;
            return r;
        }
        return null;
    }

    public Integer getBatchSize() {
        if (this.getResequencer() != null) {
            return this.getResequencer().getBatchSize();
        }
        return null;
    }

    public Long getTimeout() {
        if (this.getResequencer() != null) {
            return this.getResequencer().getBatchTimeout();
        }
        return this.getStreamResequencer().getTimeout();
    }

    public Boolean isAllowDuplicates() {
        if (this.getResequencer() != null) {
            return this.getResequencer().isAllowDuplicates();
        }
        return null;
    }

    public Boolean isReverse() {
        if (this.getResequencer() != null) {
            return this.getResequencer().isReverse();
        }
        return null;
    }

    public Boolean isIgnoreInvalidExchanges() {
        if (this.getResequencer() != null) {
            return this.getResequencer().isIgnoreInvalidExchanges();
        }
        return this.getStreamResequencer().isIgnoreInvalidExchanges();
    }

    public Integer getCapacity() {
        if (this.getResequencer() != null) {
            return null;
        }
        return this.getStreamResequencer().getCapacity();
    }

    public Boolean isRejectOld() {
        if (this.getResequencer() != null) {
            return null;
        }
        return this.getStreamResequencer().isRejectOld();
    }
}

