/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedFailoverLoadBalancerMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.loadbalancer.ExceptionFailureStatistics;
import org.apache.camel.processor.loadbalancer.FailOverLoadBalancer;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed Failover LoadBalancer")
public class ManagedFailoverLoadBalancer
extends ManagedProcessor
implements ManagedFailoverLoadBalancerMBean {
    private String exceptions;

    public ManagedFailoverLoadBalancer(CamelContext context, FailOverLoadBalancer processor, LoadBalanceDefinition definition) {
        super(context, (Processor)processor, (ProcessorDefinition<?>)definition);
    }

    public FailOverLoadBalancer getProcessor() {
        return (FailOverLoadBalancer)super.getProcessor();
    }

    public LoadBalanceDefinition getDefinition() {
        return (LoadBalanceDefinition)super.getDefinition();
    }

    @Override
    public void reset() {
        super.reset();
        this.getProcessor().reset();
    }

    @Override
    public Boolean getSupportExtendedInformation() {
        return true;
    }

    public Integer getSize() {
        return this.getProcessor().getProcessors().size();
    }

    public Boolean isRoundRobin() {
        return this.getProcessor().isRoundRobin();
    }

    public Boolean isSticky() {
        return this.getProcessor().isSticky();
    }

    public Integer getMaximumFailoverAttempts() {
        return this.getProcessor().getMaximumFailoverAttempts();
    }

    public String getExceptions() {
        if (this.exceptions != null) {
            return this.exceptions;
        }
        List classes = this.getProcessor().getExceptions();
        if (classes == null || classes.isEmpty()) {
            this.exceptions = "";
        } else {
            StringJoiner exceptionsBuilder = new StringJoiner(",");
            for (Class clazz : classes) {
                exceptionsBuilder.add(clazz.getCanonicalName());
            }
            this.exceptions = exceptionsBuilder.toString();
        }
        return this.exceptions;
    }

    public String getLastGoodProcessorId() {
        LoadBalanceDefinition def;
        ProcessorDefinition output;
        int idx = this.getProcessor().getLastGoodIndex();
        if (idx != -1 && (output = (ProcessorDefinition)(def = this.getDefinition()).getOutputs().get(idx)) != null) {
            return output.getId();
        }
        return null;
    }

    public TabularData extendedInformation() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.loadbalancerExceptionsTabularType());
            ExceptionFailureStatistics statistics = this.getProcessor().getExceptionFailureStatistics();
            Iterator it = statistics.getExceptions();
            boolean empty = true;
            while (it.hasNext()) {
                empty = false;
                Class exception = (Class)it.next();
                String name = ObjectHelper.name((Class)exception);
                long counter = statistics.getFailureCounter(exception);
                CompositeType ct = CamelOpenMBeanTypes.loadbalancerExceptionsCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"exception", "failures"}, new Object[]{name, counter});
                answer.put(data);
            }
            if (empty) {
                String name = ObjectHelper.name(Exception.class);
                long counter = statistics.getFailureCounter(Exception.class);
                CompositeType ct = CamelOpenMBeanTypes.loadbalancerExceptionsCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"exception", "failures"}, new Object[]{name, counter});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

