/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Iterator;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.log.LogEndpoint;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.management.mbean.ManagedAggregateProcessor;
import org.apache.camel.management.mbean.ManagedBeanProcessor;
import org.apache.camel.management.mbean.ManagedBrowsableEndpoint;
import org.apache.camel.management.mbean.ManagedCamelContext;
import org.apache.camel.management.mbean.ManagedCamelHealth;
import org.apache.camel.management.mbean.ManagedChoice;
import org.apache.camel.management.mbean.ManagedClaimCheck;
import org.apache.camel.management.mbean.ManagedClusterService;
import org.apache.camel.management.mbean.ManagedComponent;
import org.apache.camel.management.mbean.ManagedConsumer;
import org.apache.camel.management.mbean.ManagedConvertBody;
import org.apache.camel.management.mbean.ManagedConvertHeader;
import org.apache.camel.management.mbean.ManagedConvertVariable;
import org.apache.camel.management.mbean.ManagedCustomLoadBalancer;
import org.apache.camel.management.mbean.ManagedDataFormat;
import org.apache.camel.management.mbean.ManagedDelayer;
import org.apache.camel.management.mbean.ManagedDisabled;
import org.apache.camel.management.mbean.ManagedDoCatch;
import org.apache.camel.management.mbean.ManagedDoFinally;
import org.apache.camel.management.mbean.ManagedDoTry;
import org.apache.camel.management.mbean.ManagedDynamicRouter;
import org.apache.camel.management.mbean.ManagedEndpoint;
import org.apache.camel.management.mbean.ManagedEnricher;
import org.apache.camel.management.mbean.ManagedEventNotifier;
import org.apache.camel.management.mbean.ManagedFailoverLoadBalancer;
import org.apache.camel.management.mbean.ManagedFilter;
import org.apache.camel.management.mbean.ManagedIdempotentConsumer;
import org.apache.camel.management.mbean.ManagedLog;
import org.apache.camel.management.mbean.ManagedLoop;
import org.apache.camel.management.mbean.ManagedMarshal;
import org.apache.camel.management.mbean.ManagedMulticast;
import org.apache.camel.management.mbean.ManagedPoll;
import org.apache.camel.management.mbean.ManagedPollEnricher;
import org.apache.camel.management.mbean.ManagedProcess;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.management.mbean.ManagedProducer;
import org.apache.camel.management.mbean.ManagedRandomLoadBalancer;
import org.apache.camel.management.mbean.ManagedRecipientList;
import org.apache.camel.management.mbean.ManagedRemoveHeader;
import org.apache.camel.management.mbean.ManagedRemoveHeaders;
import org.apache.camel.management.mbean.ManagedRemoveProperties;
import org.apache.camel.management.mbean.ManagedRemoveProperty;
import org.apache.camel.management.mbean.ManagedRemoveVariable;
import org.apache.camel.management.mbean.ManagedResequencer;
import org.apache.camel.management.mbean.ManagedRollback;
import org.apache.camel.management.mbean.ManagedRoundRobinLoadBalancer;
import org.apache.camel.management.mbean.ManagedRoute;
import org.apache.camel.management.mbean.ManagedRouteController;
import org.apache.camel.management.mbean.ManagedRouteGroup;
import org.apache.camel.management.mbean.ManagedRoutingSlip;
import org.apache.camel.management.mbean.ManagedSamplingThrottler;
import org.apache.camel.management.mbean.ManagedScheduledPollConsumer;
import org.apache.camel.management.mbean.ManagedScript;
import org.apache.camel.management.mbean.ManagedSendDynamicProcessor;
import org.apache.camel.management.mbean.ManagedSendProcessor;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.management.mbean.ManagedSetBody;
import org.apache.camel.management.mbean.ManagedSetExchangePattern;
import org.apache.camel.management.mbean.ManagedSetHeader;
import org.apache.camel.management.mbean.ManagedSetHeaders;
import org.apache.camel.management.mbean.ManagedSetProperty;
import org.apache.camel.management.mbean.ManagedSetVariable;
import org.apache.camel.management.mbean.ManagedSetVariables;
import org.apache.camel.management.mbean.ManagedSplitter;
import org.apache.camel.management.mbean.ManagedStep;
import org.apache.camel.management.mbean.ManagedStickyLoadBalancer;
import org.apache.camel.management.mbean.ManagedStop;
import org.apache.camel.management.mbean.ManagedSupervisingRouteController;
import org.apache.camel.management.mbean.ManagedSuspendableRoute;
import org.apache.camel.management.mbean.ManagedThreadPool;
import org.apache.camel.management.mbean.ManagedThreads;
import org.apache.camel.management.mbean.ManagedThrottler;
import org.apache.camel.management.mbean.ManagedThroughputLogger;
import org.apache.camel.management.mbean.ManagedThrowException;
import org.apache.camel.management.mbean.ManagedTopicLoadBalancer;
import org.apache.camel.management.mbean.ManagedTransformer;
import org.apache.camel.management.mbean.ManagedUnmarshal;
import org.apache.camel.management.mbean.ManagedValidate;
import org.apache.camel.management.mbean.ManagedWeightedLoadBalancer;
import org.apache.camel.management.mbean.ManagedWireTapProcessor;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.DynamicRouterDefinition;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FinallyDefinition;
import org.apache.camel.model.IdempotentConsumerDefinition;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.model.MarshalDefinition;
import org.apache.camel.model.PollDefinition;
import org.apache.camel.model.PollEnrichDefinition;
import org.apache.camel.model.ProcessDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.model.ScriptDefinition;
import org.apache.camel.model.SetBodyDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.SetHeadersDefinition;
import org.apache.camel.model.SetPropertyDefinition;
import org.apache.camel.model.SetVariableDefinition;
import org.apache.camel.model.SetVariablesDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.TransformDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.model.UnmarshalDefinition;
import org.apache.camel.model.ValidateDefinition;
import org.apache.camel.model.loadbalancer.CustomLoadBalancerDefinition;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.processor.ChoiceProcessor;
import org.apache.camel.processor.ClaimCheckProcessor;
import org.apache.camel.processor.Delayer;
import org.apache.camel.processor.DisabledProcessor;
import org.apache.camel.processor.DynamicRouter;
import org.apache.camel.processor.Enricher;
import org.apache.camel.processor.ExchangePatternProcessor;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.processor.FinallyProcessor;
import org.apache.camel.processor.LogProcessor;
import org.apache.camel.processor.LoopProcessor;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.PollEnricher;
import org.apache.camel.processor.PollProcessor;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.processor.RemoveHeaderProcessor;
import org.apache.camel.processor.RemoveHeadersProcessor;
import org.apache.camel.processor.RemovePropertiesProcessor;
import org.apache.camel.processor.RemovePropertyProcessor;
import org.apache.camel.processor.RemoveVariableProcessor;
import org.apache.camel.processor.Resequencer;
import org.apache.camel.processor.RollbackProcessor;
import org.apache.camel.processor.RoutingSlip;
import org.apache.camel.processor.SamplingThrottler;
import org.apache.camel.processor.ScriptProcessor;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.SetBodyProcessor;
import org.apache.camel.processor.SetHeaderProcessor;
import org.apache.camel.processor.SetHeadersProcessor;
import org.apache.camel.processor.SetPropertyProcessor;
import org.apache.camel.processor.SetVariableProcessor;
import org.apache.camel.processor.SetVariablesProcessor;
import org.apache.camel.processor.Splitter;
import org.apache.camel.processor.StepProcessor;
import org.apache.camel.processor.StopProcessor;
import org.apache.camel.processor.StreamResequencer;
import org.apache.camel.processor.ThreadsProcessor;
import org.apache.camel.processor.Throttler;
import org.apache.camel.processor.ThrowExceptionProcessor;
import org.apache.camel.processor.TransformProcessor;
import org.apache.camel.processor.TryProcessor;
import org.apache.camel.processor.WireTapProcessor;
import org.apache.camel.processor.aggregate.AggregateProcessor;
import org.apache.camel.processor.idempotent.IdempotentConsumer;
import org.apache.camel.processor.loadbalancer.FailOverLoadBalancer;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.RandomLoadBalancer;
import org.apache.camel.processor.loadbalancer.RoundRobinLoadBalancer;
import org.apache.camel.processor.loadbalancer.StickyLoadBalancer;
import org.apache.camel.processor.loadbalancer.TopicLoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedLoadBalancer;
import org.apache.camel.processor.transformer.DataTypeProcessor;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.ErrorHandler;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementObjectStrategy;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.support.processor.ConvertBodyProcessor;
import org.apache.camel.support.processor.ConvertHeaderProcessor;
import org.apache.camel.support.processor.ConvertVariableProcessor;
import org.apache.camel.support.processor.MarshalProcessor;
import org.apache.camel.support.processor.PredicateValidatingProcessor;
import org.apache.camel.support.processor.ThroughputLogger;
import org.apache.camel.support.processor.UnmarshalProcessor;

public class DefaultManagementObjectStrategy
implements ManagementObjectStrategy {
    public Object getManagedObjectForCamelContext(CamelContext context) {
        ManagedCamelContext mc = new ManagedCamelContext(context);
        mc.init(context.getManagementStrategy());
        return mc;
    }

    public Object getManagedObjectForCamelHealth(CamelContext context, HealthCheckRegistry healthCheckRegistry) {
        ManagedCamelHealth mch = new ManagedCamelHealth(context, healthCheckRegistry);
        mch.init(context.getManagementStrategy());
        return mch;
    }

    public Object getManagedObjectForComponent(CamelContext context, Component component, String name) {
        ManagedComponent mc = new ManagedComponent(name, component);
        mc.init(context.getManagementStrategy());
        return mc;
    }

    public Object getManagedObjectForDataFormat(CamelContext context, DataFormat dataFormat) {
        ManagedDataFormat md = new ManagedDataFormat(context, dataFormat);
        md.init(context.getManagementStrategy());
        return md;
    }

    public Object getManagedObjectForEndpoint(CamelContext context, Endpoint endpoint) {
        if (!endpoint.isSingleton()) {
            return null;
        }
        if (endpoint instanceof BrowsableEndpoint) {
            BrowsableEndpoint browsableEndpoint = (BrowsableEndpoint)endpoint;
            ManagedBrowsableEndpoint me = new ManagedBrowsableEndpoint(browsableEndpoint);
            me.init(context.getManagementStrategy());
            return me;
        }
        ManagedEndpoint me = new ManagedEndpoint(endpoint);
        me.init(context.getManagementStrategy());
        return me;
    }

    public Object getManagedObjectForRouteController(CamelContext context, RouteController routeController) {
        ManagedService mrc;
        if (routeController instanceof SupervisingRouteController) {
            SupervisingRouteController supervisingRouteController = (SupervisingRouteController)routeController;
            mrc = new ManagedSupervisingRouteController(context, supervisingRouteController);
        } else {
            mrc = new ManagedRouteController(context, routeController);
        }
        mrc.init(context.getManagementStrategy());
        return mrc;
    }

    public Object getManagedObjectForRoute(CamelContext context, Route route) {
        ManagedRoute mr = route.supportsSuspension() ? new ManagedSuspendableRoute(context, route) : new ManagedRoute(context, route);
        mr.init(context.getManagementStrategy());
        return mr;
    }

    public Object getManagedObjectForRouteGroup(CamelContext context, String group) {
        if (group == null) {
            return null;
        }
        ManagedRouteGroup mr = new ManagedRouteGroup(context, group);
        mr.init(context.getManagementStrategy());
        return mr;
    }

    public Object getManagedObjectForThreadPool(CamelContext context, ThreadPoolExecutor threadPool, String id, String sourceId, String routeId, String threadPoolProfileId) {
        ManagedThreadPool mtp = new ManagedThreadPool(context, threadPool, id, sourceId, routeId, threadPoolProfileId);
        mtp.init(context.getManagementStrategy());
        return mtp;
    }

    public Object getManagedObjectForEventNotifier(CamelContext context, EventNotifier eventNotifier) {
        ManagedEventNotifier men = new ManagedEventNotifier(context, eventNotifier);
        men.init(context.getManagementStrategy());
        return men;
    }

    public Object getManagedObjectForConsumer(CamelContext context, Consumer consumer) {
        ManagedConsumer mc;
        if (consumer instanceof ScheduledPollConsumer) {
            ScheduledPollConsumer scheduledPollConsumer = (ScheduledPollConsumer)consumer;
            mc = new ManagedScheduledPollConsumer(context, scheduledPollConsumer);
        } else {
            mc = new ManagedConsumer(context, consumer);
        }
        mc.init(context.getManagementStrategy());
        return mc;
    }

    public Object getManagedObjectForProducer(CamelContext context, Producer producer) {
        ManagedProducer mp = new ManagedProducer(context, producer);
        mp.init(context.getManagementStrategy());
        return mp;
    }

    public Object getManagedObjectForService(CamelContext context, Service service) {
        ManagedService mc = new ManagedService(context, service);
        mc.init(context.getManagementStrategy());
        return mc;
    }

    public Object getManagedObjectForClusterService(CamelContext context, CamelClusterService service) {
        ManagedClusterService mcs = new ManagedClusterService(context, service);
        mcs.init(context.getManagementStrategy());
        return mcs;
    }

    public Object getManagedObjectForProcessor(CamelContext context, Processor processor, NamedNode node, Route route) {
        ManagedProcessor answer = null;
        ProcessorDefinition definition = (ProcessorDefinition)node;
        if (definition instanceof RecipientListDefinition) {
            Pipeline pipeline = (Pipeline)processor;
            Iterator iterator = pipeline.next().iterator();
            while (iterator.hasNext()) {
                Processor value;
                processor = value = (Processor)iterator.next();
            }
        }
        Processor target = processor;
        while (target != null) {
            LoadBalanceDefinition lb;
            if (target instanceof ErrorHandler) {
                return false;
            }
            if (target instanceof ConvertBodyProcessor) {
                answer = new ManagedConvertBody(context, (ConvertBodyProcessor)target, definition);
            } else if (target instanceof ConvertHeaderProcessor) {
                answer = new ManagedConvertHeader(context, (ConvertHeaderProcessor)target, definition);
            } else if (target instanceof ConvertVariableProcessor) {
                answer = new ManagedConvertVariable(context, (ConvertVariableProcessor)target, definition);
            } else if (target instanceof ChoiceProcessor) {
                answer = new ManagedChoice(context, (ChoiceProcessor)target, definition);
            } else if (target instanceof ClaimCheckProcessor) {
                answer = new ManagedClaimCheck(context, (ClaimCheckProcessor)target, definition);
            } else if (target instanceof Delayer) {
                answer = new ManagedDelayer(context, (Delayer)target, definition);
            } else if (target instanceof DisabledProcessor) {
                answer = new ManagedDisabled(context, (DisabledProcessor)target, definition);
            } else if (target instanceof TryProcessor) {
                TryProcessor tryProc = (TryProcessor)target;
                answer = new ManagedDoTry(context, tryProc, (TryDefinition)this.cast(definition));
            } else if (target instanceof CatchProcessor) {
                answer = new ManagedDoCatch(context, (CatchProcessor)target, (CatchDefinition)this.cast(definition));
            } else if (target instanceof FinallyProcessor) {
                answer = new ManagedDoFinally(context, (FinallyProcessor)target, (FinallyDefinition)this.cast(definition));
            } else if (target instanceof Throttler) {
                answer = new ManagedThrottler(context, (Throttler)target, definition);
            } else if (target instanceof DynamicRouter) {
                answer = new ManagedDynamicRouter(context, (DynamicRouter)target, (DynamicRouterDefinition)this.cast(definition));
            } else if (target instanceof RoutingSlip) {
                answer = new ManagedRoutingSlip(context, (RoutingSlip)target, (RoutingSlipDefinition)this.cast(definition));
            } else if (target instanceof FilterProcessor) {
                answer = new ManagedFilter(context, (FilterProcessor)target, (ExpressionNode)definition);
            } else if (target instanceof LogProcessor) {
                answer = new ManagedLog(context, (LogProcessor)target, definition);
            } else if (target instanceof LoopProcessor) {
                answer = new ManagedLoop(context, (LoopProcessor)target, (LoopDefinition)this.cast(definition));
            } else if (target instanceof MarshalProcessor) {
                answer = new ManagedMarshal(context, (MarshalProcessor)target, (MarshalDefinition)this.cast(definition));
            } else if (target instanceof UnmarshalProcessor) {
                answer = new ManagedUnmarshal(context, (UnmarshalProcessor)target, (UnmarshalDefinition)this.cast(definition));
            } else if (target instanceof FailOverLoadBalancer) {
                answer = new ManagedFailoverLoadBalancer(context, (FailOverLoadBalancer)target, (LoadBalanceDefinition)this.cast(definition));
            } else if (target instanceof RandomLoadBalancer) {
                answer = new ManagedRandomLoadBalancer(context, (RandomLoadBalancer)target, (LoadBalanceDefinition)this.cast(definition));
            } else if (target instanceof RoundRobinLoadBalancer) {
                answer = new ManagedRoundRobinLoadBalancer(context, (RoundRobinLoadBalancer)target, (LoadBalanceDefinition)this.cast(definition));
            } else if (target instanceof StickyLoadBalancer) {
                answer = new ManagedStickyLoadBalancer(context, (StickyLoadBalancer)target, (LoadBalanceDefinition)this.cast(definition));
            } else if (target instanceof TopicLoadBalancer) {
                answer = new ManagedTopicLoadBalancer(context, (TopicLoadBalancer)target, (LoadBalanceDefinition)this.cast(definition));
            } else if (target instanceof WeightedLoadBalancer) {
                answer = new ManagedWeightedLoadBalancer(context, (WeightedLoadBalancer)target, (LoadBalanceDefinition)this.cast(definition));
            } else if (target instanceof RecipientList) {
                answer = new ManagedRecipientList(context, (RecipientList)target, (RecipientListDefinition)this.cast(definition));
            } else if (target instanceof Splitter) {
                answer = new ManagedSplitter(context, (Splitter)target, (SplitDefinition)this.cast(definition));
            } else if (target instanceof MulticastProcessor) {
                answer = new ManagedMulticast(context, (MulticastProcessor)target, definition);
            } else if (target instanceof SamplingThrottler) {
                answer = new ManagedSamplingThrottler(context, (SamplingThrottler)target, definition);
            } else if (target instanceof Resequencer) {
                answer = new ManagedResequencer(context, (Resequencer)target, definition);
            } else if (target instanceof RollbackProcessor) {
                answer = new ManagedRollback(context, (RollbackProcessor)target, definition);
            } else if (target instanceof StreamResequencer) {
                answer = new ManagedResequencer(context, (StreamResequencer)target, definition);
            } else if (target instanceof SetBodyProcessor) {
                answer = new ManagedSetBody(context, (SetBodyProcessor)target, (SetBodyDefinition)this.cast(definition));
            } else if (target instanceof RemoveHeaderProcessor) {
                answer = new ManagedRemoveHeader(context, (RemoveHeaderProcessor)target, definition);
            } else if (target instanceof RemoveHeadersProcessor) {
                answer = new ManagedRemoveHeaders(context, (RemoveHeadersProcessor)target, definition);
            } else if (target instanceof SetHeaderProcessor) {
                answer = new ManagedSetHeader(context, (SetHeaderProcessor)target, (SetHeaderDefinition)this.cast(definition));
            } else if (target instanceof SetHeadersProcessor) {
                answer = new ManagedSetHeaders(context, (SetHeadersProcessor)target, (SetHeadersDefinition)this.cast(definition));
            } else if (target instanceof SetVariableProcessor) {
                answer = new ManagedSetVariable(context, (SetVariableProcessor)target, (SetVariableDefinition)this.cast(definition));
            } else if (target instanceof SetVariablesProcessor) {
                answer = new ManagedSetVariables(context, (SetVariablesProcessor)target, (SetVariablesDefinition)this.cast(definition));
            } else if (target instanceof RemovePropertyProcessor) {
                answer = new ManagedRemoveProperty(context, (RemovePropertyProcessor)target, definition);
            } else if (target instanceof RemovePropertiesProcessor) {
                answer = new ManagedRemoveProperties(context, (RemovePropertiesProcessor)target, definition);
            } else if (target instanceof RemoveVariableProcessor) {
                answer = new ManagedRemoveVariable(context, (RemoveVariableProcessor)target, definition);
            } else if (target instanceof SetPropertyProcessor) {
                answer = new ManagedSetProperty(context, (SetPropertyProcessor)target, (SetPropertyDefinition)this.cast(definition));
            } else if (target instanceof ExchangePatternProcessor) {
                answer = new ManagedSetExchangePattern(context, (ExchangePatternProcessor)target, definition);
            } else if (target instanceof ScriptProcessor) {
                answer = new ManagedScript(context, (ScriptProcessor)target, (ScriptDefinition)this.cast(definition));
            } else if (target instanceof StepProcessor) {
                answer = new ManagedStep(context, (StepProcessor)target, definition);
            } else if (target instanceof StopProcessor) {
                answer = new ManagedStop(context, (StopProcessor)target, definition);
            } else if (target instanceof ThreadsProcessor) {
                answer = new ManagedThreads(context, (ThreadsProcessor)target, definition);
            } else if (target instanceof ThrowExceptionProcessor) {
                answer = new ManagedThrowException(context, (ThrowExceptionProcessor)target, definition);
            } else if (target instanceof TransformProcessor) {
                answer = new ManagedTransformer(context, target, (TransformDefinition)this.cast(definition));
            } else if (target instanceof DataTypeProcessor && definition instanceof TransformDefinition) {
                answer = new ManagedTransformer(context, target, (TransformDefinition)definition);
            } else if (target instanceof PredicateValidatingProcessor) {
                answer = new ManagedValidate(context, (PredicateValidatingProcessor)target, (ValidateDefinition)this.cast(definition));
            } else if (target instanceof WireTapProcessor) {
                answer = new ManagedWireTapProcessor(context, (WireTapProcessor)target, definition);
            } else if (target instanceof SendDynamicProcessor) {
                answer = new ManagedSendDynamicProcessor(context, (SendDynamicProcessor)target, definition);
            } else if (target instanceof SendProcessor) {
                LogEndpoint le;
                SendProcessor sp = (SendProcessor)target;
                Endpoint endpoint = sp.getDestination();
                if (endpoint instanceof LogEndpoint && (endpoint = (le = (LogEndpoint)endpoint).getLogger()) instanceof ThroughputLogger) {
                    ThroughputLogger tl = (ThroughputLogger)endpoint;
                    answer = new ManagedThroughputLogger(context, tl, definition);
                }
                if (answer == null) {
                    answer = new ManagedSendProcessor(context, (SendProcessor)target, definition);
                }
            } else if (target instanceof BeanProcessor) {
                answer = new ManagedBeanProcessor(context, (BeanProcessor)target, definition);
            } else if (target instanceof IdempotentConsumer) {
                answer = new ManagedIdempotentConsumer(context, (IdempotentConsumer)target, (IdempotentConsumerDefinition)this.cast(definition));
            } else if (target instanceof AggregateProcessor) {
                answer = new ManagedAggregateProcessor(context, (AggregateProcessor)target, (AggregateDefinition)this.cast(definition));
            } else if (target instanceof Enricher) {
                answer = new ManagedEnricher(context, (Enricher)target, (EnrichDefinition)this.cast(definition));
            } else if (target instanceof PollProcessor) {
                answer = new ManagedPoll(context, (PollProcessor)target, (PollDefinition)this.cast(definition));
            } else if (target instanceof PollEnricher) {
                answer = new ManagedPollEnricher(context, (PollEnricher)target, (PollEnrichDefinition)this.cast(definition));
            }
            if (definition instanceof LoadBalanceDefinition && (lb = (LoadBalanceDefinition)definition).getLoadBalancerType() instanceof CustomLoadBalancerDefinition) {
                answer = new ManagedCustomLoadBalancer(context, (LoadBalancer)target, (LoadBalanceDefinition)definition);
            }
            if (answer != null || !(target instanceof DelegateProcessor)) break;
            target = ((DelegateProcessor)target).getProcessor();
        }
        if (answer == null && definition instanceof ProcessDefinition) {
            answer = new ManagedProcess(context, target, (ProcessDefinition)definition);
        } else if (answer == null) {
            answer = new ManagedProcessor(context, target, definition);
        }
        answer.setRoute(route);
        answer.init(context.getManagementStrategy());
        return answer;
    }

    private <T extends ProcessorDefinition<?>> T cast(ProcessorDefinition<?> definition) {
        return (T)definition;
    }
}

