/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedWeightedBalancerMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.loadbalancer.WeightedLoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.WeightedLoadBalancer;

@ManagedResource(description="Managed Weighted LoadBalancer")
public class ManagedWeightedLoadBalancer
extends ManagedProcessor
implements ManagedWeightedBalancerMBean {
    public ManagedWeightedLoadBalancer(CamelContext context, WeightedLoadBalancer processor, LoadBalanceDefinition definition) {
        super(context, (Processor)processor, (ProcessorDefinition<?>)definition);
    }

    public WeightedLoadBalancer getProcessor() {
        return (WeightedLoadBalancer)super.getProcessor();
    }

    public Integer getSize() {
        return this.getProcessor().getProcessors().size();
    }

    public LoadBalanceDefinition getDefinition() {
        return (LoadBalanceDefinition)super.getDefinition();
    }

    public String getRoundRobin() {
        WeightedLoadBalancerDefinition weighted = (WeightedLoadBalancerDefinition)this.getDefinition().getLoadBalancerType();
        if (weighted != null) {
            return weighted.getRoundRobin();
        }
        return null;
    }

    public String getDistributionRatio() {
        WeightedLoadBalancerDefinition weighted = (WeightedLoadBalancerDefinition)this.getDefinition().getLoadBalancerType();
        if (weighted != null) {
            return weighted.getDistributionRatio();
        }
        return null;
    }

    public String getDistributionRatioDelimiter() {
        WeightedLoadBalancerDefinition weighted = (WeightedLoadBalancerDefinition)this.getDefinition().getLoadBalancerType();
        if (weighted != null) {
            return weighted.getDistributionRatioDelimiter();
        }
        return null;
    }

    public String getLastChosenProcessorId() {
        LoadBalanceDefinition def;
        ProcessorDefinition output;
        int idx = this.getProcessor().getLastChosenProcessorIndex();
        if (idx != -1 && (output = (ProcessorDefinition)(def = this.getDefinition()).getOutputs().get(idx)) != null) {
            return output.getId();
        }
        return null;
    }
}

