/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedAggregateProcessorMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.aggregate.AggregateProcessor;

@ManagedResource(description="Managed AggregateProcessor")
public class ManagedAggregateProcessor
extends ManagedProcessor
implements ManagedAggregateProcessorMBean {
    public ManagedAggregateProcessor(CamelContext context, AggregateProcessor processor, AggregateDefinition definition) {
        super(context, (Processor)processor, (ProcessorDefinition<?>)definition);
    }

    public AggregateProcessor getProcessor() {
        return (AggregateProcessor)super.getProcessor();
    }

    public AggregateDefinition getDefinition() {
        return (AggregateDefinition)super.getDefinition();
    }

    public String getCorrelationExpressionLanguage() {
        if (this.getDefinition().getCorrelationExpression() != null) {
            return this.getDefinition().getCorrelationExpression().getExpressionType().getLanguage();
        }
        return null;
    }

    public String getCorrelationExpression() {
        if (this.getDefinition().getCorrelationExpression() != null) {
            return this.getDefinition().getCorrelationExpression().getExpressionType().getExpression();
        }
        return null;
    }

    public long getCompletionTimeout() {
        return this.getProcessor().getCompletionTimeout();
    }

    public String getCompletionTimeoutLanguage() {
        if (this.getDefinition().getCompletionTimeoutExpression() != null) {
            return this.getDefinition().getCompletionTimeoutExpression().getExpressionType().getLanguage();
        }
        return null;
    }

    public String getCompletionTimeoutExpression() {
        if (this.getDefinition().getCompletionTimeoutExpression() != null) {
            return this.getDefinition().getCompletionTimeoutExpression().getExpressionType().getExpression();
        }
        return null;
    }

    public long getCompletionInterval() {
        return this.getProcessor().getCompletionInterval();
    }

    public long getCompletionTimeoutCheckerInterval() {
        return this.getProcessor().getCompletionTimeoutCheckerInterval();
    }

    public int getCompletionSize() {
        return this.getProcessor().getCompletionSize();
    }

    public String getCompletionSizeExpressionLanguage() {
        if (this.getDefinition().getCompletionSizeExpression() != null) {
            return this.getDefinition().getCompletionSizeExpression().getExpressionType().getLanguage();
        }
        return null;
    }

    public String getCompletionSizeExpression() {
        if (this.getDefinition().getCompletionSizeExpression() != null) {
            return this.getDefinition().getCompletionSizeExpression().getExpressionType().getExpression();
        }
        return null;
    }

    public boolean isCompletionFromBatchConsumer() {
        return this.getProcessor().isCompletionFromBatchConsumer();
    }

    public boolean isCompletionOnNewCorrelationGroup() {
        return this.getProcessor().isCompletionOnNewCorrelationGroup();
    }

    public boolean isIgnoreInvalidCorrelationKeys() {
        return this.getProcessor().isIgnoreInvalidCorrelationKeys();
    }

    public Integer getCloseCorrelationKeyOnCompletion() {
        return this.getProcessor().getCloseCorrelationKeyOnCompletion();
    }

    public boolean isParallelProcessing() {
        return this.getProcessor().isParallelProcessing();
    }

    public boolean isOptimisticLocking() {
        return this.getProcessor().isOptimisticLocking();
    }

    public boolean isEagerCheckCompletion() {
        return this.getProcessor().isEagerCheckCompletion();
    }

    public String getCompletionPredicateLanguage() {
        if (this.getDefinition().getCompletionPredicate() != null) {
            return this.getDefinition().getCompletionPredicate().getExpressionType().getLanguage();
        }
        return null;
    }

    public String getCompletionPredicate() {
        if (this.getDefinition().getCompletionPredicate() != null) {
            return this.getDefinition().getCompletionPredicate().getExpressionType().getExpression();
        }
        return null;
    }

    public boolean isDiscardOnCompletionTimeout() {
        return this.getProcessor().isDiscardOnCompletionTimeout();
    }

    public boolean isForceCompletionOnStop() {
        return this.getProcessor().isCompletionFromBatchConsumer();
    }

    public boolean isCompleteAllOnStop() {
        return this.getProcessor().isCompleteAllOnStop();
    }

    public int getInProgressCompleteExchanges() {
        return this.getProcessor().getInProgressCompleteExchanges();
    }

    public int aggregationRepositoryGroups() {
        Set keys = this.getProcessor().getAggregationRepository().getKeys();
        if (keys != null) {
            return keys.size();
        }
        return 0;
    }

    public int forceCompletionOfGroup(String key) {
        if (this.getProcessor().getAggregateController() != null) {
            return this.getProcessor().getAggregateController().forceCompletionOfGroup(key);
        }
        return 0;
    }

    public int forceCompletionOfAllGroups() {
        if (this.getProcessor().getAggregateController() != null) {
            return this.getProcessor().getAggregateController().forceCompletionOfAllGroups();
        }
        return 0;
    }

    public int forceDiscardingOfGroup(String key) {
        if (this.getProcessor().getAggregateController() != null) {
            return this.getProcessor().getAggregateController().forceDiscardingOfGroup(key);
        }
        return 0;
    }

    public int forceDiscardingOfAllGroups() {
        if (this.getProcessor().getAggregateController() != null) {
            return this.getProcessor().getAggregateController().forceDiscardingOfAllGroups();
        }
        return 0;
    }

    public int getClosedCorrelationKeysCacheSize() {
        return this.getProcessor().getClosedCorrelationKeysCacheSize();
    }

    public void clearClosedCorrelationKeysCache() {
        this.getProcessor().clearClosedCorrelationKeysCache();
    }

    public long getTotalIn() {
        return this.getProcessor().getStatistics().getTotalIn();
    }

    public long getTotalCompleted() {
        return this.getProcessor().getStatistics().getTotalCompleted();
    }

    public long getCompletedBySize() {
        return this.getProcessor().getStatistics().getCompletedBySize();
    }

    public long getCompletedByStrategy() {
        return this.getProcessor().getStatistics().getCompletedByStrategy();
    }

    public long getCompletedByInterval() {
        return this.getProcessor().getStatistics().getCompletedByInterval();
    }

    public long getCompletedByTimeout() {
        return this.getProcessor().getStatistics().getCompletedByTimeout();
    }

    public long getCompletedByPredicate() {
        return this.getProcessor().getStatistics().getCompletedByPredicate();
    }

    public long getCompletedByBatchConsumer() {
        return this.getProcessor().getStatistics().getCompletedByBatchConsumer();
    }

    public long getCompletedByForce() {
        return this.getProcessor().getStatistics().getCompletedByForce();
    }

    public long getDiscarded() {
        return this.getProcessor().getStatistics().getDiscarded();
    }

    public void resetStatistics() {
        this.getProcessor().getStatistics().reset();
    }
}

