/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedRuntimeEndpointRegistryMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.util.URISupport;

@ManagedResource(description="Managed RuntimeEndpointRegistry")
public class ManagedRuntimeEndpointRegistry
extends ManagedService
implements ManagedRuntimeEndpointRegistryMBean {
    private final RuntimeEndpointRegistry registry;
    private boolean sanitize;

    public ManagedRuntimeEndpointRegistry(CamelContext context, RuntimeEndpointRegistry registry) {
        super(context, (Service)registry);
        this.registry = registry;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.sanitize = strategy.getManagementAgent().getMask() != null ? strategy.getManagementAgent().getMask() : true;
    }

    public void clear() {
        this.registry.clear();
    }

    public void reset() {
        this.registry.reset();
    }

    public boolean isEnabled() {
        return this.registry.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.registry.setEnabled(enabled);
    }

    public int getLimit() {
        return this.registry.getLimit();
    }

    public int getSize() {
        return this.registry.size();
    }

    public List<String> getAllEndpoints(boolean includeInputs) {
        return this.registry.getAllEndpoints(includeInputs);
    }

    public List<String> getEndpointsPerRoute(String routeId, boolean includeInputs) {
        return this.registry.getEndpointsPerRoute(routeId, includeInputs);
    }

    public TabularData endpointStatistics() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listRuntimeEndpointsTabularType());
            EndpointRegistry staticRegistry = this.getContext().getEndpointRegistry();
            int index = 0;
            for (RuntimeEndpointRegistry.Statistic stat : this.registry.getEndpointStatistics()) {
                CompositeType ct = CamelOpenMBeanTypes.listRuntimeEndpointsCompositeType();
                String url = stat.getUri();
                boolean isStatic = staticRegistry.isStatic(url);
                boolean isDynamic = staticRegistry.isDynamic(url);
                if (this.sanitize) {
                    url = URISupport.sanitizeUri((String)url);
                }
                String routeId = stat.getRouteId();
                String direction = stat.getDirection();
                long hits = stat.getHits();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"index", "url", "routeId", "direction", "static", "dynamic", "hits"}, new Object[]{index, url, routeId, direction, isStatic, isDynamic, hits});
                answer.put(data);
                ++index;
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

