/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.Component;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ComponentVerifierExtension;
import org.apache.camel.api.management.mbean.ManagedComponentMBean;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.HealthCheckComponent;
import org.apache.camel.util.CastUtils;

@ManagedResource(description="Managed Component")
public class ManagedComponent
implements ManagedInstance,
ManagedComponentMBean {
    private final Component component;
    private final String name;

    public ManagedComponent(String name, Component component) {
        this.name = name;
        this.component = component;
    }

    public void init(ManagementStrategy strategy) {
    }

    public Component getComponent() {
        return this.component;
    }

    public String getComponentName() {
        return this.name;
    }

    public String getState() {
        Component component = this.component;
        if (component instanceof StatefulService) {
            StatefulService statefulService = (StatefulService)component;
            ServiceStatus status = statefulService.getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    public String getCamelId() {
        return this.component.getCamelContext().getName();
    }

    public String getCamelManagementName() {
        return this.component.getCamelContext().getManagementName();
    }

    public Object getInstance() {
        return this.component;
    }

    public boolean isHealthCheckSupported() {
        return this.component instanceof HealthCheckComponent;
    }

    public boolean isHealthCheckConsumerEnabled() {
        Component component = this.component;
        if (component instanceof HealthCheckComponent) {
            HealthCheckComponent healthCheckComponent = (HealthCheckComponent)component;
            return healthCheckComponent.isHealthCheckConsumerEnabled();
        }
        return false;
    }

    public boolean isHealthCheckProducerEnabled() {
        Component component = this.component;
        if (component instanceof HealthCheckComponent) {
            HealthCheckComponent healthCheckComponent = (HealthCheckComponent)component;
            return healthCheckComponent.isHealthCheckProducerEnabled();
        }
        return false;
    }

    public boolean isVerifySupported() {
        return this.component.getExtension(ComponentVerifierExtension.class).isPresent();
    }

    public ComponentVerifierExtension.Result verify(String scope, Map<String, String> options) {
        try {
            ComponentVerifierExtension.Scope scopeEnum = ComponentVerifierExtension.Scope.fromString((String)scope);
            Optional verifier = this.component.getExtension(ComponentVerifierExtension.class);
            if (verifier.isPresent()) {
                ComponentVerifierExtension.Result result = ((ComponentVerifierExtension)verifier.get()).verify(scopeEnum, CastUtils.cast(options));
                String rstatus = result.getStatus().toString();
                String rscope = result.getScope().toString();
                return new ResultImpl(ComponentVerifierExtension.Scope.valueOf((String)rscope), ComponentVerifierExtension.Result.Status.valueOf((String)rstatus), result.getErrors().stream().map(this::translate).toList());
            }
            return new ResultImpl(ComponentVerifierExtension.Scope.PARAMETERS, ComponentVerifierExtension.Result.Status.UNSUPPORTED, Collections.emptyList());
        }
        catch (IllegalArgumentException e) {
            return new ResultImpl(ComponentVerifierExtension.Scope.PARAMETERS, ComponentVerifierExtension.Result.Status.UNSUPPORTED, Collections.singletonList(new VerificationErrorImpl((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.UNSUPPORTED_SCOPE, "Unsupported scope: " + scope)));
        }
    }

    private ComponentVerifierExtension.VerificationError translate(ComponentVerifierExtension.VerificationError error) {
        return new VerificationErrorImpl(this.translate(error.getCode()), error.getDescription(), error.getParameterKeys(), this.translate(error.getDetails()));
    }

    private Map<ComponentVerifierExtension.VerificationError.Attribute, Object> translate(Map<ComponentVerifierExtension.VerificationError.Attribute, Object> details) {
        return details.entrySet().stream().collect(Collectors.toMap(e -> this.translate((ComponentVerifierExtension.VerificationError.Attribute)e.getKey()), Map.Entry::getValue));
    }

    private ComponentVerifierExtension.VerificationError.Attribute translate(ComponentVerifierExtension.VerificationError.Attribute attribute) {
        if (attribute == ComponentVerifierExtension.VerificationError.GroupAttribute.GROUP_NAME) {
            return ComponentVerifierExtension.VerificationError.GroupAttribute.GROUP_NAME;
        }
        if (attribute == ComponentVerifierExtension.VerificationError.GroupAttribute.GROUP_OPTIONS) {
            return ComponentVerifierExtension.VerificationError.GroupAttribute.GROUP_OPTIONS;
        }
        if (attribute == ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_CODE) {
            return ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_CODE;
        }
        if (attribute == ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_REDIRECT) {
            return ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_REDIRECT;
        }
        if (attribute == ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_TEXT) {
            return ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_TEXT;
        }
        if (attribute == ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS) {
            return ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS;
        }
        if (attribute == ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE) {
            return ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE;
        }
        if (attribute != null) {
            return ComponentVerifierExtension.VerificationError.asAttribute((String)attribute.getName());
        }
        return null;
    }

    private ComponentVerifierExtension.VerificationError.Code translate(ComponentVerifierExtension.VerificationError.Code code) {
        if (code == ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION) {
            return ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION;
        }
        if (code == ComponentVerifierExtension.VerificationError.StandardCode.EXCEPTION) {
            return ComponentVerifierExtension.VerificationError.StandardCode.EXCEPTION;
        }
        if (code == ComponentVerifierExtension.VerificationError.StandardCode.INTERNAL) {
            return ComponentVerifierExtension.VerificationError.StandardCode.INTERNAL;
        }
        if (code == ComponentVerifierExtension.VerificationError.StandardCode.MISSING_PARAMETER) {
            return ComponentVerifierExtension.VerificationError.StandardCode.MISSING_PARAMETER;
        }
        if (code == ComponentVerifierExtension.VerificationError.StandardCode.UNKNOWN_PARAMETER) {
            return ComponentVerifierExtension.VerificationError.StandardCode.UNKNOWN_PARAMETER;
        }
        if (code == ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER) {
            return ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER;
        }
        if (code == ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_GROUP_COMBINATION) {
            return ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_GROUP_COMBINATION;
        }
        if (code == ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_VALUE) {
            return ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_VALUE;
        }
        if (code == ComponentVerifierExtension.VerificationError.StandardCode.INCOMPLETE_PARAMETER_GROUP) {
            return ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_GROUP_COMBINATION;
        }
        if (code == ComponentVerifierExtension.VerificationError.StandardCode.UNSUPPORTED) {
            return ComponentVerifierExtension.VerificationError.StandardCode.UNSUPPORTED;
        }
        if (code == ComponentVerifierExtension.VerificationError.StandardCode.UNSUPPORTED_SCOPE) {
            return ComponentVerifierExtension.VerificationError.StandardCode.UNSUPPORTED_SCOPE;
        }
        if (code == ComponentVerifierExtension.VerificationError.StandardCode.UNSUPPORTED_COMPONENT) {
            return ComponentVerifierExtension.VerificationError.StandardCode.UNSUPPORTED_COMPONENT;
        }
        if (code == ComponentVerifierExtension.VerificationError.StandardCode.GENERIC) {
            return ComponentVerifierExtension.VerificationError.StandardCode.GENERIC;
        }
        if (code != null) {
            return ComponentVerifierExtension.VerificationError.asCode((String)code.getName());
        }
        return null;
    }

    public static class ResultImpl
    implements ComponentVerifierExtension.Result {
        private final ComponentVerifierExtension.Scope scope;
        private final ComponentVerifierExtension.Result.Status status;
        private final List<ComponentVerifierExtension.VerificationError> errors;

        public ResultImpl(ComponentVerifierExtension.Scope scope, ComponentVerifierExtension.Result.Status status, List<ComponentVerifierExtension.VerificationError> errors) {
            this.scope = scope;
            this.status = status;
            this.errors = errors;
        }

        public ComponentVerifierExtension.Scope getScope() {
            return this.scope;
        }

        public ComponentVerifierExtension.Result.Status getStatus() {
            return this.status;
        }

        public List<ComponentVerifierExtension.VerificationError> getErrors() {
            return this.errors;
        }
    }

    public static class VerificationErrorImpl
    implements ComponentVerifierExtension.VerificationError {
        private final ComponentVerifierExtension.VerificationError.Code code;
        private final String description;
        private final Set<String> parameterKeys;
        private final Map<ComponentVerifierExtension.VerificationError.Attribute, Object> details;

        public VerificationErrorImpl(ComponentVerifierExtension.VerificationError.Code code, String description) {
            this.code = code;
            this.description = description;
            this.parameterKeys = Collections.emptySet();
            this.details = Collections.emptyMap();
        }

        public VerificationErrorImpl(ComponentVerifierExtension.VerificationError.Code code, String description, Set<String> parameterKeys, Map<ComponentVerifierExtension.VerificationError.Attribute, Object> details) {
            this.code = code;
            this.description = description;
            this.parameterKeys = parameterKeys;
            this.details = details;
        }

        public ComponentVerifierExtension.VerificationError.Code getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public Set<String> getParameterKeys() {
            return this.parameterKeys;
        }

        public Map<ComponentVerifierExtension.VerificationError.Attribute, Object> getDetails() {
            return this.details;
        }
    }
}

