/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedEndpointMBean;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.ManagementStrategy;

@ManagedResource(description="Managed Endpoint")
public class ManagedEndpoint
implements ManagedInstance,
ManagedEndpointMBean {
    private final Endpoint endpoint;

    public ManagedEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void init(ManagementStrategy strategy) {
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public String getCamelId() {
        return this.endpoint.getCamelContext().getName();
    }

    public String getCamelManagementName() {
        return this.endpoint.getCamelContext().getManagementName();
    }

    public String getEndpointUri() {
        return this.endpoint.getEndpointUri();
    }

    public String getEndpointBaseUri() {
        return this.endpoint.getEndpointBaseUri();
    }

    public boolean isSingleton() {
        return this.endpoint.isSingleton();
    }

    public boolean isRemote() {
        return this.endpoint.isRemote();
    }

    public String getState() {
        Endpoint endpoint = this.endpoint;
        if (endpoint instanceof StatefulService) {
            StatefulService statefulService = (StatefulService)endpoint;
            ServiceStatus status = statefulService.getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    public String getServiceLocationUrl() {
        Endpoint endpoint = this.endpoint;
        if (endpoint instanceof EndpointServiceLocation) {
            EndpointServiceLocation raa = (EndpointServiceLocation)endpoint;
            return raa.getServiceUrl();
        }
        return null;
    }

    public String getServiceLocationProtocol() {
        Endpoint endpoint = this.endpoint;
        if (endpoint instanceof EndpointServiceLocation) {
            EndpointServiceLocation raa = (EndpointServiceLocation)endpoint;
            return raa.getServiceProtocol();
        }
        return null;
    }

    public Map<String, String> getServiceLocationMetadata() {
        Endpoint endpoint = this.endpoint;
        if (endpoint instanceof EndpointServiceLocation) {
            EndpointServiceLocation raa = (EndpointServiceLocation)endpoint;
            return raa.getServiceMetadata();
        }
        return null;
    }

    public Endpoint getInstance() {
        return this.endpoint;
    }
}

