/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedStreamCachingStrategyMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.StreamCachingStrategy;

@ManagedResource(description="Managed StreamCachingStrategy")
public class ManagedStreamCachingStrategy
extends ManagedService
implements ManagedStreamCachingStrategyMBean {
    private final CamelContext camelContext;
    private final StreamCachingStrategy streamCachingStrategy;
    private final String[] allowClasses;
    private final String[] denyClasses;

    public ManagedStreamCachingStrategy(CamelContext camelContext, StreamCachingStrategy streamCachingStrategy) {
        super(camelContext, (Service)streamCachingStrategy);
        this.camelContext = camelContext;
        this.streamCachingStrategy = streamCachingStrategy;
        this.allowClasses = streamCachingStrategy.getAllowClasses() != null ? (String[])streamCachingStrategy.getAllowClasses().stream().map(Class::getName).toArray(String[]::new) : null;
        this.denyClasses = streamCachingStrategy.getDenyClasses() != null ? (String[])streamCachingStrategy.getDenyClasses().stream().map(Class::getName).toArray(String[]::new) : null;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public StreamCachingStrategy getStreamCachingStrategy() {
        return this.streamCachingStrategy;
    }

    public boolean isEnabled() {
        return this.streamCachingStrategy.isEnabled();
    }

    public String[] getAllowClasses() {
        return this.allowClasses;
    }

    public String[] getDenyClasses() {
        return this.denyClasses;
    }

    public boolean isSpoolEnabled() {
        return this.streamCachingStrategy.isSpoolEnabled();
    }

    public String getSpoolDirectory() {
        if (this.streamCachingStrategy.getSpoolDirectory() != null) {
            return this.streamCachingStrategy.getSpoolDirectory().getPath();
        }
        return null;
    }

    public String getSpoolCipher() {
        return this.streamCachingStrategy.getSpoolCipher();
    }

    public void setSpoolThreshold(long threshold) {
        this.streamCachingStrategy.setSpoolThreshold(threshold);
    }

    public long getSpoolThreshold() {
        return this.streamCachingStrategy.getSpoolThreshold();
    }

    public void setSpoolUsedHeapMemoryThreshold(int percentage) {
        this.streamCachingStrategy.setSpoolUsedHeapMemoryThreshold(percentage);
    }

    public int getSpoolUsedHeapMemoryThreshold() {
        return this.streamCachingStrategy.getSpoolUsedHeapMemoryThreshold();
    }

    public void setSpoolUsedHeapMemoryLimit(ManagedStreamCachingStrategyMBean.SpoolUsedHeapMemoryLimit limit) {
        StreamCachingStrategy.SpoolUsedHeapMemoryLimit l;
        if (limit == null) {
            l = null;
        } else {
            l = switch (limit) {
                default -> throw new IncompatibleClassChangeError();
                case ManagedStreamCachingStrategyMBean.SpoolUsedHeapMemoryLimit.Committed -> StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Committed;
                case ManagedStreamCachingStrategyMBean.SpoolUsedHeapMemoryLimit.Max -> StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Max;
            };
        }
        this.streamCachingStrategy.setSpoolUsedHeapMemoryLimit(l);
    }

    public ManagedStreamCachingStrategyMBean.SpoolUsedHeapMemoryLimit getSpoolUsedHeapMemoryLimit() {
        StreamCachingStrategy.SpoolUsedHeapMemoryLimit l = this.streamCachingStrategy.getSpoolUsedHeapMemoryLimit();
        if (l == null) {
            return null;
        }
        return switch (l) {
            default -> throw new IncompatibleClassChangeError();
            case StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Committed -> ManagedStreamCachingStrategyMBean.SpoolUsedHeapMemoryLimit.Committed;
            case StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Max -> ManagedStreamCachingStrategyMBean.SpoolUsedHeapMemoryLimit.Max;
        };
    }

    public void setBufferSize(int bufferSize) {
        this.streamCachingStrategy.setBufferSize(bufferSize);
    }

    public int getBufferSize() {
        return this.streamCachingStrategy.getBufferSize();
    }

    public void setRemoveSpoolDirectoryWhenStopping(boolean remove) {
        this.streamCachingStrategy.setRemoveSpoolDirectoryWhenStopping(remove);
    }

    public boolean isRemoveSpoolDirectoryWhenStopping() {
        return this.streamCachingStrategy.isRemoveSpoolDirectoryWhenStopping();
    }

    public void setAnySpoolRules(boolean any) {
        this.streamCachingStrategy.setAnySpoolRules(any);
    }

    public boolean isAnySpoolRules() {
        return this.streamCachingStrategy.isAnySpoolRules();
    }

    public long getCacheMemoryCounter() {
        return this.streamCachingStrategy.getStatistics().getCacheMemoryCounter();
    }

    public long getCacheMemorySize() {
        return this.streamCachingStrategy.getStatistics().getCacheMemorySize();
    }

    public long getCacheMemoryAverageSize() {
        return this.streamCachingStrategy.getStatistics().getCacheMemoryAverageSize();
    }

    public long getCacheSpoolCounter() {
        return this.streamCachingStrategy.getStatistics().getCacheSpoolCounter();
    }

    public long getCacheSpoolSize() {
        return this.streamCachingStrategy.getStatistics().getCacheSpoolSize();
    }

    public long getCacheSpoolAverageSize() {
        return this.streamCachingStrategy.getStatistics().getCacheSpoolAverageSize();
    }

    public boolean isStatisticsEnabled() {
        return this.streamCachingStrategy.getStatistics().isStatisticsEnabled();
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.streamCachingStrategy.getStatistics().setStatisticsEnabled(enabled);
    }

    public void resetStatistics() {
        this.streamCachingStrategy.getStatistics().reset();
    }
}

