/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedProcessMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed Process")
public class ManagedProcess
extends ManagedProcessor
implements ManagedProcessMBean {
    private final Processor processor;
    private String processorClassName;

    public ManagedProcess(CamelContext context, Processor processor, ProcessDefinition definition) {
        super(context, processor, (ProcessorDefinition<?>)definition);
        this.processor = processor;
    }

    public ProcessDefinition getDefinition() {
        return (ProcessDefinition)super.getDefinition();
    }

    public String getRef() {
        return this.getDefinition().getRef();
    }

    public String getProcessorClassName() {
        if (this.processorClassName != null) {
            return this.processorClassName;
        }
        Processor target = this.processor;
        if (target instanceof DelegateProcessor) {
            DelegateProcessor delegateProcessor = (DelegateProcessor)target;
            target = delegateProcessor.getProcessor();
        }
        this.processorClassName = ObjectHelper.className((Object)target);
        return this.processorClassName;
    }
}

