/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedBrowsableEndpointMBean;
import org.apache.camel.management.mbean.ManagedEndpoint;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

@ManagedResource(description="Managed BrowsableEndpoint")
public class ManagedBrowsableEndpoint
extends ManagedEndpoint
implements ManagedBrowsableEndpointMBean {
    public ManagedBrowsableEndpoint(BrowsableEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public BrowsableEndpoint getEndpoint() {
        return (BrowsableEndpoint)super.getEndpoint();
    }

    public BrowsableEndpoint getInstance() {
        return this.getEndpoint();
    }

    public int getBrowseLimit() {
        return this.getEndpoint().getBrowseLimit();
    }

    public int queueSize() {
        return this.getEndpoint().getExchanges().size();
    }

    public String browseExchange(Integer index) {
        List exchanges = this.getEndpoint().getExchanges();
        if (index >= exchanges.size()) {
            return null;
        }
        Exchange exchange = (Exchange)exchanges.get(index);
        if (exchange == null) {
            return null;
        }
        return exchange.toString();
    }

    public String browseMessageBody(Integer index) {
        List exchanges = this.getEndpoint().getExchanges();
        if (index >= exchanges.size()) {
            return null;
        }
        Exchange exchange = (Exchange)exchanges.get(index);
        if (exchange == null) {
            return null;
        }
        Message msg = exchange.getMessage();
        return MessageHelper.extractBodyAsString((Message)msg);
    }

    public String browseMessageAsXml(Integer index, Boolean includeBody) {
        List exchanges = this.getEndpoint().getExchanges();
        if (index >= exchanges.size()) {
            return null;
        }
        Exchange exchange = (Exchange)exchanges.get(index);
        if (exchange == null) {
            return null;
        }
        Message msg = exchange.getMessage();
        return MessageHelper.dumpAsXml((Message)msg, (boolean)includeBody);
    }

    public String browseAllMessagesAsXml(Boolean includeBody) {
        return this.browseRangeMessagesAsXml(0, Integer.MAX_VALUE, includeBody);
    }

    public String browseRangeMessagesAsXml(Integer fromIndex, Integer toIndex, Boolean includeBody) {
        if (fromIndex == null) {
            fromIndex = 0;
        }
        if (toIndex == null) {
            toIndex = Integer.MAX_VALUE;
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("From index cannot be larger than to index, was: " + fromIndex + " > " + toIndex);
        }
        List exchanges = this.getEndpoint().getExchanges();
        if (exchanges.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<messages>");
        for (int i = fromIndex.intValue(); i < exchanges.size() && i <= toIndex; ++i) {
            Exchange exchange = (Exchange)exchanges.get(i);
            Message msg = exchange.getMessage();
            String xml = MessageHelper.dumpAsXml((Message)msg, (boolean)includeBody);
            sb.append("\n").append(xml);
        }
        sb.append("\n</messages>");
        return sb.toString();
    }

    public String browseMessageAsJSon(Integer index, Boolean includeBody) {
        List exchanges = this.getEndpoint().getExchanges();
        if (index >= exchanges.size()) {
            return null;
        }
        Exchange exchange = (Exchange)exchanges.get(index);
        if (exchange == null) {
            return null;
        }
        Message msg = exchange.getMessage();
        return MessageHelper.dumpAsJSon((Message)msg, (boolean)includeBody);
    }

    public String browseAllMessagesAsJSon(Boolean includeBody) {
        return this.browseRangeMessagesAsJSon(0, Integer.MAX_VALUE, includeBody);
    }

    public String browseRangeMessagesAsJSon(Integer fromIndex, Integer toIndex, Boolean includeBody) {
        if (fromIndex == null) {
            fromIndex = 0;
        }
        if (toIndex == null) {
            toIndex = Integer.MAX_VALUE;
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("From index cannot be larger than to index, was: " + fromIndex + " > " + toIndex);
        }
        List exchanges = this.getEndpoint().getExchanges();
        if (exchanges.isEmpty()) {
            return null;
        }
        JsonArray arr = new JsonArray();
        for (int i = fromIndex.intValue(); i < exchanges.size() && i <= toIndex; ++i) {
            Exchange exchange = (Exchange)exchanges.get(i);
            Message msg = exchange.getMessage();
            JsonObject jo = MessageHelper.dumpAsJSonObject((Message)msg, (boolean)false, (boolean)false, (boolean)includeBody, (boolean)true, (boolean)true, (boolean)true, (int)131072);
            arr.add((Object)jo);
        }
        String out = arr.toJson();
        return Jsoner.prettyPrint((String)out);
    }
}

