/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.TypeConverters;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.debugger.BacklogTracer;
import org.apache.camel.impl.engine.DefaultCompileStrategy;
import org.apache.camel.impl.engine.PooledExchangeFactory;
import org.apache.camel.impl.engine.PooledProcessorExchangeFactory;
import org.apache.camel.impl.engine.PrototypeExchangeFactory;
import org.apache.camel.impl.engine.PrototypeProcessorExchangeFactory;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelLifecycleStrategy;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.BacklogDebugger;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.CliConnectorFactory;
import org.apache.camel.spi.CompileStrategy;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.DumpRoutesStrategy;
import org.apache.camel.spi.EndpointServiceRegistry;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.GroovyScriptCompiler;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.ManagementObjectNameStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StartupConditionStrategy;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spi.VariableRepositoryFactory;
import org.apache.camel.support.ClassicUuidGenerator;
import org.apache.camel.support.DefaultContextReloadStrategy;
import org.apache.camel.support.DefaultUuidGenerator;
import org.apache.camel.support.OffUuidGenerator;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.RouteWatcherReloadStrategy;
import org.apache.camel.support.ShortUuidGenerator;
import org.apache.camel.support.SimpleUuidGenerator;
import org.apache.camel.support.jsse.GlobalSSLContextParametersSupplier;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.startup.BacklogStartupStepRecorder;
import org.apache.camel.support.startup.LoggingStartupStepRecorder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.vault.AwsVaultConfiguration;
import org.apache.camel.vault.AzureVaultConfiguration;
import org.apache.camel.vault.GcpVaultConfiguration;
import org.apache.camel.vault.HashicorpVaultConfiguration;
import org.apache.camel.vault.IBMSecretsManagerVaultConfiguration;
import org.apache.camel.vault.KubernetesConfigMapVaultConfiguration;
import org.apache.camel.vault.KubernetesVaultConfiguration;
import org.apache.camel.vault.VaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultConfigurationConfigurer {
    public static final Logger LOG = LoggerFactory.getLogger(DefaultConfigurationConfigurer.class);

    private DefaultConfigurationConfigurer() {
    }

    public static void configure(CamelContext camelContext, DefaultConfigurationProperties<?> config) throws Exception {
        GroovyScriptCompiler gsc;
        RouteWatcherReloadStrategy reloader;
        ExtendedCamelContext ecc = camelContext.getCamelContextExtension();
        if (config.getStartupRecorder() != null) {
            if ("false".equals(config.getStartupRecorder())) {
                ecc.getStartupStepRecorder().setEnabled(false);
            } else if ("logging".equals(config.getStartupRecorder())) {
                if (!(ecc.getStartupStepRecorder() instanceof LoggingStartupStepRecorder)) {
                    ecc.setStartupStepRecorder((StartupStepRecorder)new LoggingStartupStepRecorder());
                }
            } else if ("backlog".equals(config.getStartupRecorder())) {
                if (!(ecc.getStartupStepRecorder() instanceof BacklogStartupStepRecorder)) {
                    ecc.setStartupStepRecorder((StartupStepRecorder)new BacklogStartupStepRecorder());
                }
            } else if ("java-flight-recorder".equals(config.getStartupRecorder()) && !ecc.getStartupStepRecorder().getClass().getName().startsWith("org.apache.camel.startup.jfr")) {
                throw new IllegalArgumentException("Cannot find Camel Java Flight Recorder on classpath. Add camel-jfr to classpath.");
            }
        }
        ecc.getStartupStepRecorder().setMaxDepth(config.getStartupRecorderMaxDepth());
        ecc.getStartupStepRecorder().setRecording(config.isStartupRecorderRecording());
        ecc.getStartupStepRecorder().setStartupRecorderDuration(config.getStartupRecorderDuration());
        ecc.getStartupStepRecorder().setRecordingDir(config.getStartupRecorderDir());
        ecc.getStartupStepRecorder().setRecordingProfile(config.getStartupRecorderProfile());
        PluginHelper.getBeanPostProcessor((ExtendedCamelContext)ecc).setEnabled(config.isBeanPostProcessorEnabled());
        BeanIntrospection beanIntrospection = PluginHelper.getBeanIntrospection((ExtendedCamelContext)ecc);
        beanIntrospection.setExtendedStatistics(config.isBeanIntrospectionExtendedStatistics());
        if (config.getBeanIntrospectionLoggingLevel() != null) {
            beanIntrospection.setLoggingLevel(config.getBeanIntrospectionLoggingLevel());
        }
        beanIntrospection.afterPropertiesConfigured(camelContext);
        if ("pooled".equals(config.getExchangeFactory())) {
            ecc.setExchangeFactory((ExchangeFactory)new PooledExchangeFactory());
            ecc.setProcessorExchangeFactory((ProcessorExchangeFactory)new PooledProcessorExchangeFactory());
        } else if ("prototype".equals(config.getExchangeFactory())) {
            ecc.setExchangeFactory((ExchangeFactory)new PrototypeExchangeFactory());
            ecc.setProcessorExchangeFactory((ProcessorExchangeFactory)new PrototypeProcessorExchangeFactory());
        }
        ecc.getExchangeFactory().setCapacity(config.getExchangeFactoryCapacity());
        ecc.getProcessorExchangeFactory().setCapacity(config.getExchangeFactoryCapacity());
        ecc.getExchangeFactory().setStatisticsEnabled(config.isExchangeFactoryStatisticsEnabled());
        ecc.getProcessorExchangeFactory().setStatisticsEnabled(config.isExchangeFactoryStatisticsEnabled());
        if (!config.isJmxEnabled()) {
            camelContext.disableJMX();
        }
        if (config.getName() != null) {
            ecc.setName(config.getName());
        }
        if (config.getDescription() != null) {
            ecc.setDescription(config.getDescription());
        }
        if (config.getStartupSummaryLevel() != null) {
            camelContext.setStartupSummaryLevel(config.getStartupSummaryLevel());
        }
        if (config.getShutdownTimeout() > 0) {
            camelContext.getShutdownStrategy().setTimeout((long)config.getShutdownTimeout());
        }
        camelContext.getShutdownStrategy().setSuppressLoggingOnTimeout(config.isShutdownSuppressLoggingOnTimeout());
        camelContext.getShutdownStrategy().setShutdownNowOnTimeout(config.isShutdownNowOnTimeout());
        camelContext.getShutdownStrategy().setShutdownRoutesInReverseOrder(config.isShutdownRoutesInReverseOrder());
        camelContext.getShutdownStrategy().setLogInflightExchangesOnTimeout(config.isShutdownLogInflightExchangesOnTimeout());
        camelContext.getInflightRepository().setInflightBrowseEnabled(config.isInflightRepositoryBrowseEnabled());
        if (config.getLogDebugMaxChars() != 0) {
            camelContext.getGlobalOptions().put("CamelLogDebugBodyMaxChars", Integer.toString(config.getLogDebugMaxChars()));
        }
        camelContext.setStreamCaching(Boolean.valueOf(config.isStreamCachingEnabled()));
        camelContext.getStreamCachingStrategy().setAllowClasses(config.getStreamCachingAllowClasses());
        camelContext.getStreamCachingStrategy().setDenyClasses(config.getStreamCachingDenyClasses());
        camelContext.getStreamCachingStrategy().setSpoolEnabled(config.isStreamCachingSpoolEnabled());
        camelContext.getStreamCachingStrategy().setAnySpoolRules(config.isStreamCachingAnySpoolRules());
        camelContext.getStreamCachingStrategy().setBufferSize(config.getStreamCachingBufferSize());
        camelContext.getStreamCachingStrategy().setRemoveSpoolDirectoryWhenStopping(config.isStreamCachingRemoveSpoolDirectoryWhenStopping());
        camelContext.getStreamCachingStrategy().setSpoolCipher(config.getStreamCachingSpoolCipher());
        if (config.getStreamCachingSpoolDirectory() != null) {
            camelContext.getStreamCachingStrategy().setSpoolDirectory(config.getStreamCachingSpoolDirectory());
        }
        if (config.getStreamCachingSpoolThreshold() != 0L) {
            camelContext.getStreamCachingStrategy().setSpoolThreshold(config.getStreamCachingSpoolThreshold());
        }
        if (config.getStreamCachingSpoolUsedHeapMemoryLimit() != null) {
            StreamCachingStrategy.SpoolUsedHeapMemoryLimit limit;
            if ("Committed".equalsIgnoreCase(config.getStreamCachingSpoolUsedHeapMemoryLimit())) {
                limit = StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Committed;
            } else if ("Max".equalsIgnoreCase(config.getStreamCachingSpoolUsedHeapMemoryLimit())) {
                limit = StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Max;
            } else {
                throw new IllegalArgumentException("Invalid option " + config.getStreamCachingSpoolUsedHeapMemoryLimit() + " must either be Committed or Max");
            }
            camelContext.getStreamCachingStrategy().setSpoolUsedHeapMemoryLimit(limit);
        }
        if (config.getStreamCachingSpoolUsedHeapMemoryThreshold() != 0) {
            camelContext.getStreamCachingStrategy().setSpoolUsedHeapMemoryThreshold(config.getStreamCachingSpoolUsedHeapMemoryThreshold());
        }
        if ("default".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator((UuidGenerator)new DefaultUuidGenerator());
        } else if ("short".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator((UuidGenerator)new ShortUuidGenerator());
        } else if ("classic".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator((UuidGenerator)new ClassicUuidGenerator());
        } else if ("simple".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator((UuidGenerator)new SimpleUuidGenerator());
        } else if ("off".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator((UuidGenerator)new OffUuidGenerator());
            LOG.warn("Using OffUuidGenerator (Only intended for development purposes)");
        }
        if (config.getLogName() != null) {
            camelContext.getGlobalOptions().put("CamelLogEipName", config.getLogName());
        }
        if (config.getLogLanguage() != null) {
            camelContext.getGlobalOptions().put("CamelLogEipLanguage", config.getLogLanguage());
        }
        camelContext.setLogMask(Boolean.valueOf(config.isLogMask()));
        camelContext.setLogExhaustedMessageBody(Boolean.valueOf(config.isLogExhaustedMessageBody()));
        camelContext.setAutoStartup(Boolean.valueOf(config.isAutoStartup()));
        camelContext.setAutoStartupExcludePattern(config.getAutoStartupExcludePattern());
        camelContext.setAllowUseOriginalMessage(Boolean.valueOf(config.isAllowUseOriginalMessage()));
        camelContext.setCaseInsensitiveHeaders(Boolean.valueOf(config.isCaseInsensitiveHeaders()));
        camelContext.setAutowiredEnabled(Boolean.valueOf(config.isAutowiredEnabled()));
        camelContext.setUseBreadcrumb(Boolean.valueOf(config.isUseBreadcrumb()));
        camelContext.setUseDataType(Boolean.valueOf(config.isUseDataType()));
        camelContext.setDumpRoutes(config.getDumpRoutes());
        camelContext.setUseMDCLogging(Boolean.valueOf(config.isUseMdcLogging()));
        camelContext.setMDCLoggingKeysPattern(config.getMdcLoggingKeysPattern());
        camelContext.setLoadTypeConverters(Boolean.valueOf(config.isLoadTypeConverters()));
        camelContext.setTypeConverterStatisticsEnabled(Boolean.valueOf(config.isTypeConverterStatisticsEnabled()));
        camelContext.setLoadHealthChecks(Boolean.valueOf(config.isLoadHealthChecks()));
        camelContext.setDevConsole(Boolean.valueOf(config.isDevConsoleEnabled()));
        camelContext.setModeline(Boolean.valueOf(config.isModeline()));
        if (config.isRoutesReloadEnabled()) {
            reloader = new RouteWatcherReloadStrategy(config.getRoutesReloadDirectory(), config.isRoutesReloadDirectoryRecursive());
            reloader.setPattern(config.getRoutesReloadPattern());
            reloader.setRemoveAllRoutes(config.isRoutesReloadRemoveAllRoutes());
            camelContext.addService((Object)reloader);
        }
        if (config.getDumpRoutes() != null) {
            DumpRoutesStrategy drs = (DumpRoutesStrategy)camelContext.getCamelContextExtension().getContextPlugin(DumpRoutesStrategy.class);
            drs.setInclude(config.getDumpRoutesInclude());
            drs.setLog(config.isDumpRoutesLog());
            drs.setUriAsParameters(config.isDumpRoutesUriAsParameters());
            drs.setGeneratedIds(config.isDumpRoutesGeneratedIds());
            drs.setResolvePlaceholders(config.isDumpRoutesResolvePlaceholders());
            drs.setOutput(config.getDumpRoutesOutput());
        }
        if (config.isContextReloadEnabled() && camelContext.hasService(ContextReloadStrategy.class) == null) {
            reloader = new DefaultContextReloadStrategy();
            camelContext.addService((Object)reloader);
        }
        if (camelContext.getManagementStrategy().getManagementAgent() != null) {
            camelContext.getManagementStrategy().getManagementAgent().setEndpointRuntimeStatisticsEnabled(Boolean.valueOf(config.isEndpointRuntimeStatisticsEnabled()));
            camelContext.getManagementStrategy().getManagementAgent().setLoadStatisticsEnabled(Boolean.valueOf(config.isLoadStatisticsEnabled()));
            camelContext.getManagementStrategy().getManagementAgent().setStatisticsLevel(config.getJmxManagementStatisticsLevel());
            camelContext.getManagementStrategy().getManagementAgent().setMBeansLevel(config.getJmxManagementMBeansLevel());
            camelContext.getManagementStrategy().getManagementAgent().setManagementNamePattern(config.getJmxManagementNamePattern());
            camelContext.getManagementStrategy().getManagementAgent().setUpdateRouteEnabled(Boolean.valueOf(config.isJmxUpdateRouteEnabled()));
            camelContext.getManagementStrategy().getManagementAgent().setRegisterRoutesCreateByKamelet(Boolean.valueOf(config.isJmxManagementRegisterRoutesCreateByKamelet()));
            camelContext.getManagementStrategy().getManagementAgent().setRegisterRoutesCreateByTemplate(Boolean.valueOf(config.isJmxManagementRegisterRoutesCreateByTemplate()));
        }
        if (config.isCamelEventsTimestampEnabled()) {
            camelContext.getManagementStrategy().getEventFactory().setTimestampEnabled(true);
        }
        if (config.getGlobalOptions() != null) {
            HashMap<String, String> map = camelContext.getGlobalOptions();
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.putAll(config.getGlobalOptions());
            camelContext.setGlobalOptions(map);
        }
        camelContext.getGlobalEndpointConfiguration().setAutowiredEnabled(config.isAutowiredEnabled());
        camelContext.getGlobalEndpointConfiguration().setBridgeErrorHandler(config.isEndpointBridgeErrorHandler());
        camelContext.getGlobalEndpointConfiguration().setLazyStartProducer(config.isEndpointLazyStartProducer());
        if (config.isMessageHistory()) {
            camelContext.setMessageHistory(Boolean.valueOf(true));
        }
        if (config.isSourceLocationEnabled()) {
            camelContext.setSourceLocationEnabled(Boolean.valueOf(true));
        }
        camelContext.setTracing(Boolean.valueOf(config.isTracing()));
        camelContext.setTracingStandby(config.isTracingStandby());
        camelContext.setTracingPattern(config.getTracingPattern());
        camelContext.setTracingLoggingFormat(config.getTracingLoggingFormat());
        camelContext.setTracingTemplates(config.isTracingTemplates());
        if (config.getThreadNamePattern() != null) {
            camelContext.getExecutorServiceManager().setThreadNamePattern(config.getThreadNamePattern());
        }
        if (config.getCompileWorkDir() != null) {
            CompileStrategy cs = (CompileStrategy)ecc.getContextPlugin(CompileStrategy.class);
            if (cs == null) {
                cs = new DefaultCompileStrategy();
                ecc.addContextPlugin(CompileStrategy.class, (Object)cs);
            }
            cs.setWorkDir(config.getCompileWorkDir());
        }
        if (config.getGroovyScriptPattern() != null && (gsc = (GroovyScriptCompiler)camelContext.getCamelContextExtension().getContextPlugin(GroovyScriptCompiler.class)) != null) {
            gsc.setScriptPattern(config.getGroovyScriptPattern());
            gsc.setPreloadCompiled(config.isGroovyPreloadCompiled());
            camelContext.addService((Object)gsc);
            ServiceHelper.startService((Object)gsc);
        }
        if (config.getRouteFilterIncludePattern() != null || config.getRouteFilterExcludePattern() != null) {
            ((Model)camelContext.getCamelContextExtension().getContextPlugin(Model.class)).setRouteFilterPattern(config.getRouteFilterIncludePattern(), config.getRouteFilterExcludePattern());
        }
        StartupConditionStrategy scs = (StartupConditionStrategy)ecc.getContextPlugin(StartupConditionStrategy.class);
        scs.checkStartupConditions();
    }

    /*
     * WARNING - void declaration
     */
    public static void afterConfigure(CamelContext camelContext) throws Exception {
        IBMSecretsManagerVaultConfiguration ibmSecretsManager;
        KubernetesConfigMapVaultConfiguration kubernetesConfigmaps;
        KubernetesVaultConfiguration kubernetes;
        HashicorpVaultConfiguration hashicorp;
        AzureVaultConfiguration azure;
        GcpVaultConfiguration gcp;
        DevConsoleRegistry devConsoleRegistry;
        Set repositories;
        void var44_48;
        HealthCheckRegistry healthCheckRegistry;
        GlobalSSLContextParametersSupplier sslContextParametersSupplier;
        Map serviceRegistries;
        Set rpfs;
        Set csss;
        Set ess;
        Set ens;
        Set tcs;
        ExchangeFactory exf;
        ShutdownStrategy ss;
        ReactiveExecutor re;
        MessageHistoryFactory mhf;
        NodeIdFactory nif;
        Debugger debugger;
        ProcessorFactory pf;
        ThreadPoolFactory tpf;
        ExecutorServiceManager esm;
        UuidGenerator ug;
        RouteController rc;
        FactoryFinderResolver ffr;
        ClassResolver cr;
        ModelJAXBContextFactory mjcf;
        EndpointServiceRegistry esr;
        RuntimeEndpointRegistry rer;
        UnitOfWorkFactory uowf;
        EventFactory ef;
        ManagementObjectNameStrategy mons;
        ManagementStrategy ms;
        AsyncProcessorAwaitManager apam;
        InflightRepository ir;
        BacklogDebugger bd;
        BacklogTracer bt;
        PropertiesComponent pc;
        VariableRepositoryFactory vrf;
        CliConnectorFactory ccf;
        Registry registry = camelContext.getRegistry();
        ManagementStrategy managementStrategy = camelContext.getManagementStrategy();
        StartupStepRecorder ssr = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, StartupStepRecorder.class);
        if (ssr != null) {
            camelContext.getCamelContextExtension().setStartupStepRecorder(ssr);
        }
        if ((ccf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, CliConnectorFactory.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(CliConnectorFactory.class, (Object)ccf);
        }
        if ((vrf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, VariableRepositoryFactory.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(VariableRepositoryFactory.class, (Object)vrf);
        }
        if ((pc = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, PropertiesComponent.class)) != null) {
            camelContext.setPropertiesComponent(pc);
        }
        if ((bt = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, BacklogTracer.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(BacklogTracer.class, (Object)bt);
        }
        if ((bd = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, BacklogDebugger.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(BacklogDebugger.class, (Object)bd);
        }
        if ((ir = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, InflightRepository.class)) != null) {
            camelContext.setInflightRepository(ir);
        }
        if ((apam = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, AsyncProcessorAwaitManager.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(AsyncProcessorAwaitManager.class, (Object)apam);
        }
        if ((ms = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ManagementStrategy.class)) != null) {
            camelContext.setManagementStrategy(ms);
        }
        if ((mons = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ManagementObjectNameStrategy.class)) != null) {
            managementStrategy.setManagementObjectNameStrategy(mons);
        }
        if ((ef = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, EventFactory.class)) != null) {
            managementStrategy.setEventFactory(ef);
        }
        if ((uowf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, UnitOfWorkFactory.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(UnitOfWorkFactory.class, (Object)uowf);
        }
        if ((rer = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, RuntimeEndpointRegistry.class)) != null) {
            camelContext.setRuntimeEndpointRegistry(rer);
        }
        if ((esr = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, EndpointServiceRegistry.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(EndpointServiceRegistry.class, (Object)esr);
        }
        if ((mjcf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ModelJAXBContextFactory.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(ModelJAXBContextFactory.class, (Object)mjcf);
        }
        if ((cr = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ClassResolver.class)) != null) {
            camelContext.setClassResolver(cr);
        }
        if ((ffr = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, FactoryFinderResolver.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(FactoryFinderResolver.class, (Object)ffr);
        }
        if ((rc = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, RouteController.class)) != null) {
            camelContext.setRouteController(rc);
        }
        if ((ug = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, UuidGenerator.class)) != null) {
            camelContext.setUuidGenerator(ug);
        }
        if ((esm = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ExecutorServiceManager.class)) != null) {
            camelContext.setExecutorServiceManager(esm);
        }
        if ((tpf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ThreadPoolFactory.class)) != null) {
            camelContext.getExecutorServiceManager().setThreadPoolFactory(tpf);
        }
        if ((pf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ProcessorFactory.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(ProcessorFactory.class, (Object)pf);
        }
        if ((debugger = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, Debugger.class)) != null) {
            camelContext.setDebugger(debugger);
        }
        if ((nif = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, NodeIdFactory.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(NodeIdFactory.class, (Object)nif);
        }
        if ((mhf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, MessageHistoryFactory.class)) != null) {
            camelContext.setMessageHistoryFactory(mhf);
        }
        if ((re = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ReactiveExecutor.class)) != null) {
            camelContext.getCamelContextExtension().setReactiveExecutor(re);
        }
        if ((ss = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ShutdownStrategy.class)) != null) {
            camelContext.setShutdownStrategy(ss);
        }
        if ((exf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ExchangeFactory.class)) != null) {
            camelContext.getCamelContextExtension().setExchangeFactory(exf);
        }
        if (!(tcs = registry.findByType(TypeConverters.class)).isEmpty()) {
            tcs.forEach(t -> camelContext.getTypeConverterRegistry().addTypeConverters(t));
        }
        if (!(ens = registry.findByType(EventNotifier.class)).isEmpty()) {
            ens.forEach(n -> camelContext.getManagementStrategy().addEventNotifier(n));
        }
        if (!(ess = registry.findByType(EndpointStrategy.class)).isEmpty()) {
            ess.forEach(arg_0 -> ((ExtendedCamelContext)camelContext.getCamelContextExtension()).registerEndpointCallback(arg_0));
        }
        if (!(csss = registry.findByType(CamelClusterService.class)).isEmpty()) {
            for (CamelClusterService css : csss) {
                camelContext.addService((Object)css);
            }
        }
        if (!(rpfs = registry.findByType(RoutePolicyFactory.class)).isEmpty()) {
            rpfs.forEach(arg_0 -> ((CamelContext)camelContext).addRoutePolicyFactory(arg_0));
        }
        Predicate<EventNotifier> containsEventNotifier = managementStrategy.getEventNotifiers()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, EventNotifier.class, containsEventNotifier.negate(), arg_0 -> ((ManagementStrategy)managementStrategy).addEventNotifier(arg_0));
        Predicate<InterceptStrategy> containsInterceptStrategy = camelContext.getCamelContextExtension().getInterceptStrategies()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, InterceptStrategy.class, containsInterceptStrategy.negate(), arg_0 -> ((ExtendedCamelContext)camelContext.getCamelContextExtension()).addInterceptStrategy(arg_0));
        Predicate<LifecycleStrategy> containsLifecycleStrategy = camelContext.getLifecycleStrategies()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, LifecycleStrategy.class, containsLifecycleStrategy.negate(), arg_0 -> ((CamelContext)camelContext).addLifecycleStrategy(arg_0));
        ModelCamelContext mcc = (ModelCamelContext)camelContext;
        Predicate<ModelLifecycleStrategy> containsModelLifecycleStrategy = mcc.getModelLifecycleStrategies()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, ModelLifecycleStrategy.class, containsModelLifecycleStrategy.negate(), arg_0 -> ((ModelCamelContext)mcc).addModelLifecycleStrategy(arg_0));
        Map logListeners = registry.findByTypeWithName(LogListener.class);
        if (logListeners != null && !logListeners.isEmpty()) {
            for (LogListener logListener : logListeners.values()) {
                boolean bl = camelContext.getCamelContextExtension().getLogListeners() != null && camelContext.getCamelContextExtension().getLogListeners().contains(logListener);
                if (bl) continue;
                camelContext.getCamelContextExtension().addLogListener(logListener);
            }
        }
        if ((serviceRegistries = registry.findByTypeWithName(ServiceRegistry.class)) != null && !serviceRegistries.isEmpty()) {
            for (Map.Entry entry : serviceRegistries.entrySet()) {
                ServiceRegistry service = (ServiceRegistry)entry.getValue();
                if (service.getId() == null) {
                    service.setGeneratedId(camelContext.getUuidGenerator().generateUuid());
                }
                LOG.info("Adding Camel Cloud ServiceRegistry with id: {} and implementation: {}", (Object)service.getId(), (Object)service);
                camelContext.addService((Object)service);
            }
        }
        if ((sslContextParametersSupplier = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, GlobalSSLContextParametersSupplier.class)) != null) {
            camelContext.setSSLContextParameters((SSLContextParameters)sslContextParametersSupplier.get());
        }
        if ((healthCheckRegistry = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, HealthCheckRegistry.class)) != null) {
            healthCheckRegistry.setCamelContext(camelContext);
            LOG.debug("Using HealthCheckRegistry: {}", (Object)healthCheckRegistry);
            camelContext.getCamelContextExtension().addContextPlugin(HealthCheckRegistry.class, (Object)healthCheckRegistry);
        } else {
            HealthCheckRegistry healthCheckRegistry2 = HealthCheckRegistry.get((CamelContext)camelContext);
            if (healthCheckRegistry2 != null) {
                healthCheckRegistry2.setCamelContext(camelContext);
            }
        }
        if (var44_48 != null && ObjectHelper.isNotEmpty((Collection)(repositories = registry.findByType(HealthCheckRepository.class)))) {
            for (Object repository : repositories) {
                var44_48.register(repository);
            }
        }
        if ((devConsoleRegistry = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, DevConsoleRegistry.class)) != null) {
            devConsoleRegistry.setCamelContext(camelContext);
            LOG.debug("Using DevConsoleRegistry: {}", (Object)devConsoleRegistry);
            camelContext.getCamelContextExtension().addContextPlugin(DevConsoleRegistry.class, (Object)devConsoleRegistry);
        } else {
            devConsoleRegistry = DevConsoleRegistry.get((CamelContext)camelContext);
            if (devConsoleRegistry != null) {
                devConsoleRegistry.setCamelContext(camelContext);
            }
        }
        if (devConsoleRegistry != null) {
            Set consoles = registry.findByType(DevConsole.class);
            for (DevConsole console : consoles) {
                devConsoleRegistry.register(console);
            }
        }
        DefaultConfigurationConfigurer.initThreadPoolProfiles(registry, camelContext);
        AwsVaultConfiguration aws = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, AwsVaultConfiguration.class);
        if (aws != null) {
            VaultConfiguration vault = camelContext.getVaultConfiguration();
            vault.setAwsVaultConfiguration(aws);
        }
        if ((gcp = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, GcpVaultConfiguration.class)) != null) {
            VaultConfiguration vault = camelContext.getVaultConfiguration();
            vault.setGcpVaultConfiguration(gcp);
        }
        if ((azure = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, AzureVaultConfiguration.class)) != null) {
            VaultConfiguration vault = camelContext.getVaultConfiguration();
            vault.setAzureVaultConfiguration(azure);
        }
        if ((hashicorp = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, HashicorpVaultConfiguration.class)) != null) {
            VaultConfiguration vault = camelContext.getVaultConfiguration();
            vault.setHashicorpVaultConfiguration(hashicorp);
        }
        if ((kubernetes = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, KubernetesVaultConfiguration.class)) != null) {
            VaultConfiguration vault = camelContext.getVaultConfiguration();
            vault.setKubernetesVaultConfiguration(kubernetes);
        }
        if ((kubernetesConfigmaps = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, KubernetesConfigMapVaultConfiguration.class)) != null) {
            VaultConfiguration vault = camelContext.getVaultConfiguration();
            vault.setKubernetesConfigMapVaultConfiguration(kubernetesConfigmaps);
        }
        if ((ibmSecretsManager = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, IBMSecretsManagerVaultConfiguration.class)) != null) {
            VaultConfiguration vault = camelContext.getVaultConfiguration();
            vault.setIBMSecretsManagerVaultConfiguration(ibmSecretsManager);
        }
        DefaultConfigurationConfigurer.configureVaultRefresh(camelContext);
        Set customizers = registry.findByType(CamelContextCustomizer.class);
        if (!customizers.isEmpty()) {
            customizers.stream().sorted(Comparator.comparing(CamelContextCustomizer::getOrder)).forEach(c -> c.configure(camelContext));
        }
    }

    static void configureVaultRefresh(CamelContext camelContext) throws Exception {
        PeriodTaskScheduler scheduler;
        DefaultContextReloadStrategy reloader;
        PeriodTaskScheduler scheduler2;
        DefaultContextReloadStrategy reloader2;
        Runnable r;
        long period;
        Optional task;
        VaultConfiguration vc = camelContext.getVaultConfiguration();
        if (vc == null) {
            return;
        }
        if (vc.aws().isRefreshEnabled() && (task = PluginHelper.getPeriodTaskResolver((CamelContext)camelContext).newInstance("aws-secret-refresh", Runnable.class)).isPresent()) {
            period = vc.aws().getRefreshPeriod();
            r = (Runnable)task.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling: {} (period: {})", (Object)r, (Object)TimeUtils.printDuration((long)period, (boolean)false));
            }
            if (camelContext.hasService(ContextReloadStrategy.class) == null) {
                reloader2 = new DefaultContextReloadStrategy();
                camelContext.addService((Object)reloader2);
            }
            scheduler2 = PluginHelper.getPeriodTaskScheduler((CamelContext)camelContext);
            scheduler2.schedulePeriodTask(r, period);
        }
        if (vc.gcp().isRefreshEnabled() && (task = PluginHelper.getPeriodTaskResolver((CamelContext)camelContext).newInstance("gcp-secret-refresh", Runnable.class)).isPresent()) {
            period = vc.gcp().getRefreshPeriod();
            r = (Runnable)task.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling: {} (period: {})", (Object)r, (Object)TimeUtils.printDuration((long)period, (boolean)false));
            }
            if (camelContext.hasService(ContextReloadStrategy.class) == null) {
                reloader2 = new DefaultContextReloadStrategy();
                camelContext.addService((Object)reloader2);
            }
            scheduler2 = PluginHelper.getPeriodTaskScheduler((CamelContext)camelContext);
            scheduler2.schedulePeriodTask(r, period);
        }
        if (vc.azure().isRefreshEnabled() && (task = PluginHelper.getPeriodTaskResolver((CamelContext)camelContext).newInstance("azure-secret-refresh", Runnable.class)).isPresent()) {
            period = vc.azure().getRefreshPeriod();
            r = (Runnable)task.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling: {} (period: {})", (Object)r, (Object)TimeUtils.printDuration((long)period, (boolean)false));
            }
            if (camelContext.hasService(ContextReloadStrategy.class) == null) {
                reloader2 = new DefaultContextReloadStrategy();
                camelContext.addService((Object)reloader2);
            }
            scheduler2 = PluginHelper.getPeriodTaskScheduler((CamelContext)camelContext);
            scheduler2.schedulePeriodTask(r, period);
        }
        if (vc.kubernetes().isRefreshEnabled() && (task = PluginHelper.getPeriodTaskResolver((CamelContext)camelContext).newInstance("kubernetes-secret-refresh", Runnable.class)).isPresent()) {
            Runnable r2 = (Runnable)task.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling: {} ", (Object)r2);
            }
            if (camelContext.hasService(ContextReloadStrategy.class) == null) {
                reloader = new DefaultContextReloadStrategy();
                camelContext.addService((Object)reloader);
            }
            scheduler = PluginHelper.getPeriodTaskScheduler((CamelContext)camelContext);
            scheduler.scheduledTask(r2);
        }
        if (vc.kubernetesConfigmaps().isRefreshEnabled() && (task = PluginHelper.getPeriodTaskResolver((CamelContext)camelContext).newInstance("kubernetes-configmaps-refresh", Runnable.class)).isPresent()) {
            Runnable r3 = (Runnable)task.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling: {} ", (Object)r3);
            }
            if (camelContext.hasService(ContextReloadStrategy.class) == null) {
                reloader = new DefaultContextReloadStrategy();
                camelContext.addService((Object)reloader);
            }
            scheduler = PluginHelper.getPeriodTaskScheduler((CamelContext)camelContext);
            scheduler.scheduledTask(r3);
        }
        if (vc.ibmSecretsManager().isRefreshEnabled() && (task = PluginHelper.getPeriodTaskResolver((CamelContext)camelContext).newInstance("ibm-secret-refresh", Runnable.class)).isPresent()) {
            Runnable r4 = (Runnable)task.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling: {} ", (Object)r4);
            }
            if (camelContext.hasService(ContextReloadStrategy.class) == null) {
                reloader = new DefaultContextReloadStrategy();
                camelContext.addService((Object)reloader);
            }
            scheduler = PluginHelper.getPeriodTaskScheduler((CamelContext)camelContext);
            scheduler.scheduledTask(r4);
        }
        if (vc.springConfig().isRefreshEnabled() && (task = PluginHelper.getPeriodTaskResolver((CamelContext)camelContext).newInstance("spring-config-refresh", Runnable.class)).isPresent()) {
            long period2 = vc.springConfig().getRefreshPeriod();
            r = (Runnable)task.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling: {} (period: {})", (Object)r, (Object)TimeUtils.printDuration((long)period2, (boolean)false));
            }
            if (camelContext.hasService(ContextReloadStrategy.class) == null) {
                reloader2 = new DefaultContextReloadStrategy();
                camelContext.addService((Object)reloader2);
            }
            scheduler2 = PluginHelper.getPeriodTaskScheduler((CamelContext)camelContext);
            scheduler2.schedulePeriodTask(r, period2);
        }
    }

    public static void afterPropertiesSet(CamelContext camelContext) throws Exception {
    }

    private static <T> T getSingleBeanOfType(Registry registry, Class<T> type) {
        Map beans = registry.findByTypeWithName(type);
        if (beans.size() == 1) {
            return (T)beans.values().iterator().next();
        }
        return null;
    }

    private static <T> void registerPropertiesForBeanTypesWithCondition(Registry registry, Class<T> beanType, Predicate<T> condition, Consumer<T> propertySetter) {
        Map beans = registry.findByTypeWithName(beanType);
        if (!ObjectHelper.isNotEmpty((Map)beans)) {
            return;
        }
        String simpleName = beanType.getSimpleName();
        beans.forEach((name, bean) -> {
            if (condition.test(bean)) {
                LOG.info("Adding custom {} with id: {} and implementation: {}", new Object[]{simpleName, name, bean});
                propertySetter.accept(bean);
            }
        });
    }

    private static void initThreadPoolProfiles(Registry registry, CamelContext camelContext) {
        HashSet<String> defaultIds = new HashSet<String>();
        Map profiles = registry.findByTypeWithName(ThreadPoolProfile.class);
        if (profiles != null && !profiles.isEmpty()) {
            for (Map.Entry entry : profiles.entrySet()) {
                ThreadPoolProfile profile = (ThreadPoolProfile)entry.getValue();
                if (profile.isDefaultProfile().booleanValue()) {
                    LOG.info("Using custom default ThreadPoolProfile with id: {} and implementation: {}", entry.getKey(), (Object)profile);
                    camelContext.getExecutorServiceManager().setDefaultThreadPoolProfile(profile);
                    defaultIds.add((String)entry.getKey());
                    continue;
                }
                camelContext.getExecutorServiceManager().registerThreadPoolProfile(profile);
            }
        }
        if (defaultIds.size() > 1) {
            throw new IllegalArgumentException("Only exactly one default ThreadPoolProfile is allowed, was " + defaultIds.size() + " ids: " + defaultIds);
        }
    }
}

