/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.LoggingLevel;
import org.apache.camel.ManagementMBeansLevel;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.StartupSummaryLevel;
import org.apache.camel.spi.Metadata;

public abstract class DefaultConfigurationProperties<T> {
    private String name;
    private String description;
    @Metadata(defaultValue="Default", enums="Verbose,Default,Brief,Oneline,Off")
    private StartupSummaryLevel startupSummaryLevel;
    private int durationMaxSeconds;
    private int durationMaxIdleSeconds;
    private int durationMaxMessages;
    @Metadata(defaultValue="shutdown", enums="shutdown,stop")
    private String durationMaxAction = "shutdown";
    private int shutdownTimeout = 45;
    private boolean shutdownSuppressLoggingOnTimeout;
    private boolean shutdownNowOnTimeout = true;
    private boolean shutdownRoutesInReverseOrder = true;
    private boolean shutdownLogInflightExchangesOnTimeout = true;
    private boolean inflightRepositoryBrowseEnabled;
    private String fileConfigurations;
    private boolean jmxEnabled = true;
    @Metadata(enums="classic,default,short,simple,off", defaultValue="default")
    private String uuidGenerator = "default";
    private int producerTemplateCacheSize = 1000;
    private int consumerTemplateCacheSize = 1000;
    private boolean loadTypeConverters;
    private boolean loadHealthChecks;
    private boolean devConsoleEnabled;
    private boolean modeline;
    private int logDebugMaxChars;
    private boolean streamCachingEnabled = true;
    private String streamCachingAllowClasses;
    private String streamCachingDenyClasses;
    private boolean streamCachingSpoolEnabled;
    private String streamCachingSpoolDirectory;
    private String streamCachingSpoolCipher;
    private long streamCachingSpoolThreshold;
    private int streamCachingSpoolUsedHeapMemoryThreshold;
    private String streamCachingSpoolUsedHeapMemoryLimit;
    private boolean streamCachingAnySpoolRules;
    private int streamCachingBufferSize;
    private boolean streamCachingRemoveSpoolDirectoryWhenStopping = true;
    private boolean streamCachingStatisticsEnabled;
    private boolean typeConverterStatisticsEnabled;
    private boolean tracing;
    private boolean tracingStandby;
    private boolean tracingTemplates;
    private String tracingPattern;
    @Metadata(defaultValue="%-4.4s [%-12.12s] [%-33.33s]")
    private String tracingLoggingFormat;
    private boolean sourceLocationEnabled;
    private boolean messageHistory;
    private boolean logMask;
    private boolean logExhaustedMessageBody;
    private String logName;
    private String logLanguage;
    private boolean autoStartup = true;
    private String autoStartupExcludePattern;
    private boolean allowUseOriginalMessage;
    private boolean caseInsensitiveHeaders = true;
    private boolean autowiredEnabled = true;
    private boolean endpointRuntimeStatisticsEnabled;
    private boolean loadStatisticsEnabled;
    private boolean endpointLazyStartProducer;
    private boolean endpointBridgeErrorHandler;
    private boolean useDataType;
    private boolean useBreadcrumb;
    private boolean beanPostProcessorEnabled = true;
    @Metadata(defaultValue="Default", enums="ContextOnly,RoutesOnly,Default")
    private ManagementMBeansLevel jmxManagementMBeansLevel = ManagementMBeansLevel.Default;
    @Metadata(defaultValue="Default", enums="Extended,Default,RoutesOnly,Off")
    private ManagementStatisticsLevel jmxManagementStatisticsLevel = ManagementStatisticsLevel.Default;
    private String jmxManagementNamePattern = "#name#";
    private boolean jmxUpdateRouteEnabled;
    private boolean jmxManagementRegisterRoutesCreateByKamelet;
    private boolean jmxManagementRegisterRoutesCreateByTemplate = true;
    private boolean camelEventsTimestampEnabled;
    private boolean useMdcLogging;
    private String mdcLoggingKeysPattern;
    private String threadNamePattern;
    private String routeFilterIncludePattern;
    private String routeFilterExcludePattern;
    private boolean beanIntrospectionExtendedStatistics;
    private LoggingLevel beanIntrospectionLoggingLevel;
    private boolean contextReloadEnabled;
    private boolean routesCollectorEnabled = true;
    private boolean routesCollectorIgnoreLoadingError;
    @Metadata(label="advanced")
    private String compileWorkDir;
    private String javaRoutesIncludePattern;
    private String javaRoutesExcludePattern;
    private String routesIncludePattern = "classpath:camel/*,classpath:camel-template/*,classpath:camel-rest/*";
    private String routesExcludePattern;
    private boolean routesReloadEnabled;
    @Metadata(defaultValue="src/main/resources/camel")
    private String routesReloadDirectory = "src/main/resources/camel";
    private boolean routesReloadDirectoryRecursive;
    private String routesReloadPattern;
    @Metadata(defaultValue="true")
    private boolean routesReloadRemoveAllRoutes = true;
    private boolean routesReloadRestartDuration;
    @Metadata(defaultValue="default", enums="default,prototype,pooled")
    private String exchangeFactory = "default";
    private int exchangeFactoryCapacity = 100;
    private boolean exchangeFactoryStatisticsEnabled;
    @Metadata(enums="xml,yaml")
    private String dumpRoutes;
    private String dumpRoutesInclude = "routes";
    private boolean dumpRoutesLog = true;
    private boolean dumpRoutesResolvePlaceholders = true;
    private boolean dumpRoutesUriAsParameters;
    private boolean dumpRoutesGeneratedIds;
    private String dumpRoutesOutput;
    private Map<String, String> globalOptions;
    @Metadata(enums="false,off,java-flight-recorder,jfr,logging,backlog")
    private String startupRecorder;
    private int startupRecorderMaxDepth = -1;
    private boolean startupRecorderRecording;
    private String startupRecorderProfile = "default";
    private long startupRecorderDuration;
    private String startupRecorderDir;
    private String cloudPropertiesLocation;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public StartupSummaryLevel getStartupSummaryLevel() {
        return this.startupSummaryLevel;
    }

    public void setStartupSummaryLevel(StartupSummaryLevel startupSummaryLevel) {
        this.startupSummaryLevel = startupSummaryLevel;
    }

    public int getDurationMaxSeconds() {
        return this.durationMaxSeconds;
    }

    public void setDurationMaxSeconds(int durationMaxSeconds) {
        this.durationMaxSeconds = durationMaxSeconds;
    }

    public int getDurationMaxIdleSeconds() {
        return this.durationMaxIdleSeconds;
    }

    public void setDurationMaxIdleSeconds(int durationMaxIdleSeconds) {
        this.durationMaxIdleSeconds = durationMaxIdleSeconds;
    }

    public int getDurationMaxMessages() {
        return this.durationMaxMessages;
    }

    public void setDurationMaxMessages(int durationMaxMessages) {
        this.durationMaxMessages = durationMaxMessages;
    }

    public String getDurationMaxAction() {
        return this.durationMaxAction;
    }

    public void setDurationMaxAction(String durationMaxAction) {
        this.durationMaxAction = durationMaxAction;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public boolean isShutdownSuppressLoggingOnTimeout() {
        return this.shutdownSuppressLoggingOnTimeout;
    }

    public void setShutdownSuppressLoggingOnTimeout(boolean shutdownSuppressLoggingOnTimeout) {
        this.shutdownSuppressLoggingOnTimeout = shutdownSuppressLoggingOnTimeout;
    }

    public boolean isShutdownNowOnTimeout() {
        return this.shutdownNowOnTimeout;
    }

    public void setShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
        this.shutdownNowOnTimeout = shutdownNowOnTimeout;
    }

    public boolean isShutdownRoutesInReverseOrder() {
        return this.shutdownRoutesInReverseOrder;
    }

    public void setShutdownRoutesInReverseOrder(boolean shutdownRoutesInReverseOrder) {
        this.shutdownRoutesInReverseOrder = shutdownRoutesInReverseOrder;
    }

    public boolean isShutdownLogInflightExchangesOnTimeout() {
        return this.shutdownLogInflightExchangesOnTimeout;
    }

    public void setShutdownLogInflightExchangesOnTimeout(boolean shutdownLogInflightExchangesOnTimeout) {
        this.shutdownLogInflightExchangesOnTimeout = shutdownLogInflightExchangesOnTimeout;
    }

    public boolean isInflightRepositoryBrowseEnabled() {
        return this.inflightRepositoryBrowseEnabled;
    }

    public void setInflightRepositoryBrowseEnabled(boolean inflightRepositoryBrowseEnabled) {
        this.inflightRepositoryBrowseEnabled = inflightRepositoryBrowseEnabled;
    }

    public String getFileConfigurations() {
        return this.fileConfigurations;
    }

    public void setFileConfigurations(String fileConfigurations) {
        this.fileConfigurations = fileConfigurations;
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
    }

    public String getUuidGenerator() {
        return this.uuidGenerator;
    }

    public void setUuidGenerator(String uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }

    public int getProducerTemplateCacheSize() {
        return this.producerTemplateCacheSize;
    }

    public void setProducerTemplateCacheSize(int producerTemplateCacheSize) {
        this.producerTemplateCacheSize = producerTemplateCacheSize;
    }

    public int getConsumerTemplateCacheSize() {
        return this.consumerTemplateCacheSize;
    }

    public void setConsumerTemplateCacheSize(int consumerTemplateCacheSize) {
        this.consumerTemplateCacheSize = consumerTemplateCacheSize;
    }

    public boolean isLoadTypeConverters() {
        return this.loadTypeConverters;
    }

    public void setLoadTypeConverters(boolean loadTypeConverters) {
        this.loadTypeConverters = loadTypeConverters;
    }

    public boolean isLoadHealthChecks() {
        return this.loadHealthChecks;
    }

    public void setLoadHealthChecks(boolean loadHealthChecks) {
        this.loadHealthChecks = loadHealthChecks;
    }

    public boolean isDevConsoleEnabled() {
        return this.devConsoleEnabled;
    }

    public void setDevConsoleEnabled(boolean devConsoleEnabled) {
        this.devConsoleEnabled = devConsoleEnabled;
    }

    public boolean isModeline() {
        return this.modeline;
    }

    public void setModeline(boolean modeline) {
        this.modeline = modeline;
    }

    public int getLogDebugMaxChars() {
        return this.logDebugMaxChars;
    }

    public void setLogDebugMaxChars(int logDebugMaxChars) {
        this.logDebugMaxChars = logDebugMaxChars;
    }

    public boolean isStreamCachingEnabled() {
        return this.streamCachingEnabled;
    }

    public void setStreamCachingEnabled(boolean streamCachingEnabled) {
        this.streamCachingEnabled = streamCachingEnabled;
    }

    public String getStreamCachingAllowClasses() {
        return this.streamCachingAllowClasses;
    }

    public void setStreamCachingAllowClasses(String streamCachingAllowClasses) {
        this.streamCachingAllowClasses = streamCachingAllowClasses;
    }

    public String getStreamCachingDenyClasses() {
        return this.streamCachingDenyClasses;
    }

    public void setStreamCachingDenyClasses(String streamCachingDenyClasses) {
        this.streamCachingDenyClasses = streamCachingDenyClasses;
    }

    public boolean isStreamCachingSpoolEnabled() {
        return this.streamCachingSpoolEnabled;
    }

    public void setStreamCachingSpoolEnabled(boolean streamCachingSpoolEnabled) {
        this.streamCachingSpoolEnabled = streamCachingSpoolEnabled;
    }

    public String getStreamCachingSpoolDirectory() {
        return this.streamCachingSpoolDirectory;
    }

    public void setStreamCachingSpoolDirectory(String streamCachingSpoolDirectory) {
        this.streamCachingSpoolDirectory = streamCachingSpoolDirectory;
    }

    public String getStreamCachingSpoolCipher() {
        return this.streamCachingSpoolCipher;
    }

    public void setStreamCachingSpoolCipher(String streamCachingSpoolCipher) {
        this.streamCachingSpoolCipher = streamCachingSpoolCipher;
    }

    public long getStreamCachingSpoolThreshold() {
        return this.streamCachingSpoolThreshold;
    }

    public void setStreamCachingSpoolThreshold(long streamCachingSpoolThreshold) {
        this.streamCachingSpoolThreshold = streamCachingSpoolThreshold;
    }

    public int getStreamCachingSpoolUsedHeapMemoryThreshold() {
        return this.streamCachingSpoolUsedHeapMemoryThreshold;
    }

    public void setStreamCachingSpoolUsedHeapMemoryThreshold(int streamCachingSpoolUsedHeapMemoryThreshold) {
        this.streamCachingSpoolUsedHeapMemoryThreshold = streamCachingSpoolUsedHeapMemoryThreshold;
    }

    public String getStreamCachingSpoolUsedHeapMemoryLimit() {
        return this.streamCachingSpoolUsedHeapMemoryLimit;
    }

    public void setStreamCachingSpoolUsedHeapMemoryLimit(String streamCachingSpoolUsedHeapMemoryLimit) {
        this.streamCachingSpoolUsedHeapMemoryLimit = streamCachingSpoolUsedHeapMemoryLimit;
    }

    public boolean isStreamCachingAnySpoolRules() {
        return this.streamCachingAnySpoolRules;
    }

    public void setStreamCachingAnySpoolRules(boolean streamCachingAnySpoolRules) {
        this.streamCachingAnySpoolRules = streamCachingAnySpoolRules;
    }

    public int getStreamCachingBufferSize() {
        return this.streamCachingBufferSize;
    }

    public void setStreamCachingBufferSize(int streamCachingBufferSize) {
        this.streamCachingBufferSize = streamCachingBufferSize;
    }

    public boolean isStreamCachingRemoveSpoolDirectoryWhenStopping() {
        return this.streamCachingRemoveSpoolDirectoryWhenStopping;
    }

    public void setStreamCachingRemoveSpoolDirectoryWhenStopping(boolean streamCachingRemoveSpoolDirectoryWhenStopping) {
        this.streamCachingRemoveSpoolDirectoryWhenStopping = streamCachingRemoveSpoolDirectoryWhenStopping;
    }

    public boolean isStreamCachingStatisticsEnabled() {
        return this.streamCachingStatisticsEnabled;
    }

    public void setStreamCachingStatisticsEnabled(boolean streamCachingStatisticsEnabled) {
        this.streamCachingStatisticsEnabled = streamCachingStatisticsEnabled;
    }

    public boolean isTypeConverterStatisticsEnabled() {
        return this.typeConverterStatisticsEnabled;
    }

    public void setTypeConverterStatisticsEnabled(boolean typeConverterStatisticsEnabled) {
        this.typeConverterStatisticsEnabled = typeConverterStatisticsEnabled;
    }

    public boolean isTracing() {
        return this.tracing;
    }

    public void setTracing(boolean tracing) {
        this.tracing = tracing;
    }

    public boolean isTracingStandby() {
        return this.tracingStandby;
    }

    public void setTracingStandby(boolean tracingStandby) {
        this.tracingStandby = tracingStandby;
    }

    public boolean isTracingTemplates() {
        return this.tracingTemplates;
    }

    public void setTracingTemplates(boolean tracingTemplates) {
        this.tracingTemplates = tracingTemplates;
    }

    public String getTracingPattern() {
        return this.tracingPattern;
    }

    public void setTracingPattern(String tracingPattern) {
        this.tracingPattern = tracingPattern;
    }

    public String getTracingLoggingFormat() {
        return this.tracingLoggingFormat;
    }

    public void setTracingLoggingFormat(String format) {
        this.tracingLoggingFormat = format;
    }

    public boolean isMessageHistory() {
        return this.messageHistory;
    }

    public void setMessageHistory(boolean messageHistory) {
        this.messageHistory = messageHistory;
    }

    public boolean isSourceLocationEnabled() {
        return this.sourceLocationEnabled;
    }

    public void setSourceLocationEnabled(boolean sourceLocationEnabled) {
        this.sourceLocationEnabled = sourceLocationEnabled;
    }

    public boolean isLogMask() {
        return this.logMask;
    }

    public void setLogMask(boolean logMask) {
        this.logMask = logMask;
    }

    public boolean isLogExhaustedMessageBody() {
        return this.logExhaustedMessageBody;
    }

    public void setLogExhaustedMessageBody(boolean logExhaustedMessageBody) {
        this.logExhaustedMessageBody = logExhaustedMessageBody;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public String getLogLanguage() {
        return this.logLanguage;
    }

    public void setLogLanguage(String logLanguage) {
        this.logLanguage = logLanguage;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public String getAutoStartupExcludePattern() {
        return this.autoStartupExcludePattern;
    }

    public void setAutoStartupExcludePattern(String autoStartupExcludePattern) {
        this.autoStartupExcludePattern = autoStartupExcludePattern;
    }

    public boolean isAllowUseOriginalMessage() {
        return this.allowUseOriginalMessage;
    }

    public void setAllowUseOriginalMessage(boolean allowUseOriginalMessage) {
        this.allowUseOriginalMessage = allowUseOriginalMessage;
    }

    public boolean isCaseInsensitiveHeaders() {
        return this.caseInsensitiveHeaders;
    }

    public void setCaseInsensitiveHeaders(boolean caseInsensitiveHeaders) {
        this.caseInsensitiveHeaders = caseInsensitiveHeaders;
    }

    public boolean isAutowiredEnabled() {
        return this.autowiredEnabled;
    }

    public void setAutowiredEnabled(boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public boolean isEndpointRuntimeStatisticsEnabled() {
        return this.endpointRuntimeStatisticsEnabled;
    }

    public void setEndpointRuntimeStatisticsEnabled(boolean endpointRuntimeStatisticsEnabled) {
        this.endpointRuntimeStatisticsEnabled = endpointRuntimeStatisticsEnabled;
    }

    public boolean isLoadStatisticsEnabled() {
        return this.loadStatisticsEnabled;
    }

    public void setLoadStatisticsEnabled(boolean loadStatisticsEnabled) {
        this.loadStatisticsEnabled = loadStatisticsEnabled;
    }

    public boolean isEndpointLazyStartProducer() {
        return this.endpointLazyStartProducer;
    }

    public void setEndpointLazyStartProducer(boolean endpointLazyStartProducer) {
        this.endpointLazyStartProducer = endpointLazyStartProducer;
    }

    public boolean isEndpointBridgeErrorHandler() {
        return this.endpointBridgeErrorHandler;
    }

    public void setEndpointBridgeErrorHandler(boolean endpointBridgeErrorHandler) {
        this.endpointBridgeErrorHandler = endpointBridgeErrorHandler;
    }

    public boolean isUseDataType() {
        return this.useDataType;
    }

    public void setUseDataType(boolean useDataType) {
        this.useDataType = useDataType;
    }

    public boolean isUseBreadcrumb() {
        return this.useBreadcrumb;
    }

    public void setUseBreadcrumb(boolean useBreadcrumb) {
        this.useBreadcrumb = useBreadcrumb;
    }

    public boolean isBeanPostProcessorEnabled() {
        return this.beanPostProcessorEnabled;
    }

    public void setBeanPostProcessorEnabled(boolean beanPostProcessorEnabled) {
        this.beanPostProcessorEnabled = beanPostProcessorEnabled;
    }

    public ManagementMBeansLevel getJmxManagementMBeansLevel() {
        return this.jmxManagementMBeansLevel;
    }

    public void setJmxManagementMBeansLevel(ManagementMBeansLevel jmxManagementMBeansLevel) {
        this.jmxManagementMBeansLevel = jmxManagementMBeansLevel;
    }

    public ManagementStatisticsLevel getJmxManagementStatisticsLevel() {
        return this.jmxManagementStatisticsLevel;
    }

    public void setJmxManagementStatisticsLevel(ManagementStatisticsLevel jmxManagementStatisticsLevel) {
        this.jmxManagementStatisticsLevel = jmxManagementStatisticsLevel;
    }

    public String getJmxManagementNamePattern() {
        return this.jmxManagementNamePattern;
    }

    public void setJmxManagementNamePattern(String jmxManagementNamePattern) {
        this.jmxManagementNamePattern = jmxManagementNamePattern;
    }

    public boolean isJmxManagementRegisterRoutesCreateByKamelet() {
        return this.jmxManagementRegisterRoutesCreateByKamelet;
    }

    public void setJmxManagementRegisterRoutesCreateByKamelet(boolean jmxManagementRegisterRoutesCreateByKamelet) {
        this.jmxManagementRegisterRoutesCreateByKamelet = jmxManagementRegisterRoutesCreateByKamelet;
    }

    public boolean isJmxManagementRegisterRoutesCreateByTemplate() {
        return this.jmxManagementRegisterRoutesCreateByTemplate;
    }

    public void setJmxManagementRegisterRoutesCreateByTemplate(boolean jmxManagementRegisterRoutesCreateByTemplate) {
        this.jmxManagementRegisterRoutesCreateByTemplate = jmxManagementRegisterRoutesCreateByTemplate;
    }

    public boolean isCamelEventsTimestampEnabled() {
        return this.camelEventsTimestampEnabled;
    }

    public void setCamelEventsTimestampEnabled(boolean camelEventsTimestampEnabled) {
        this.camelEventsTimestampEnabled = camelEventsTimestampEnabled;
    }

    public boolean isUseMdcLogging() {
        return this.useMdcLogging;
    }

    public void setUseMdcLogging(boolean useMdcLogging) {
        this.useMdcLogging = useMdcLogging;
    }

    public String getMdcLoggingKeysPattern() {
        return this.mdcLoggingKeysPattern;
    }

    public void setMdcLoggingKeysPattern(String mdcLoggingKeysPattern) {
        this.mdcLoggingKeysPattern = mdcLoggingKeysPattern;
    }

    public String getThreadNamePattern() {
        return this.threadNamePattern;
    }

    public void setThreadNamePattern(String threadNamePattern) {
        this.threadNamePattern = threadNamePattern;
    }

    public String getRouteFilterIncludePattern() {
        return this.routeFilterIncludePattern;
    }

    public void setRouteFilterIncludePattern(String include) {
        this.routeFilterIncludePattern = include;
    }

    public String getRouteFilterExcludePattern() {
        return this.routeFilterExcludePattern;
    }

    public void setRouteFilterExcludePattern(String exclude) {
        this.routeFilterExcludePattern = exclude;
    }

    public boolean isBeanIntrospectionExtendedStatistics() {
        return this.beanIntrospectionExtendedStatistics;
    }

    public void setBeanIntrospectionExtendedStatistics(boolean beanIntrospectionExtendedStatistics) {
        this.beanIntrospectionExtendedStatistics = beanIntrospectionExtendedStatistics;
    }

    public LoggingLevel getBeanIntrospectionLoggingLevel() {
        return this.beanIntrospectionLoggingLevel;
    }

    public void setBeanIntrospectionLoggingLevel(LoggingLevel beanIntrospectionLoggingLevel) {
        this.beanIntrospectionLoggingLevel = beanIntrospectionLoggingLevel;
    }

    public boolean isRoutesCollectorEnabled() {
        return this.routesCollectorEnabled;
    }

    public void setRoutesCollectorEnabled(boolean routesCollectorEnabled) {
        this.routesCollectorEnabled = routesCollectorEnabled;
    }

    public boolean isRoutesCollectorIgnoreLoadingError() {
        return this.routesCollectorIgnoreLoadingError;
    }

    public void setRoutesCollectorIgnoreLoadingError(boolean routesCollectorIgnoreLoadingError) {
        this.routesCollectorIgnoreLoadingError = routesCollectorIgnoreLoadingError;
    }

    public String getCompileWorkDir() {
        return this.compileWorkDir;
    }

    public void setCompileWorkDir(String compileWorkDir) {
        this.compileWorkDir = compileWorkDir;
    }

    public String getJavaRoutesIncludePattern() {
        return this.javaRoutesIncludePattern;
    }

    public void setJavaRoutesIncludePattern(String javaRoutesIncludePattern) {
        this.javaRoutesIncludePattern = javaRoutesIncludePattern;
    }

    public String getJavaRoutesExcludePattern() {
        return this.javaRoutesExcludePattern;
    }

    public void setJavaRoutesExcludePattern(String javaRoutesExcludePattern) {
        this.javaRoutesExcludePattern = javaRoutesExcludePattern;
    }

    public String getRoutesIncludePattern() {
        return this.routesIncludePattern;
    }

    public void setRoutesIncludePattern(String routesIncludePattern) {
        this.routesIncludePattern = routesIncludePattern;
    }

    public String getRoutesExcludePattern() {
        return this.routesExcludePattern;
    }

    public void setRoutesExcludePattern(String routesExcludePattern) {
        this.routesExcludePattern = routesExcludePattern;
    }

    public boolean isRoutesReloadEnabled() {
        return this.routesReloadEnabled;
    }

    public void setRoutesReloadEnabled(boolean routesReloadEnabled) {
        this.routesReloadEnabled = routesReloadEnabled;
    }

    public boolean isContextReloadEnabled() {
        return this.contextReloadEnabled;
    }

    public void setContextReloadEnabled(boolean contextReloadEnabled) {
        this.contextReloadEnabled = contextReloadEnabled;
    }

    public String getRoutesReloadDirectory() {
        return this.routesReloadDirectory;
    }

    public void setRoutesReloadDirectory(String routesReloadDirectory) {
        this.routesReloadDirectory = routesReloadDirectory;
    }

    public boolean isRoutesReloadDirectoryRecursive() {
        return this.routesReloadDirectoryRecursive;
    }

    public void setRoutesReloadDirectoryRecursive(boolean routesReloadDirectoryRecursive) {
        this.routesReloadDirectoryRecursive = routesReloadDirectoryRecursive;
    }

    public String getRoutesReloadPattern() {
        return this.routesReloadPattern;
    }

    public void setRoutesReloadPattern(String routesReloadPattern) {
        this.routesReloadPattern = routesReloadPattern;
    }

    public boolean isRoutesReloadRemoveAllRoutes() {
        return this.routesReloadRemoveAllRoutes;
    }

    public void setRoutesReloadRemoveAllRoutes(boolean routesReloadRemoveAllRoutes) {
        this.routesReloadRemoveAllRoutes = routesReloadRemoveAllRoutes;
    }

    public boolean isRoutesReloadRestartDuration() {
        return this.routesReloadRestartDuration;
    }

    public void setRoutesReloadRestartDuration(boolean routesReloadRestartDuration) {
        this.routesReloadRestartDuration = routesReloadRestartDuration;
    }

    public boolean isJmxUpdateRouteEnabled() {
        return this.jmxUpdateRouteEnabled;
    }

    public void setJmxUpdateRouteEnabled(boolean jmxUpdateRouteEnabled) {
        this.jmxUpdateRouteEnabled = jmxUpdateRouteEnabled;
    }

    public String getExchangeFactory() {
        return this.exchangeFactory;
    }

    public void setExchangeFactory(String exchangeFactory) {
        this.exchangeFactory = exchangeFactory;
    }

    public int getExchangeFactoryCapacity() {
        return this.exchangeFactoryCapacity;
    }

    public void setExchangeFactoryCapacity(int exchangeFactoryCapacity) {
        this.exchangeFactoryCapacity = exchangeFactoryCapacity;
    }

    public boolean isExchangeFactoryStatisticsEnabled() {
        return this.exchangeFactoryStatisticsEnabled;
    }

    public void setExchangeFactoryStatisticsEnabled(boolean exchangeFactoryStatisticsEnabled) {
        this.exchangeFactoryStatisticsEnabled = exchangeFactoryStatisticsEnabled;
    }

    public String getDumpRoutes() {
        return this.dumpRoutes;
    }

    public void setDumpRoutes(String dumpRoutes) {
        this.dumpRoutes = dumpRoutes;
    }

    public String getDumpRoutesInclude() {
        return this.dumpRoutesInclude;
    }

    public void setDumpRoutesInclude(String dumpRoutesInclude) {
        this.dumpRoutesInclude = dumpRoutesInclude;
    }

    public boolean isDumpRoutesLog() {
        return this.dumpRoutesLog;
    }

    public void setDumpRoutesLog(boolean dumpRoutesLog) {
        this.dumpRoutesLog = dumpRoutesLog;
    }

    public boolean isDumpRoutesResolvePlaceholders() {
        return this.dumpRoutesResolvePlaceholders;
    }

    public void setDumpRoutesResolvePlaceholders(boolean dumpRoutesResolvePlaceholders) {
        this.dumpRoutesResolvePlaceholders = dumpRoutesResolvePlaceholders;
    }

    public boolean isDumpRoutesUriAsParameters() {
        return this.dumpRoutesUriAsParameters;
    }

    public void setDumpRoutesUriAsParameters(boolean dumpRoutesUriAsParameters) {
        this.dumpRoutesUriAsParameters = dumpRoutesUriAsParameters;
    }

    public boolean isDumpRoutesGeneratedIds() {
        return this.dumpRoutesGeneratedIds;
    }

    public void setDumpRoutesGeneratedIds(boolean dumpRoutesGeneratedIds) {
        this.dumpRoutesGeneratedIds = dumpRoutesGeneratedIds;
    }

    public String getDumpRoutesOutput() {
        return this.dumpRoutesOutput;
    }

    public void setDumpRoutesOutput(String dumpRoutesOutput) {
        this.dumpRoutesOutput = dumpRoutesOutput;
    }

    public Map<String, String> getGlobalOptions() {
        return this.globalOptions;
    }

    public void setGlobalOptions(Map<String, String> globalOptions) {
        this.globalOptions = globalOptions;
    }

    public void addGlobalOption(String key, Object value) {
        if (this.globalOptions == null) {
            this.globalOptions = new HashMap<String, String>();
        }
        this.globalOptions.put(key, value.toString());
    }

    public String getStartupRecorder() {
        return this.startupRecorder;
    }

    public void setStartupRecorder(String startupRecorder) {
        this.startupRecorder = startupRecorder;
    }

    public int getStartupRecorderMaxDepth() {
        return this.startupRecorderMaxDepth;
    }

    public void setStartupRecorderMaxDepth(int startupRecorderMaxDepth) {
        this.startupRecorderMaxDepth = startupRecorderMaxDepth;
    }

    public boolean isStartupRecorderRecording() {
        return this.startupRecorderRecording;
    }

    public void setStartupRecorderRecording(boolean startupRecorderRecording) {
        this.startupRecorderRecording = startupRecorderRecording;
    }

    public String getStartupRecorderProfile() {
        return this.startupRecorderProfile;
    }

    public void setStartupRecorderProfile(String startupRecorderProfile) {
        this.startupRecorderProfile = startupRecorderProfile;
    }

    public long getStartupRecorderDuration() {
        return this.startupRecorderDuration;
    }

    public void setStartupRecorderDuration(long startupRecorderDuration) {
        this.startupRecorderDuration = startupRecorderDuration;
    }

    public String getStartupRecorderDir() {
        return this.startupRecorderDir;
    }

    public void setStartupRecorderDir(String startupRecorderDir) {
        this.startupRecorderDir = startupRecorderDir;
    }

    public T withName(String name) {
        this.name = name;
        return (T)this;
    }

    public T withDescription(String description) {
        this.description = description;
        return (T)this;
    }

    public T withDurationMaxSeconds(int durationMaxSeconds) {
        this.durationMaxSeconds = durationMaxSeconds;
        return (T)this;
    }

    public T withDurationMaxIdleSeconds(int durationMaxIdleSeconds) {
        this.durationMaxIdleSeconds = durationMaxIdleSeconds;
        return (T)this;
    }

    public T withDurationMaxMessages(int durationMaxMessages) {
        this.durationMaxMessages = durationMaxMessages;
        return (T)this;
    }

    public T withDurationMaxAction(String durationMaxAction) {
        this.durationMaxAction = durationMaxAction;
        return (T)this;
    }

    public T withShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
        return (T)this;
    }

    public T withShutdownSuppressLoggingOnTimeout(boolean shutdownSuppressLoggingOnTimeout) {
        this.shutdownSuppressLoggingOnTimeout = shutdownSuppressLoggingOnTimeout;
        return (T)this;
    }

    public T withShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
        this.shutdownNowOnTimeout = shutdownNowOnTimeout;
        return (T)this;
    }

    public T withShutdownRoutesInReverseOrder(boolean shutdownRoutesInReverseOrder) {
        this.shutdownRoutesInReverseOrder = shutdownRoutesInReverseOrder;
        return (T)this;
    }

    public T withShutdownLogInflightExchangesOnTimeout(boolean shutdownLogInflightExchangesOnTimeout) {
        this.shutdownLogInflightExchangesOnTimeout = shutdownLogInflightExchangesOnTimeout;
        return (T)this;
    }

    public T withInflightRepositoryBrowseEnabled(boolean inflightRepositoryBrowseEnabled) {
        this.inflightRepositoryBrowseEnabled = inflightRepositoryBrowseEnabled;
        return (T)this;
    }

    public T withFileConfigurations(String fileConfigurations) {
        this.fileConfigurations = fileConfigurations;
        return (T)this;
    }

    public T withJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
        return (T)this;
    }

    public T withProducerTemplateCacheSize(int producerTemplateCacheSize) {
        this.producerTemplateCacheSize = producerTemplateCacheSize;
        return (T)this;
    }

    public T withConsumerTemplateCacheSize(int consumerTemplateCacheSize) {
        this.consumerTemplateCacheSize = consumerTemplateCacheSize;
        return (T)this;
    }

    public T withLoadTypeConverters(boolean loadTypeConverters) {
        this.loadTypeConverters = loadTypeConverters;
        return (T)this;
    }

    public T withLoadHealthChecks(boolean loadHealthChecks) {
        this.loadHealthChecks = loadHealthChecks;
        return (T)this;
    }

    public T withModeline(boolean modeline) {
        this.modeline = modeline;
        return (T)this;
    }

    public T withDevConsoleEnabled(boolean devConsoleEnabled) {
        this.devConsoleEnabled = devConsoleEnabled;
        return (T)this;
    }

    public T withLogDebugMaxChars(int logDebugMaxChars) {
        this.logDebugMaxChars = logDebugMaxChars;
        return (T)this;
    }

    public T withStreamCachingEnabled(boolean streamCachingEnabled) {
        this.streamCachingEnabled = streamCachingEnabled;
        return (T)this;
    }

    public T withStreamCachingAllowClasses(String streamCachingAllowClasses) {
        this.streamCachingAllowClasses = streamCachingAllowClasses;
        return (T)this;
    }

    public T withStreamCachingDenyClasses(String streamCachingDenyClasses) {
        this.streamCachingDenyClasses = streamCachingDenyClasses;
        return (T)this;
    }

    public T withStreamCachingSpoolEnabled(boolean streamCachingSpoolEnabled) {
        this.streamCachingSpoolEnabled = streamCachingSpoolEnabled;
        return (T)this;
    }

    public T withStreamCachingSpoolDirectory(String streamCachingSpoolDirectory) {
        this.streamCachingSpoolDirectory = streamCachingSpoolDirectory;
        return (T)this;
    }

    public T withStreamCachingSpoolCipher(String streamCachingSpoolCipher) {
        this.streamCachingSpoolCipher = streamCachingSpoolCipher;
        return (T)this;
    }

    public T withStreamCachingSpoolThreshold(long streamCachingSpoolThreshold) {
        this.streamCachingSpoolThreshold = streamCachingSpoolThreshold;
        return (T)this;
    }

    public T withStreamCachingSpoolUsedHeapMemoryThreshold(int streamCachingSpoolUsedHeapMemoryThreshold) {
        this.streamCachingSpoolUsedHeapMemoryThreshold = streamCachingSpoolUsedHeapMemoryThreshold;
        return (T)this;
    }

    public T withStreamCachingSpoolUsedHeapMemoryLimit(String streamCachingSpoolUsedHeapMemoryLimit) {
        this.streamCachingSpoolUsedHeapMemoryLimit = streamCachingSpoolUsedHeapMemoryLimit;
        return (T)this;
    }

    public T withStreamCachingAnySpoolRules(boolean streamCachingAnySpoolRules) {
        this.streamCachingAnySpoolRules = streamCachingAnySpoolRules;
        return (T)this;
    }

    public T withStreamCachingBufferSize(int streamCachingBufferSize) {
        this.streamCachingBufferSize = streamCachingBufferSize;
        return (T)this;
    }

    public T withStreamCachingRemoveSpoolDirectoryWhenStopping(boolean streamCachingRemoveSpoolDirectoryWhenStopping) {
        this.streamCachingRemoveSpoolDirectoryWhenStopping = streamCachingRemoveSpoolDirectoryWhenStopping;
        return (T)this;
    }

    public T withStreamCachingStatisticsEnabled(boolean streamCachingStatisticsEnabled) {
        this.streamCachingStatisticsEnabled = streamCachingStatisticsEnabled;
        return (T)this;
    }

    public T withTypeConverterStatisticsEnabled(boolean typeConverterStatisticsEnabled) {
        this.typeConverterStatisticsEnabled = typeConverterStatisticsEnabled;
        return (T)this;
    }

    public T withTracing(boolean tracing) {
        this.tracing = tracing;
        return (T)this;
    }

    public T withTracingStandby(boolean tracingStandby) {
        this.tracingStandby = tracingStandby;
        return (T)this;
    }

    public T withTracingTemplates(boolean tracingTemplates) {
        this.tracingTemplates = tracingTemplates;
        return (T)this;
    }

    public T withMessageHistory(boolean messageHistory) {
        this.messageHistory = messageHistory;
        return (T)this;
    }

    public T withSourceLocationEnabled(boolean sourceLocationEnabled) {
        this.sourceLocationEnabled = sourceLocationEnabled;
        return (T)this;
    }

    public T withLogMask(boolean logMask) {
        this.logMask = logMask;
        return (T)this;
    }

    public T withLogExhaustedMessageBody(boolean logExhaustedMessageBody) {
        this.logExhaustedMessageBody = logExhaustedMessageBody;
        return (T)this;
    }

    public T withLogName(String logName) {
        this.logName = logName;
        return (T)this;
    }

    public T withLogLanguage(String logLanguage) {
        this.logLanguage = logLanguage;
        return (T)this;
    }

    public T withAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
        return (T)this;
    }

    public T withAutoStartupExcludePattern(String autoStartupExcludePattern) {
        this.autoStartupExcludePattern = autoStartupExcludePattern;
        return (T)this;
    }

    public T withAllowUseOriginalMessage(boolean allowUseOriginalMessage) {
        this.allowUseOriginalMessage = allowUseOriginalMessage;
        return (T)this;
    }

    public T withCaseInsensitiveHeaders(boolean caseInsensitiveHeaders) {
        this.caseInsensitiveHeaders = caseInsensitiveHeaders;
        return (T)this;
    }

    public T withEndpointRuntimeStatisticsEnabled(boolean endpointRuntimeStatisticsEnabled) {
        this.endpointRuntimeStatisticsEnabled = endpointRuntimeStatisticsEnabled;
        return (T)this;
    }

    public T withLoadStatisticsEnabled(boolean loadStatisticsEnabled) {
        this.loadStatisticsEnabled = loadStatisticsEnabled;
        return (T)this;
    }

    public T withEndpointLazyStartProducer(boolean endpointLazyStartProducer) {
        this.endpointLazyStartProducer = endpointLazyStartProducer;
        return (T)this;
    }

    public T withEndpointBridgeErrorHandler(boolean endpointBridgeErrorHandler) {
        this.endpointBridgeErrorHandler = endpointBridgeErrorHandler;
        return (T)this;
    }

    public T withUseDataType(boolean useDataType) {
        this.useDataType = useDataType;
        return (T)this;
    }

    public T withUseBreadcrumb(boolean useBreadcrumb) {
        this.useBreadcrumb = useBreadcrumb;
        return (T)this;
    }

    public T withBeanPostProcessorEnabled(boolean beanPostProcessorEnabled) {
        this.beanPostProcessorEnabled = beanPostProcessorEnabled;
        return (T)this;
    }

    public T withJmxManagementMBeansLevel(ManagementMBeansLevel jmxManagementMBeansLevel) {
        this.jmxManagementMBeansLevel = jmxManagementMBeansLevel;
        return (T)this;
    }

    public T withJmxManagementStatisticsLevel(ManagementStatisticsLevel jmxManagementStatisticsLevel) {
        this.jmxManagementStatisticsLevel = jmxManagementStatisticsLevel;
        return (T)this;
    }

    public T withJmxManagementNamePattern(String jmxManagementNamePattern) {
        this.jmxManagementNamePattern = jmxManagementNamePattern;
        return (T)this;
    }

    public T withJmxManagementRegisterRoutesCreateByKamelet(boolean jmxManagementRegisterRoutesCreateByKamelet) {
        this.jmxManagementRegisterRoutesCreateByKamelet = jmxManagementRegisterRoutesCreateByKamelet;
        return (T)this;
    }

    public T withJmxManagementRegisterRoutesCreateByTemplate(boolean jmxManagementRegisterRoutesCreateByTemplate) {
        this.jmxManagementRegisterRoutesCreateByTemplate = jmxManagementRegisterRoutesCreateByTemplate;
        return (T)this;
    }

    public T withCamelEventsTimestampEnabled(boolean camelEventsTimestampEnabled) {
        this.camelEventsTimestampEnabled = camelEventsTimestampEnabled;
        return (T)this;
    }

    public T withUseMdcLogging(boolean useMdcLogging) {
        this.useMdcLogging = useMdcLogging;
        return (T)this;
    }

    public T withThreadNamePattern(String threadNamePattern) {
        this.threadNamePattern = threadNamePattern;
        return (T)this;
    }

    public T withRouteFilterIncludePattern(String routeFilterIncludePattern) {
        this.routeFilterIncludePattern = routeFilterIncludePattern;
        return (T)this;
    }

    public T withRouteFilterExcludePattern(String routeFilterExcludePattern) {
        this.routeFilterExcludePattern = routeFilterExcludePattern;
        return (T)this;
    }

    public T withBeanIntrospectionExtendedStatistics(boolean beanIntrospectionExtendedStatistics) {
        this.beanIntrospectionExtendedStatistics = beanIntrospectionExtendedStatistics;
        return (T)this;
    }

    public T withBeanIntrospectionLoggingLevel(LoggingLevel beanIntrospectionLoggingLevel) {
        this.beanIntrospectionLoggingLevel = beanIntrospectionLoggingLevel;
        return (T)this;
    }

    public T withTracingPattern(String tracingPattern) {
        this.tracingPattern = tracingPattern;
        return (T)this;
    }

    public T withTracingLoggingFormat(String format) {
        this.tracingLoggingFormat = format;
        return (T)this;
    }

    public T withMdcLoggingKeysPattern(String mdcLoggingKeysPattern) {
        this.mdcLoggingKeysPattern = mdcLoggingKeysPattern;
        return (T)this;
    }

    public T withRoutesCollectorEnabled(boolean routesCollectorEnabled) {
        this.routesCollectorEnabled = routesCollectorEnabled;
        return (T)this;
    }

    public T withRoutesCollectorIgnoreLoadingError(boolean routesCollectorIgnoreLoadingError) {
        this.routesCollectorIgnoreLoadingError = routesCollectorIgnoreLoadingError;
        return (T)this;
    }

    public T withCompileWorkDir(String compileWorkDir) {
        this.compileWorkDir = compileWorkDir;
        return (T)this;
    }

    public T withJavaRoutesIncludePattern(String javaRoutesIncludePattern) {
        this.javaRoutesIncludePattern = javaRoutesIncludePattern;
        return (T)this;
    }

    public T withJavaRoutesExcludePattern(String javaRoutesExcludePattern) {
        this.javaRoutesExcludePattern = javaRoutesExcludePattern;
        return (T)this;
    }

    public T withRoutesIncludePattern(String routesIncludePattern) {
        this.routesIncludePattern = routesIncludePattern;
        return (T)this;
    }

    public T withRoutesExcludePattern(String routesExcludePattern) {
        this.routesExcludePattern = routesExcludePattern;
        return (T)this;
    }

    public T withContextReloadEnabled(boolean contextReloadEnabled) {
        this.contextReloadEnabled = contextReloadEnabled;
        return (T)this;
    }

    public T withRoutesReloadEnabled(boolean routesReloadEnabled) {
        this.routesReloadEnabled = routesReloadEnabled;
        return (T)this;
    }

    public T withRoutesReloadDirectory(String routesReloadDirectory) {
        this.routesReloadDirectory = routesReloadDirectory;
        return (T)this;
    }

    public T withRoutesReloadDirectoryRecursive(boolean routesReloadDirectoryRecursive) {
        this.routesReloadDirectoryRecursive = routesReloadDirectoryRecursive;
        return (T)this;
    }

    public T withRoutesReloadPattern(String routesReloadPattern) {
        this.routesReloadPattern = routesReloadPattern;
        return (T)this;
    }

    public T withRoutesReloadRemoveAllRoutes(boolean routesReloadRemoveAllRoutes) {
        this.routesReloadRemoveAllRoutes = routesReloadRemoveAllRoutes;
        return (T)this;
    }

    public T withRoutesReloadRestartDuration(boolean routesReloadRestartDuration) {
        this.routesReloadRestartDuration = routesReloadRestartDuration;
        return (T)this;
    }

    public T withExchangeFactory(String exchangeFactory) {
        this.exchangeFactory = exchangeFactory;
        return (T)this;
    }

    public T withExchangeFactoryCapacity(int exchangeFactoryCapacity) {
        this.exchangeFactoryCapacity = exchangeFactoryCapacity;
        return (T)this;
    }

    public T withExchangeFactoryStatisticsEnabled(boolean exchangeFactoryStatisticsEnabled) {
        this.exchangeFactoryStatisticsEnabled = exchangeFactoryStatisticsEnabled;
        return (T)this;
    }

    public T withDumpRoutes(String dumpRoutes) {
        this.dumpRoutes = dumpRoutes;
        return (T)this;
    }

    public T withDumpRoutesInclude(String dumpRoutesInclude) {
        this.dumpRoutesInclude = dumpRoutesInclude;
        return (T)this;
    }

    public T withDumpRoutesLog(boolean dumpRoutesLog) {
        this.dumpRoutesLog = dumpRoutesLog;
        return (T)this;
    }

    public T withDumpRoutesResolvePlaceholders(boolean dumpRoutesResolvePlaceholders) {
        this.dumpRoutesResolvePlaceholders = dumpRoutesResolvePlaceholders;
        return (T)this;
    }

    public T withDumpRoutesUriAsParameters(boolean dumpRoutesUriAsParameters) {
        this.dumpRoutesUriAsParameters = dumpRoutesUriAsParameters;
        return (T)this;
    }

    public T withDumpRoutesGeneratedIds(boolean dumpRoutesGeneratedIds) {
        this.dumpRoutesGeneratedIds = dumpRoutesGeneratedIds;
        return (T)this;
    }

    public T withDumpRoutesOutput(String dumpRoutesOutput) {
        this.dumpRoutesOutput = dumpRoutesOutput;
        return (T)this;
    }

    public T withGlobalOptions(Map<String, String> globalOptions) {
        if (this.globalOptions == null) {
            this.globalOptions = new HashMap<String, String>();
        }
        this.globalOptions.putAll(globalOptions);
        return (T)this;
    }

    public T withGlobalOption(String key, String value) {
        if (this.globalOptions == null) {
            this.globalOptions = new HashMap<String, String>();
        }
        this.globalOptions.put(key, value);
        return (T)this;
    }

    public T withStartupRecorder(String startupRecorder) {
        this.startupRecorder = startupRecorder;
        return (T)this;
    }

    public T withStartupRecorderMaxDepth(int startupRecorderMaxDepth) {
        this.startupRecorderMaxDepth = startupRecorderMaxDepth;
        return (T)this;
    }

    public T withStartupRecorderRecording(boolean startupRecorderRecording) {
        this.startupRecorderRecording = startupRecorderRecording;
        return (T)this;
    }

    public T withStartupRecorderProfile(String startupRecorderProfile) {
        this.startupRecorderProfile = startupRecorderProfile;
        return (T)this;
    }

    public T withStartupRecorderDuration(long startupRecorderDuration) {
        this.startupRecorderDuration = startupRecorderDuration;
        return (T)this;
    }

    public T withStartupRecorderDir(String startupRecorderDir) {
        this.startupRecorderDir = startupRecorderDir;
        return (T)this;
    }

    public String getCloudPropertiesLocation() {
        return this.cloudPropertiesLocation;
    }

    public void setCloudPropertiesLocation(String cloudPropertiesLocation) {
        this.cloudPropertiesLocation = cloudPropertiesLocation;
    }

    public T withCloudPropertiesLocation(boolean dumpRoutesResolvePlaceholders) {
        this.cloudPropertiesLocation = this.cloudPropertiesLocation;
        return (T)this;
    }
}

