/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.main.PropertyOptionKey;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.LocationHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.OrderedProperties;
import org.apache.camel.util.SensitiveUtils;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MainHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MainHelper.class);
    private final String version;
    private final StopWatch stopWatch;
    private final Set<String> componentEnvNames = new HashSet<String>();
    private final Set<String> dataformatEnvNames = new HashSet<String>();
    private final Set<String> languageEnvNames = new HashSet<String>();

    public MainHelper() {
        this.stopWatch = new StopWatch();
        try {
            InputStream is = MainHelper.class.getResourceAsStream("/org/apache/camel/main/components.properties");
            MainHelper.loadLines(is, this.componentEnvNames, s -> "CAMEL_COMPONENT_" + s.toUpperCase(Locale.US).replace('-', '_'));
            IOHelper.close((Closeable)is);
            is = MainHelper.class.getResourceAsStream("/org/apache/camel/main/dataformats.properties");
            MainHelper.loadLines(is, this.dataformatEnvNames, s -> "CAMEL_DATAFORMAT_" + s.toUpperCase(Locale.US).replace('-', '_'));
            IOHelper.close((Closeable)is);
            is = MainHelper.class.getResourceAsStream("/org/apache/camel/main/languages.properties");
            MainHelper.loadLines(is, this.languageEnvNames, s -> "CAMEL_LANGUAGE_" + s.toUpperCase(Locale.US).replace('-', '_'));
            IOHelper.close((Closeable)is);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading catalog information from classpath", e);
        }
        this.version = this.doGetVersion();
    }

    public String getVersion() {
        return this.version;
    }

    public String getUptime() {
        long delta = this.stopWatch.taken();
        if (delta == 0L) {
            return "";
        }
        return TimeUtils.printDuration((long)delta);
    }

    public void bootstrapDone() {
        this.componentEnvNames.clear();
        this.dataformatEnvNames.clear();
        this.languageEnvNames.clear();
    }

    public static String toEnvVar(String name) {
        return name.toUpperCase(Locale.US).replaceAll("[^\\w]", "-").replace('-', '_');
    }

    public static Optional<String> lookupPropertyFromSysOrEnv(String name) {
        String answer = System.getProperty(name);
        if (answer == null) {
            answer = IOHelper.lookupEnvironmentVariable((String)name);
        }
        return Optional.ofNullable(answer);
    }

    public static Properties loadEnvironmentVariablesAsProperties(String[] prefixes) {
        OrderedProperties answer = new OrderedProperties();
        if (prefixes == null || prefixes.length == 0) {
            return answer;
        }
        for (String prefix : prefixes) {
            String pk = prefix.toUpperCase(Locale.US).replaceAll("[^\\w]", "-");
            String pk2 = pk.replace('-', '_');
            System.getenv().forEach((arg_0, arg_1) -> MainHelper.lambda$loadEnvironmentVariablesAsProperties$3(pk, pk2, (Properties)answer, arg_0, arg_1));
        }
        return answer;
    }

    public static Map<String, String> filterEnvVariables(String[] prefixes) {
        HashMap<String, String> answer = new HashMap<String, String>();
        System.getenv().forEach((k, v) -> {
            String uk = k.toUpperCase(Locale.US);
            for (String prefix : prefixes) {
                if (!uk.startsWith(prefix)) continue;
                answer.put(uk, (String)v);
            }
        });
        return answer;
    }

    public void addComponentEnvVariables(Map<String, String> env, Properties properties, boolean custom) {
        HashSet toRemove = new HashSet();
        env.forEach((k, v) -> {
            if (custom) {
                toRemove.add(k);
                Object ck = "camel.component." + k.substring(16).toLowerCase(Locale.US).replace('_', '-');
                ck = ((String)ck).replaceFirst("-", ".");
                properties.put(ck, v);
            } else {
                Optional<String> e = this.componentEnvNames.stream().filter(k::startsWith).findFirst();
                if (e.isPresent()) {
                    toRemove.add(k);
                    String cname = "camel.component." + e.get().substring(16).toLowerCase(Locale.US).replace('_', '-');
                    String option = k.substring(cname.length() + 1).toLowerCase(Locale.US).replace('_', '-');
                    properties.put(cname + "." + option, v);
                }
            }
        });
        toRemove.forEach(env::remove);
    }

    public void addDataFormatEnvVariables(Map<String, String> env, Properties properties, boolean custom) {
        HashSet toRemove = new HashSet();
        env.forEach((k, v) -> {
            if (custom) {
                toRemove.add(k);
                Object ck = "camel.dataformat." + k.substring(17).toLowerCase(Locale.US).replace('_', '-');
                ck = ((String)ck).replaceFirst("-", ".");
                properties.put(ck, v);
            } else {
                Optional<String> e = this.dataformatEnvNames.stream().filter(k::startsWith).findFirst();
                if (e.isPresent()) {
                    toRemove.add(k);
                    String cname = "camel.dataformat." + e.get().substring(17).toLowerCase(Locale.US).replace('_', '-');
                    String option = k.substring(cname.length() + 1).toLowerCase(Locale.US).replace('_', '-');
                    properties.put(cname + "." + option, v);
                }
            }
        });
        toRemove.forEach(env::remove);
    }

    public void addLanguageEnvVariables(Map<String, String> env, Properties properties, boolean custom) {
        HashSet toRemove = new HashSet();
        env.forEach((k, v) -> {
            if (custom) {
                toRemove.add(k);
                Object ck = "camel.language." + k.substring(15).toLowerCase(Locale.US).replace('_', '-');
                ck = ((String)ck).replaceFirst("-", ".");
                properties.put(ck, v);
            } else {
                Optional<String> e = this.languageEnvNames.stream().filter(k::startsWith).findFirst();
                if (e.isPresent()) {
                    toRemove.add(k);
                    String cname = "camel.language." + e.get().substring(15).toLowerCase(Locale.US).replace('_', '-');
                    String option = k.substring(cname.length() + 1).toLowerCase(Locale.US).replace('_', '-');
                    properties.put(cname + "." + option, v);
                }
            }
        });
        toRemove.forEach(env::remove);
    }

    public static Properties loadJvmSystemPropertiesAsProperties(String[] prefixes) {
        OrderedProperties answer = new OrderedProperties();
        if (prefixes == null || prefixes.length == 0) {
            return answer;
        }
        for (String prefix : prefixes) {
            String pk = prefix.toUpperCase(Locale.US).replaceAll("[^\\w]", "-");
            String pk2 = pk.replace('-', '.');
            System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> MainHelper.lambda$loadJvmSystemPropertiesAsProperties$8(pk, pk2, (Properties)answer, arg_0, arg_1)));
        }
        return answer;
    }

    public static String optionKey(String key) {
        key = StringHelper.dashToCamelCase((String)key, (boolean)true);
        return key;
    }

    public static boolean setPropertiesOnTarget(CamelContext context, Object target, Object source) throws Exception {
        ObjectHelper.notNull((Object)context, (String)"context");
        ObjectHelper.notNull((Object)target, (String)"target");
        boolean rc = false;
        PropertyConfigurer targetConfigurer = null;
        if (target instanceof Component) {
            Component component = (Component)target;
            ServiceHelper.initService((Object)target);
            targetConfigurer = component.getComponentPropertyConfigurer();
        }
        if (targetConfigurer == null) {
            String name = target.getClass().getName();
            targetConfigurer = PluginHelper.getConfigurerResolver((CamelContext)context).resolvePropertyConfigurer(name, context);
        }
        PropertyConfigurer sourceConfigurer = null;
        if (source instanceof Component) {
            Component component = (Component)source;
            ServiceHelper.initService((Object)source);
            sourceConfigurer = component.getComponentPropertyConfigurer();
        }
        if (sourceConfigurer == null) {
            String name = source.getClass().getName();
            sourceConfigurer = PluginHelper.getConfigurerResolver((CamelContext)context).resolvePropertyConfigurer(name, context);
        }
        if (targetConfigurer != null && sourceConfigurer instanceof ExtendedPropertyConfigurerGetter) {
            ExtendedPropertyConfigurerGetter getter = (ExtendedPropertyConfigurerGetter)sourceConfigurer;
            for (String key : getter.getAllOptions(source).keySet()) {
                Object value = getter.getOptionValue(source, key, true);
                if (value == null) continue;
                rc |= targetConfigurer.configure(context, target, key, value, true);
            }
        }
        return rc;
    }

    public static boolean setPropertiesOnTarget(CamelContext context, Object target, OrderedLocationProperties properties, String optionPrefix, boolean failIfNotSet, boolean ignoreCase, OrderedLocationProperties autoConfiguredProperties) {
        ObjectHelper.notNull((Object)context, (String)"context");
        ObjectHelper.notNull((Object)target, (String)"target");
        ObjectHelper.notNull((Object)properties, (String)"properties");
        boolean rc = false;
        PropertyConfigurer configurer = null;
        if (target instanceof Component) {
            Component component = (Component)target;
            ServiceHelper.initService((Object)target);
            configurer = component.getComponentPropertyConfigurer();
        }
        if (configurer == null) {
            String name = target.getClass().getName();
            configurer = PluginHelper.getBootstrapConfigurerResolver((CamelContext)context).resolvePropertyConfigurer(name, context);
        }
        if (configurer instanceof ExtendedPropertyConfigurerGetter) {
            ExtendedPropertyConfigurerGetter ec = (ExtendedPropertyConfigurerGetter)configurer;
            Map options = ec.getAllOptions(target);
            for (Object key : options.keySet()) {
                Object actualKey = key = Character.toLowerCase(((String)key).charAt(0)) + ((String)key).substring(1);
                if (properties.get(key = StringHelper.camelCaseToDot((String)key)) == null) continue;
                Object value = properties.get(key);
                String loc = properties.getLocation(key);
                properties.remove(key);
                properties.put(loc, actualKey, value);
                LOG.debug("Adjusting property key: {} -> {}", key, actualKey);
            }
        }
        try {
            OrderedLocationProperties backup = new OrderedLocationProperties();
            backup.putAll(properties);
            rc = PropertyBindingSupport.build().withMandatory(failIfNotSet).withRemoveParameters(true).withConfigurer(configurer).withIgnoreCase(ignoreCase).bind(context, target, properties.asMap());
            for (Map.Entry entry : backup.entrySet()) {
                if (entry.getValue() == null || properties.containsKey(entry.getKey())) continue;
                Object prefix = optionPrefix;
                if (prefix != null && !((String)prefix).endsWith(".")) {
                    prefix = "." + (String)prefix;
                }
                LOG.debug("Configured property: {}{}={} on bean: {}", new Object[]{prefix, entry.getKey(), entry.getValue(), target});
                String loc = backup.getLocation(entry.getKey());
                String key = (String)prefix + entry.getKey();
                autoConfiguredProperties.put(loc, (Object)key, entry.getValue());
            }
        }
        catch (PropertyBindingException e) {
            String key = e.getOptionKey();
            if (key == null) {
                Object prefix = e.getOptionPrefix();
                if (prefix != null && !((String)prefix).endsWith(".")) {
                    prefix = "." + (String)prefix;
                }
                String string = key = prefix != null ? (String)prefix + "." + e.getPropertyName() : e.getPropertyName();
            }
            if (failIfNotSet) {
                throw new PropertyBindingException(e.getTarget(), e.getPropertyName(), e.getValue(), optionPrefix, key, e.getCause());
            }
            LOG.debug("Error configuring property ({}) with name: {}) on bean: {} with value: {}. This exception is ignored as failIfNotSet=false.", new Object[]{key, e.getPropertyName(), target, e.getValue(), e});
        }
        catch (Exception e) {
            if (failIfNotSet) {
                throw e;
            }
            LOG.debug("Error configuring properties on bean: {}. This exception is ignored as failIfNotSet=false.", target, (Object)e);
        }
        return rc;
    }

    public static void computeProperties(String keyPrefix, String key, OrderedLocationProperties prop, Map<PropertyOptionKey, OrderedLocationProperties> properties, Function<String, Iterable<Object>> supplier) {
        if (key.startsWith(keyPrefix)) {
            String name;
            int dot = key.indexOf(46, keyPrefix.length());
            String string = name = dot == -1 ? key.substring(keyPrefix.length()) : key.substring(keyPrefix.length(), dot);
            if ("enabled".equals(name)) {
                return;
            }
            if ("properties".equals(name)) {
                return;
            }
            if (!MainHelper.isServiceEnabled(keyPrefix, name, (Properties)prop)) {
                return;
            }
            String prefix = dot == -1 ? "" : key.substring(0, dot + 1);
            String option = dot == -1 ? "" : key.substring(dot + 1);
            String value = prop.getProperty(key, "");
            if ("enabled".equalsIgnoreCase(option)) {
                return;
            }
            MainHelper.validateOptionAndValue(key, option, value);
            Iterable<Object> targets = supplier.apply(name);
            for (Object target : targets) {
                PropertyOptionKey pok = new PropertyOptionKey(target, prefix);
                OrderedLocationProperties values = properties.computeIfAbsent(pok, k -> new OrderedLocationProperties());
                String loc = prop.getLocation((Object)key);
                values.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
            }
        }
    }

    public static boolean isServiceEnabled(String prefix, String name, Properties properties) {
        ObjectHelper.notNull((Object)prefix, (String)"prefix");
        ObjectHelper.notNull((Object)name, (String)"name");
        ObjectHelper.notNull((Object)properties, (String)"properties");
        if (!((String)prefix).endsWith(".")) {
            prefix = (String)prefix + ".";
        }
        String group = properties.getProperty((String)prefix + "enabled", "true");
        String item = properties.getProperty((String)prefix + name + ".enabled", group);
        return Boolean.parseBoolean(item);
    }

    public static void validateOptionAndValue(String key, String option, String value) {
        if (ObjectHelper.isEmpty((String)option)) {
            throw new IllegalArgumentException("Error configuring property: " + key + " because option is empty");
        }
        if (ObjectHelper.isEmpty((String)value)) {
            throw new IllegalArgumentException("Error configuring property: " + key + " because value is empty");
        }
    }

    private static void loadLines(InputStream in, Set<String> lines, Function<String, String> func) throws IOException {
        if (in != null) {
            try (InputStreamReader isr = new InputStreamReader(in);
                 LineNumberReader reader = new LineNumberReader(isr);){
                String line;
                while ((line = ((BufferedReader)reader).readLine()) != null) {
                    lines.add(func.apply(line));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doGetVersion() {
        Package aPackage;
        String version;
        block6: {
            version = null;
            InputStream is = null;
            try {
                Properties p = new Properties();
                is = MainHelper.class.getResourceAsStream("/META-INF/maven/org.apache.camel/camel-main/pom.properties");
                if (is != null) {
                    p.load(is);
                    version = p.getProperty("version", "");
                }
                if (is == null) break block6;
            }
            catch (Exception p) {
                if (is != null) {
                    IOHelper.close(is);
                }
                break block6;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                IOHelper.close(is);
                throw throwable;
            }
            IOHelper.close((Closeable)is);
        }
        if (version == null && (aPackage = this.getClass().getPackage()) != null && (version = aPackage.getImplementationVersion()) == null) {
            version = aPackage.getSpecificationVersion();
        }
        if (version != null) return version;
        return "";
    }

    public static OrderedLocationProperties extractProperties(OrderedLocationProperties properties, String optionPrefix) {
        return MainHelper.extractProperties(properties, optionPrefix, null, true);
    }

    public static OrderedLocationProperties extractProperties(OrderedLocationProperties properties, String optionPrefix, String optionSuffix) {
        return MainHelper.extractProperties(properties, optionPrefix, optionSuffix, true);
    }

    public static OrderedLocationProperties extractProperties(OrderedLocationProperties properties, String optionPrefix, String optionSuffix, boolean remove) {
        return MainHelper.extractProperties(properties, optionPrefix, optionSuffix, remove, null);
    }

    public static OrderedLocationProperties extractProperties(OrderedLocationProperties properties, String optionPrefix, String optionSuffix, boolean remove, Function<String, String> keyTransformer) {
        if (properties == null) {
            return new OrderedLocationProperties();
        }
        OrderedLocationProperties rc = new OrderedLocationProperties();
        HashSet toRemove = new HashSet();
        for (Map.Entry entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String loc = properties.getLocation((Object)key);
            if (!key.startsWith(optionPrefix)) continue;
            Object value = properties.get((Object)key);
            key = keyTransformer != null ? keyTransformer.apply(key) : key.substring(optionPrefix.length());
            if (optionSuffix != null && key.endsWith(optionSuffix)) {
                key = keyTransformer != null ? keyTransformer.apply(key) : key.substring(0, key.length() - optionSuffix.length());
            }
            rc.put(loc, (Object)key, value);
            if (!remove) continue;
            toRemove.add(entry.getKey());
        }
        toRemove.forEach(arg_0 -> ((OrderedLocationProperties)properties).remove(arg_0));
        return rc;
    }

    public static void logConfigurationSummary(Logger log, OrderedLocationProperties autoConfiguredProperties, String title, Predicate<String> filter) {
        if (log == null) {
            log = LOG;
        }
        boolean header = false;
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry entry : autoConfiguredProperties.entrySet()) {
            String k = entry.getKey().toString();
            if (filter != null && !filter.test(k)) continue;
            Object v = entry.getValue();
            String loc = LocationHelper.locationSummary((OrderedLocationProperties)autoConfiguredProperties, (String)k);
            boolean debug = loc.contains("[camel-main]");
            if (debug && !LOG.isDebugEnabled()) continue;
            if (!header) {
                log.info(title);
                header = true;
            }
            MainHelper.sensitiveAwareLogging(log, k, v, loc, debug);
            toRemove.add(k);
        }
        toRemove.forEach(arg_0 -> ((OrderedLocationProperties)autoConfiguredProperties).remove(arg_0));
    }

    public static void sensitiveAwareLogging(Logger log, String k, Object v, String loc, boolean debug) {
        if (log == null) {
            log = LOG;
        }
        if (SensitiveUtils.containsSensitive((String)k)) {
            if (debug) {
                log.debug("    {} {} = xxxxxx", (Object)loc, (Object)k);
            } else {
                log.info("    {} {} = xxxxxx", (Object)loc, (Object)k);
            }
        } else if (debug) {
            log.debug("    {} {} = {}", new Object[]{loc, k, v});
        } else {
            log.info("    {} {} = {}", new Object[]{loc, k, v});
        }
    }

    private static /* synthetic */ void lambda$loadJvmSystemPropertiesAsProperties$8(String pk, String pk2, Properties answer, Object k, Object v) {
        String key = k.toString().toUpperCase(Locale.US);
        if (key.startsWith(pk) || key.startsWith(pk2)) {
            answer.put(k.toString(), v);
        }
    }

    private static /* synthetic */ void lambda$loadEnvironmentVariablesAsProperties$3(String pk, String pk2, Properties answer, String k, String v) {
        boolean k8s;
        boolean bl = k8s = (k = k.toUpperCase(Locale.US)).endsWith("_SERVICE_HOST") || k.endsWith("_SERVICE_PORT") || k.endsWith("_PORT") || k.contains("_PORT_");
        if (k8s) {
            LOG.trace("Skipping Kubernetes Service OS environment variable: {}", (Object)k);
        } else if (k.startsWith(pk) || k.startsWith(pk2)) {
            String key = k.toLowerCase(Locale.US).replace('_', '.');
            answer.put(key, v);
        }
    }
}

