/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.Map;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.LocationHelper;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.SensitiveUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="main-configuration", displayName="Main Configuration", description="Display Camel startup configuration")
public class MainConfigurationDevConsole
extends AbstractDevConsole {
    private final OrderedLocationProperties startupConfiguration = new OrderedLocationProperties();

    public MainConfigurationDevConsole() {
        super("camel", "main-configuration", "Main Configuration", "Display Camel startup configuration");
    }

    public void addStartupConfiguration(OrderedLocationProperties startupConfiguration) {
        this.startupConfiguration.putAll(startupConfiguration);
    }

    public void addStartupConfiguration(String loc, Object key, Object value) {
        this.startupConfiguration.put(loc, key, value);
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        if (!this.startupConfiguration.isEmpty()) {
            sb.append("Camel Main Configuration:\n");
            for (Map.Entry entry : this.startupConfiguration.entrySet()) {
                String k = entry.getKey().toString();
                Object v = entry.getValue();
                String loc = LocationHelper.locationSummary((OrderedLocationProperties)this.startupConfiguration, (String)k);
                if (SensitiveUtils.containsSensitive((String)k)) {
                    sb.append(String.format("    %s %s = xxxxxx%n", loc, k));
                    continue;
                }
                sb.append(String.format("    %s %s = %s%n", loc, k, v));
            }
        }
        return sb.toString();
    }

    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        PropertiesComponent pc = this.getCamelContext().getPropertiesComponent();
        JsonObject root = new JsonObject();
        if (!this.startupConfiguration.isEmpty()) {
            JsonArray arr = new JsonArray();
            for (Map.Entry entry : this.startupConfiguration.entrySet()) {
                String k = entry.getKey().toString();
                Object v = entry.getValue();
                String loc = this.startupConfiguration.getLocation((Object)k);
                Object defaultValue = this.startupConfiguration.getDefaultValue((Object)k);
                JsonObject jo = new JsonObject();
                jo.put((Object)"key", (Object)k);
                jo.put((Object)"value", v);
                if (defaultValue != null) {
                    jo.put((Object)"defaultValue", defaultValue);
                }
                pc.getResolvedValue(k).ifPresent(r -> {
                    String src;
                    String ov = r.originalValue();
                    if (ov != null) {
                        jo.put((Object)"originalValue", (Object)ov);
                    }
                    if ((src = r.source()) != null) {
                        jo.put((Object)"source", (Object)src);
                    }
                });
                if (loc != null) {
                    jo.put((Object)"location", (Object)loc);
                    jo.put((Object)"internal", (Object)MainConfigurationDevConsole.isInternal(loc));
                }
                arr.add((Object)jo);
            }
            root.put((Object)"configurations", (Object)arr);
        }
        return root;
    }

    private static boolean isInternal(String loc) {
        if (loc == null) {
            return false;
        }
        return "initial".equals(loc) || "override".equals(loc);
    }
}

