/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import javax.mail.Message;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mail.MailBinding;
import org.apache.camel.component.mail.MailComponent;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailConsumer;
import org.apache.camel.component.mail.MailExchange;
import org.apache.camel.component.mail.MailProducer;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class MailEndpoint
extends ScheduledPollEndpoint {
    private MailBinding binding;
    private MailConfiguration configuration;
    private HeaderFilterStrategy headerFilterStrategy = new DefaultHeaderFilterStrategy();

    public MailEndpoint() {
    }

    public MailEndpoint(String uri, MailComponent component, MailConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public MailEndpoint(String endpointUri, MailConfiguration configuration) {
        super(endpointUri);
        this.configuration = configuration;
    }

    public MailEndpoint(String endpointUri) {
        this(endpointUri, new MailConfiguration());
    }

    public Producer createProducer() throws Exception {
        JavaMailSenderImpl sender = this.configuration.createJavaMailSender();
        return this.createProducer((JavaMailSender)sender);
    }

    public Producer createProducer(JavaMailSender sender) throws Exception {
        return new MailProducer(this, sender);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.configuration.getProtocol().startsWith("smtp")) {
            throw new IllegalArgumentException("Protocol " + this.configuration.getProtocol() + " cannot be used for a MailConsumer. Please use another protocol such as pop3 or imap.");
        }
        JavaMailSenderImpl sender = this.configuration.createJavaMailSender();
        return this.createConsumer(processor, sender);
    }

    public Consumer createConsumer(Processor processor, JavaMailSenderImpl sender) throws Exception {
        MailConsumer answer = new MailConsumer(this, processor, sender);
        answer.setDelay(60000L);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Exchange createExchange(ExchangePattern pattern) {
        return new MailExchange(this, pattern, this.getBinding());
    }

    public MailExchange createExchange(Message message) {
        return new MailExchange(this, this.getExchangePattern(), this.getBinding(), message);
    }

    public boolean isSingleton() {
        return false;
    }

    public MailBinding getBinding() {
        if (this.binding == null) {
            this.binding = new MailBinding(this.headerFilterStrategy);
        }
        return this.binding;
    }

    public void setBinding(MailBinding binding) {
        this.binding = binding;
    }

    public MailConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MailConfiguration configuration) {
        this.configuration = configuration;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }
}

