/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mail.MailUtils;
import org.springframework.mail.javamail.JavaMailSenderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailConfiguration
implements Cloneable {
    public static final String DEFAULT_FOLDER_NAME = "INBOX";
    public static final String DEFAULT_FROM = "camel@localhost";
    public static final long DEFAULT_CONNECTION_TIMEOUT = 30000L;
    private Properties javaMailProperties;
    private Properties additionalJavaMailProperties;
    private String protocol;
    private String host;
    private int port = -1;
    private String username;
    private String password;
    private Session session;
    private String defaultEncoding;
    private String from = "camel@localhost";
    private String folderName = "INBOX";
    private boolean deleteProcessedMessages;
    private boolean ignoreUriScheme;
    private boolean processOnlyUnseenMessages = true;
    private Map<Message.RecipientType, String> recipients = new HashMap<Message.RecipientType, String>();
    private int fetchSize = -1;
    private boolean debugMode;
    private long connectionTimeout = 30000L;
    private boolean dummyTrustManager;
    private String contentType = "text/plain";

    public MailConfiguration copy() {
        try {
            return (MailConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void configure(URI uri) {
        int port;
        String userInfo;
        String scheme;
        String value = uri.getHost();
        if (value != null) {
            this.setHost(value);
        }
        if (!this.isIgnoreUriScheme() && (scheme = uri.getScheme()) != null) {
            this.setProtocol(scheme);
        }
        if ((userInfo = uri.getUserInfo()) != null) {
            this.setUsername(userInfo);
        }
        if ((port = uri.getPort()) > 0) {
            this.setPort(port);
        } else if (port <= 0 && this.port <= 0) {
            this.setPort(MailUtils.getDefaultPortForProtocol(uri.getScheme()));
        }
    }

    protected JavaMailSenderImpl createJavaMailSender() {
        JavaMailSenderImpl answer = new JavaMailSenderImpl();
        answer.getSession().setDebug(this.debugMode);
        if (this.javaMailProperties != null) {
            answer.setJavaMailProperties(this.javaMailProperties);
        } else {
            answer.setJavaMailProperties(this.createJavaMailProperties());
            if (this.additionalJavaMailProperties != null) {
                answer.getJavaMailProperties().putAll((Map<?, ?>)this.additionalJavaMailProperties);
            }
        }
        if (this.defaultEncoding != null) {
            answer.setDefaultEncoding(this.defaultEncoding);
        }
        if (this.host != null) {
            answer.setHost(this.host);
        }
        if (this.port >= 0) {
            answer.setPort(this.port);
        }
        if (this.password != null) {
            answer.setPassword(this.password);
        }
        if (this.protocol != null) {
            answer.setProtocol(this.protocol);
        }
        if (this.session != null) {
            answer.setSession(this.session);
        } else {
            Session session = Session.getDefaultInstance((Properties)answer.getJavaMailProperties(), (Authenticator)this.getAuthenticator());
            answer.setSession(session);
        }
        if (this.username != null) {
            answer.setUsername(this.username);
        }
        return answer;
    }

    private Properties createJavaMailProperties() {
        Properties properties = (Properties)System.getProperties().clone();
        properties.put("mail." + this.protocol + ".connectiontimeout", (Object)this.connectionTimeout);
        properties.put("mail." + this.protocol + ".timeout", (Object)this.connectionTimeout);
        properties.put("mail." + this.protocol + ".host", this.host);
        properties.put("mail." + this.protocol + ".port", "" + this.port);
        if (this.username != null) {
            properties.put("mail." + this.protocol + ".user", this.username);
            properties.put("mail.user", this.username);
            properties.put("mail." + this.protocol + ".auth", "true");
        } else {
            properties.put("mail." + this.protocol + ".auth", "false");
        }
        properties.put("mail." + this.protocol + ".rsetbeforequit", "true");
        properties.put("mail.transport.protocol", this.protocol);
        properties.put("mail.store.protocol", this.protocol);
        properties.put("mail.host", this.host);
        if (this.debugMode) {
            properties.put("javax.net.debug", "all");
        }
        if (this.dummyTrustManager && this.isSecureProtocol()) {
            properties.put("mail." + this.protocol + ".socketFactory.class", "org.apache.camel.component.mail.security.DummySSLSocketFactory");
            properties.put("mail." + this.protocol + ".socketFactory.fallback", "false");
            properties.put("mail." + this.protocol + ".socketFactory.port", "" + this.port);
        }
        return properties;
    }

    public boolean isSecureProtocol() {
        return this.protocol.equalsIgnoreCase("smtps") || this.protocol.equalsIgnoreCase("pop3s") || this.protocol.equalsIgnoreCase("imaps");
    }

    public Authenticator getAuthenticator() {
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailConfiguration.this.getUsername(), MailConfiguration.this.getPassword());
            }
        };
    }

    public String getMailStoreLogInformation() {
        String ssl = "";
        if (this.isSecureProtocol()) {
            ssl = "(SSL enabled" + (this.dummyTrustManager ? " using DummyTrustManager)" : ")");
        }
        return this.protocol + "//" + this.host + ":" + this.port + ssl + ", folder=" + this.folderName;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Properties getJavaMailProperties() {
        return this.javaMailProperties;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    public Properties getAdditionalJavaMailProperties() {
        if (this.additionalJavaMailProperties == null) {
            this.additionalJavaMailProperties = new Properties();
        }
        return this.additionalJavaMailProperties;
    }

    public void setAdditionalJavaMailProperties(Properties additionalJavaMailProperties) {
        this.additionalJavaMailProperties = additionalJavaMailProperties;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        if (this.getRecipients().size() == 0) {
            String address = username;
            if (address.indexOf("@") == -1) {
                address = address + "@" + this.host;
            }
            this.setTo(address);
        }
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public boolean isDeleteProcessedMessages() {
        return this.deleteProcessedMessages;
    }

    public void setDeleteProcessedMessages(boolean deleteProcessedMessages) {
        this.deleteProcessedMessages = deleteProcessedMessages;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public boolean isIgnoreUriScheme() {
        return this.ignoreUriScheme;
    }

    public void setIgnoreUriScheme(boolean ignoreUriScheme) {
        this.ignoreUriScheme = ignoreUriScheme;
    }

    public boolean isProcessOnlyUnseenMessages() {
        return this.processOnlyUnseenMessages;
    }

    public void setProcessOnlyUnseenMessages(boolean processOnlyUnseenMessages) {
        this.processOnlyUnseenMessages = processOnlyUnseenMessages;
    }

    public void setTo(String address) {
        this.recipients.put(Message.RecipientType.TO, address);
    }

    public void setCC(String address) {
        this.recipients.put(Message.RecipientType.CC, address);
    }

    public void setBCC(String address) {
        this.recipients.put(Message.RecipientType.BCC, address);
    }

    public Map<Message.RecipientType, String> getRecipients() {
        return this.recipients;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isDummyTrustManager() {
        return this.dummyTrustManager;
    }

    public void setDummyTrustManager(boolean dummyTrustManager) {
        this.dummyTrustManager = dummyTrustManager;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

