/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.io.IOException;
import java.util.Map;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mail.MailExchange;
import org.apache.camel.component.mail.MailUtils;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.CollectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailMessage
extends DefaultMessage {
    private javax.mail.Message mailMessage;

    public MailMessage() {
    }

    public MailMessage(javax.mail.Message message) {
        this.mailMessage = message;
    }

    public String toString() {
        if (this.mailMessage != null) {
            return "MailMessage: " + MailUtils.dumpMessage(this.mailMessage);
        }
        return "MailMessage: " + this.getBody();
    }

    public MailExchange getExchange() {
        return (MailExchange)super.getExchange();
    }

    public MailMessage copy() {
        MailMessage answer = (MailMessage)super.copy();
        answer.mailMessage = this.mailMessage;
        return answer;
    }

    public javax.mail.Message getMessage() {
        return this.mailMessage;
    }

    public void setMessage(javax.mail.Message mailMessage) {
        this.mailMessage = mailMessage;
    }

    public Object getHeader(String name) {
        Object answer = super.getHeader(name);
        if (answer == null) {
            answer = super.getHeader(name.toLowerCase());
        }
        return answer;
    }

    public MailMessage newInstance() {
        return new MailMessage();
    }

    protected Object createBody() {
        if (this.mailMessage != null) {
            return this.getExchange().getBinding().extractBodyFromMail(this.getExchange(), this.mailMessage);
        }
        return null;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
        if (this.mailMessage != null) {
            try {
                map.putAll(this.getExchange().getBinding().extractHeadersFromMail(this.mailMessage));
            }
            catch (MessagingException e) {
                throw new RuntimeCamelException("Error accessing headers due to: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void populateInitialAttachments(Map<String, DataHandler> map) {
        if (this.mailMessage != null) {
            try {
                MailMessage.extractAttachments(this.mailMessage, map);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error populating the initial mail message attachments", (Throwable)e);
            }
        }
    }

    public void copyFrom(Message that) {
        super.copyFrom(that);
        if (that instanceof MailMessage) {
            MailMessage mailMessage = (MailMessage)that;
            this.mailMessage = mailMessage.mailMessage;
        }
    }

    protected static void extractAttachments(javax.mail.Message message, Map<String, DataHandler> map) throws MessagingException, IOException {
        Object content = message.getContent();
        if (content instanceof Multipart) {
            Multipart mp = (Multipart)content;
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart part = mp.getBodyPart(i);
                String disposition = part.getDisposition();
                if (disposition == null || !disposition.equalsIgnoreCase("attachment") && !disposition.equalsIgnoreCase("inline") || part.getFileName() == null) continue;
                CollectionHelper.appendValue(map, (Object)part.getFileName(), (Object)part.getDataHandler());
            }
        }
    }
}

