/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail.microsoft.authenticator;

import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.aad.msal4j.IConfidentialClientApplication;
import jakarta.mail.PasswordAuthentication;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Set;
import org.apache.camel.component.mail.MailAuthenticator;

public class MicrosoftExchangeOnlineOAuth2MailAuthenticator
extends MailAuthenticator {
    private static final Set<String> DEFAULT_SCOPES = Collections.singleton("https://outlook.office365.com/.default");
    private static final String AUTHORITY_BASE_URL = "https://login.microsoftonline.com/";
    private String clientId;
    private String clientSecret;
    private String authority;
    private final String user;
    private Boolean skipCache;
    private Set<String> scopes;
    private final ClientCredentialParameters clientCredentialParameters;
    private IConfidentialClientApplication confidentialClientApplication;

    public MicrosoftExchangeOnlineOAuth2MailAuthenticator(String tenantId, String clientId, String clientSecret, String user) {
        this(tenantId, clientId, clientSecret, user, false, null, null);
    }

    public MicrosoftExchangeOnlineOAuth2MailAuthenticator(String tenantId, String clientId, String clientSecret, String user, Boolean skipCache) {
        this(tenantId, clientId, clientSecret, user, skipCache, null, null);
    }

    public MicrosoftExchangeOnlineOAuth2MailAuthenticator(String tenantId, String clientId, String clientSecret, String user, Boolean skipCache, Set<String> scopes) {
        this(tenantId, clientId, clientSecret, user, skipCache, scopes, null);
    }

    public MicrosoftExchangeOnlineOAuth2MailAuthenticator(String tenantId, String clientId, String clientSecret, String user, ClientCredentialParameters clientCredentialParameters) {
        this(tenantId, clientId, clientSecret, user, null, null, clientCredentialParameters);
    }

    public MicrosoftExchangeOnlineOAuth2MailAuthenticator(String user, IConfidentialClientApplication confidentialClientApplication, ClientCredentialParameters clientCredentialParameters) {
        this.user = user;
        this.confidentialClientApplication = confidentialClientApplication;
        this.clientCredentialParameters = clientCredentialParameters;
    }

    private MicrosoftExchangeOnlineOAuth2MailAuthenticator(String tenantId, String clientId, String clientSecret, String user, Boolean skipCache, Set<String> scopes, ClientCredentialParameters parametes) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.authority = AUTHORITY_BASE_URL + tenantId;
        this.skipCache = skipCache;
        this.user = user;
        this.clientCredentialParameters = parametes;
        this.scopes = scopes == null || scopes.isEmpty() ? DEFAULT_SCOPES : scopes;
    }

    public PasswordAuthentication getPasswordAuthentication() {
        IAuthenticationResult result = (IAuthenticationResult)this.getClientCredential().acquireToken(this.getClientCredentialParameters()).join();
        return new PasswordAuthentication(this.user, result.accessToken());
    }

    private IConfidentialClientApplication getClientCredential() {
        if (this.confidentialClientApplication != null) {
            return this.confidentialClientApplication;
        }
        try {
            IClientSecret credential = ClientCredentialFactory.createFromSecret((String)this.clientSecret);
            this.confidentialClientApplication = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)credential).authority(this.authority)).build();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return this.confidentialClientApplication;
    }

    private ClientCredentialParameters getClientCredentialParameters() {
        if (this.clientCredentialParameters != null) {
            return this.clientCredentialParameters;
        }
        return ClientCredentialParameters.builder(this.scopes).skipCache(this.skipCache).build();
    }
}

