/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.service.lra;

import java.util.Map;
import java.util.Optional;
import org.apache.camel.Endpoint;

public class LRAUrlBuilder {
    private String host;
    private String path = "";
    private String query = "";

    public LRAUrlBuilder() {
    }

    public LRAUrlBuilder(String host, String path, String query) {
        this.host = host;
        this.path = path;
        this.query = query;
    }

    public LRAUrlBuilder host(String host) {
        if (this.host != null) {
            throw new IllegalStateException("Host already set");
        }
        LRAUrlBuilder copy = this.copy();
        copy.host = host;
        return copy;
    }

    public LRAUrlBuilder path(String path) {
        LRAUrlBuilder copy = this.copy();
        copy.path = this.joinPath(this.path, path);
        return copy;
    }

    public LRAUrlBuilder compensation(Optional<Endpoint> endpoint) {
        if (endpoint.isPresent()) {
            return this.compensation(endpoint.get().getEndpointUri());
        }
        return this;
    }

    public LRAUrlBuilder compensation(String uri) {
        return this.query("Camel-Saga-Compensate", uri);
    }

    public LRAUrlBuilder completion(Optional<Endpoint> endpoint) {
        if (endpoint.isPresent()) {
            return this.completion(endpoint.get().getEndpointUri());
        }
        return this;
    }

    public LRAUrlBuilder completion(String uri) {
        return this.query("Camel-Saga-Complete", uri);
    }

    public LRAUrlBuilder options(Map<String, ?> options) {
        LRAUrlBuilder result = this;
        for (Map.Entry<String, ?> entry : options.entrySet()) {
            result = result.query(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public LRAUrlBuilder query(String key, Object value) {
        LRAUrlBuilder copy = this.copy();
        copy.query = copy.query.isEmpty() ? copy.query + "?" : copy.query + "&";
        copy.query = copy.query + this.toNonnullString(key) + "=" + this.toNonnullString(value);
        return copy;
    }

    public String build() {
        if (this.host == null) {
            throw new IllegalStateException("Host not set");
        }
        return this.joinPath(this.host, this.path) + this.query;
    }

    private String joinPath(String first, String second) {
        first = this.toNonnullString(first);
        second = this.toNonnullString(second);
        while (first.endsWith("/")) {
            first = first.substring(0, first.length() - 1);
        }
        while (second.startsWith("/")) {
            second = second.substring(1);
        }
        return first + "/" + second;
    }

    private String toNonnullString(Object obj) {
        return obj != null ? obj.toString() : "";
    }

    private LRAUrlBuilder copy() {
        return new LRAUrlBuilder(this.host, this.path, this.query);
    }
}

