/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ldap;

import java.net.URISyntaxException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.ldap.LdapComponent;
import org.apache.camel.component.ldap.LdapProducer;
import org.apache.camel.impl.DefaultEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapEndpoint<E extends Exchange>
extends DefaultEndpoint<E> {
    public static final String SYSTEM_DN = "ou=system";
    public static final String OBJECT_SCOPE = "object";
    public static final String ONELEVEL_SCOPE = "onelevel";
    public static final String SUBTREE_SCOPE = "subtree";
    private String remaining;
    private String base = "ou=system";
    private String scope = "subtree";

    protected LdapEndpoint(String endpointUri, String remaining, LdapComponent component) throws URISyntaxException {
        super(endpointUri, (Component)component);
        this.remaining = remaining;
    }

    public LdapEndpoint(String endpointUri, String remaining) throws URISyntaxException {
        super(endpointUri);
        this.remaining = remaining;
    }

    public Consumer<E> createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("An LDAP Consumer would be the LDAP server itself! No such support here");
    }

    public Producer<E> createProducer() throws Exception {
        return new LdapProducer(this, this.remaining, this.base, this.toSearchControlScope(this.scope));
    }

    public boolean isSingleton() {
        return true;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    private int toSearchControlScope(String scope) {
        if (scope.equalsIgnoreCase(OBJECT_SCOPE)) {
            return 0;
        }
        if (scope.equalsIgnoreCase(ONELEVEL_SCOPE)) {
            return 1;
        }
        if (scope.equalsIgnoreCase(SUBTREE_SCOPE)) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid search scope \"" + scope + "\" for LdapEndpoint: " + this.getEndpointUri());
    }
}

