/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.web.search;

import dev.langchain4j.web.search.WebSearchEngine;
import dev.langchain4j.web.search.WebSearchOrganicResult;
import dev.langchain4j.web.search.WebSearchRequest;
import dev.langchain4j.web.search.WebSearchResults;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.langchain4j.web.search.LangChain4jWebSearchEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class LangChain4jWebSearchProducer
extends DefaultProducer {
    private WebSearchEngine webSearchEngine;

    public LangChain4jWebSearchProducer(LangChain4jWebSearchEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public LangChain4jWebSearchEndpoint getEndpoint() {
        return (LangChain4jWebSearchEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        WebSearchRequest webSearchRequest = this.getEndpoint().getConfiguration().getWebSearchRequest();
        if (webSearchRequest == null) {
            String searchTerms = (String)exchange.getMessage().getMandatoryBody(String.class);
            webSearchRequest = WebSearchRequest.builder().searchTerms(searchTerms).maxResults(this.getEndpoint().getConfiguration().getMaxResults()).language(this.getEndpoint().getConfiguration().getLanguage()).geoLocation(this.getEndpoint().getConfiguration().getGeoLocation()).startPage(this.getEndpoint().getConfiguration().getStartPage()).startIndex(this.getEndpoint().getConfiguration().getStartIndex()).additionalParams(this.getEndpoint().getConfiguration().getAdditionalParams()).build();
        }
        WebSearchResults webSearchResults = this.webSearchEngine.search(webSearchRequest);
        List resultList = webSearchResults.results();
        this.computeResponse(resultList, exchange, webSearchRequest.maxResults());
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.webSearchEngine = this.getEndpoint().getConfiguration().getWebSearchEngine();
        ObjectHelper.notNull((Object)this.webSearchEngine, (String)"webSearchEngine");
    }

    private void computeResponse(List<WebSearchOrganicResult> webSearchOrganicResults, Exchange exchange, Integer maxResults) {
        if (webSearchOrganicResults == null || webSearchOrganicResults.isEmpty()) {
            exchange.getIn().setBody(null);
            return;
        }
        if (maxResults == 1) {
            switch (this.getEndpoint().getConfiguration().getResultType()) {
                case LANGCHAIN4J_WEB_SEARCH_ORGANIC_RESULT: {
                    exchange.getIn().setBody((Object)webSearchOrganicResults.get(0));
                    break;
                }
                case CONTENT: {
                    exchange.getIn().setBody((Object)webSearchOrganicResults.get(0).content());
                    break;
                }
                case SNIPPET: {
                    exchange.getIn().setBody((Object)webSearchOrganicResults.get(0).snippet());
                }
            }
        } else {
            switch (this.getEndpoint().getConfiguration().getResultType()) {
                case LANGCHAIN4J_WEB_SEARCH_ORGANIC_RESULT: {
                    exchange.getIn().setBody(webSearchOrganicResults);
                    break;
                }
                case CONTENT: {
                    exchange.getIn().setBody(webSearchOrganicResults.stream().map(WebSearchOrganicResult::content).collect(Collectors.toList()));
                    break;
                }
                case SNIPPET: {
                    exchange.getIn().setBody(webSearchOrganicResults.stream().map(WebSearchOrganicResult::snippet).collect(Collectors.toList()));
                }
            }
        }
    }
}

