/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.tokenizer;

import dev.langchain4j.data.document.DocumentSplitter;
import org.apache.camel.Exchange;
import org.apache.camel.component.langchain4j.tokenizer.config.LangChain4JConfiguration;
import org.apache.camel.component.langchain4j.tokenizer.util.SplitterUtil;
import org.apache.camel.spi.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLangChain4JTokenizer<T extends LangChain4JConfiguration>
implements Tokenizer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLangChain4JTokenizer.class);
    private DocumentSplitter splitter;

    AbstractLangChain4JTokenizer() {
    }

    protected void configure(String name, T configuration) {
        this.splitter = SplitterUtil.byName(name, configuration);
    }

    private void debugLog(String[] split) {
        for (int i = 0; i < split.length; ++i) {
            LOG.debug("Split {} part: {}", (Object)i, (Object)split[i]);
        }
    }

    public final String[] tokenize(Exchange exchange) {
        String body = (String)exchange.getIn().getBody(String.class);
        LOG.debug("Starting LangChain4j tokenizer for message: {}", (Object)body);
        String[] split = SplitterUtil.split(this.splitter, body);
        if (LOG.isDebugEnabled()) {
            this.debugLog(split);
        }
        return split;
    }

    protected static String toName(String name) {
        return "langchain4j-" + name;
    }
}

