/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.tokenizer.util;

import dev.langchain4j.community.model.dashscope.QwenTokenCountEstimator;
import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.splitter.DocumentByCharacterSplitter;
import dev.langchain4j.data.document.splitter.DocumentByLineSplitter;
import dev.langchain4j.data.document.splitter.DocumentByParagraphSplitter;
import dev.langchain4j.data.document.splitter.DocumentBySentenceSplitter;
import dev.langchain4j.data.document.splitter.DocumentByWordSplitter;
import dev.langchain4j.model.TokenCountEstimator;
import dev.langchain4j.model.azure.AzureOpenAiTokenCountEstimator;
import dev.langchain4j.model.openai.OpenAiTokenCountEstimator;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.langchain4j.tokenizer.config.LangChain4JConfiguration;
import org.apache.camel.component.langchain4j.tokenizer.config.LangChain4JQwenConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SplitterUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SplitterUtil.class);

    private SplitterUtil() {
    }

    public static DocumentSplitter byName(String name, LangChain4JConfiguration configuration) {
        assert (name != null) : "The splitter name must be provided";
        int maxTokens = configuration.getMaxTokens();
        int maxOverlap = configuration.getMaxOverlap();
        String type = configuration.getType();
        TokenCountEstimator countEstimator = SplitterUtil.buildTokenizer(configuration, type);
        LOG.debug("Creating a {} splitter", (Object)name);
        switch (name) {
            case "sentence": {
                return new DocumentBySentenceSplitter(maxTokens, maxOverlap, countEstimator);
            }
            case "paragraph": {
                return new DocumentByParagraphSplitter(maxTokens, maxOverlap, countEstimator);
            }
            case "character": {
                return new DocumentByCharacterSplitter(maxTokens, maxOverlap, countEstimator);
            }
            case "word": {
                return new DocumentByWordSplitter(maxTokens, maxOverlap, countEstimator);
            }
            case "line": {
                return new DocumentByLineSplitter(maxTokens, maxOverlap, countEstimator);
            }
        }
        throw new IllegalArgumentException("Unknown splitter name: " + name);
    }

    private static TokenCountEstimator buildTokenizer(LangChain4JConfiguration configuration, String type) {
        if (type == null) {
            throw new RuntimeCamelException("Invalid tokenizer type: null");
        }
        String model = configuration.getModelName();
        if (model == null) {
            return null;
        }
        return switch (type) {
            case "OPEN_AI" -> new OpenAiTokenCountEstimator(model);
            case "AZURE" -> new AzureOpenAiTokenCountEstimator(model);
            case "QWEN" -> SplitterUtil.createQwenTokenizer(configuration);
            default -> throw new RuntimeCamelException("Unknown tokenizer type: " + type);
        };
    }

    private static QwenTokenCountEstimator createQwenTokenizer(LangChain4JConfiguration configuration) {
        if (configuration instanceof LangChain4JQwenConfiguration) {
            LangChain4JQwenConfiguration qwenConfiguration = (LangChain4JQwenConfiguration)configuration;
            return new QwenTokenCountEstimator(qwenConfiguration.getApiKey(), qwenConfiguration.getModelName());
        }
        throw new RuntimeCamelException("Invalid configuration type for the QwenTokenCountEstimator: " + configuration.getClass().getSimpleName() + ". Use LangChain4JQwenConfiguration");
    }

    public static String[] split(DocumentSplitter splitter, String body) {
        if (splitter instanceof DocumentBySentenceSplitter) {
            DocumentBySentenceSplitter ds = (DocumentBySentenceSplitter)splitter;
            return ds.split(body);
        }
        if (splitter instanceof DocumentByParagraphSplitter) {
            DocumentByParagraphSplitter dp = (DocumentByParagraphSplitter)splitter;
            return dp.split(body);
        }
        if (splitter instanceof DocumentByCharacterSplitter) {
            DocumentByCharacterSplitter dc = (DocumentByCharacterSplitter)splitter;
            return dc.split(body);
        }
        if (splitter instanceof DocumentByWordSplitter) {
            DocumentByWordSplitter dw = (DocumentByWordSplitter)splitter;
            return dw.split(body);
        }
        if (splitter instanceof DocumentByLineSplitter) {
            DocumentByLineSplitter dl = (DocumentByLineSplitter)splitter;
            return dl.split(body);
        }
        throw new RuntimeCamelException("Unsupported splitter type: " + splitter.getClass().getSimpleName());
    }
}

