/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.embeddingstore;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.filter.Filter;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.langchain4j.embeddingstore.EmbeddingStoreFactory;
import org.apache.camel.component.langchain4j.embeddingstore.LangChain4jEmbeddingStoreAction;
import org.apache.camel.component.langchain4j.embeddingstore.LangChain4jEmbeddingStoreEndpoint;
import org.apache.camel.support.DefaultProducer;

public class LangChain4jEmbeddingStoreProducer
extends DefaultProducer {
    private ExecutorService executor;
    private EmbeddingStoreFactory embeddingStoreFactory;

    public LangChain4jEmbeddingStoreProducer(LangChain4jEmbeddingStoreEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public LangChain4jEmbeddingStoreEndpoint getEndpoint() {
        return (LangChain4jEmbeddingStoreEndpoint)super.getEndpoint();
    }

    public void doStart() throws Exception {
        super.doStart();
        this.embeddingStoreFactory = this.getEndpoint().getConfiguration().getEmbeddingStoreFactory();
        if (this.embeddingStoreFactory != null) {
            this.embeddingStoreFactory.setCamelContext(this.getEndpoint().getCamelContext());
            EmbeddingStore es = this.embeddingStoreFactory.createEmbeddingStore();
            this.getEndpoint().getConfiguration().setEmbeddingStore((EmbeddingStore<TextSegment>)es);
        }
    }

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        LangChain4jEmbeddingStoreAction action = (LangChain4jEmbeddingStoreAction)((Object)in.getHeader("CamelLangchain4jEmbeddingStoreAction", LangChain4jEmbeddingStoreAction.class));
        try {
            if (action == null) {
                throw new NoSuchHeaderException("The action is a required header", exchange, "CamelLangchain4jEmbeddingStoreAction");
            }
            switch (action) {
                case ADD: {
                    this.add(exchange);
                    break;
                }
                case REMOVE: {
                    this.remove(exchange);
                    break;
                }
                case SEARCH: {
                    this.search(exchange);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported action: " + action.name());
                }
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
    }

    private void add(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        Embedding embedding = null;
        TextSegment text = null;
        String id = null;
        if (in.getHeader("CamelLangChain4jEmbeddingsEmbedding") != null) {
            embedding = (Embedding)in.getHeader("CamelLangChain4jEmbeddingsEmbedding", Embedding.class);
        }
        if (in.getHeader("CamelLangChain4jEmbeddingsTextSegment") != null) {
            text = (TextSegment)in.getHeader("CamelLangChain4jEmbeddingsTextSegment", TextSegment.class);
            id = this.getEndpoint().getConfiguration().getEmbeddingStore().add(embedding, (Object)text);
        } else {
            id = this.getEndpoint().getConfiguration().getEmbeddingStore().add(embedding);
        }
        Message out = exchange.getMessage();
        out.setBody((Object)id);
    }

    private void remove(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String id = (String)in.getBody(String.class);
        this.getEndpoint().getConfiguration().getEmbeddingStore().remove(id);
        Message out = exchange.getMessage();
    }

    private void search(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        Embedding embedding = null;
        if (in.getHeader("CamelLangChain4jEmbeddingsEmbedding") != null) {
            embedding = (Embedding)in.getHeader("CamelLangChain4jEmbeddingsEmbedding", Embedding.class);
        }
        int maxResults = Integer.parseInt("5");
        if (in.getHeader("CamelLangchain4jEmbeddingStoreMaxResults", Integer.class) != null) {
            maxResults = (Integer)in.getHeader("CamelLangchain4jEmbeddingStoreMaxResults", Integer.class);
        }
        EmbeddingSearchRequest.EmbeddingSearchRequestBuilder esrb = EmbeddingSearchRequest.builder().queryEmbedding(embedding).maxResults(Integer.valueOf(maxResults));
        if (in.getHeader("CamelLangchain4jEmbeddingStoreMinScore", Integer.class) != null) {
            Double minScore = (Double)in.getHeader("CamelLangchain4jEmbeddingStoreMinScore", Double.class);
            esrb = esrb.minScore(minScore);
        }
        if (in.getHeader("CamelLangchain4jEmbeddingStoreFilter", Filter.class) != null) {
            Filter filter = (Filter)in.getHeader("CamelLangchain4jEmbeddingStoreFilter", Filter.class);
            esrb = esrb.filter(filter);
        }
        EmbeddingSearchRequest embeddingSearchRequest = esrb.build();
        List result = this.getEndpoint().getConfiguration().getEmbeddingStore().search(embeddingSearchRequest).matches();
        Message out = exchange.getMessage();
        out.setBody((Object)result);
    }

    private CamelContext getCamelContext() {
        return this.getEndpoint().getCamelContext();
    }
}

