/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.embeddingstore;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.langchain4j.embeddingstore.LangChain4jEmbeddingStoreConfiguration;
import org.apache.camel.component.langchain4j.embeddingstore.LangChain4jEmbeddingStoreHeaders;
import org.apache.camel.component.langchain4j.embeddingstore.LangChain4jEmbeddingStoreProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.14.0", scheme="langchain4j-embeddingstore", title="LangChain4j Embedding Store", syntax="langchain4j-embeddings:embeddingStoreId", producerOnly=true, category={Category.DATABASE, Category.AI}, headersClass=LangChain4jEmbeddingStoreHeaders.class)
public class LangChain4jEmbeddingStoreEndpoint
extends DefaultEndpoint {
    @Metadata(required=true)
    @UriPath(description="The id of the embedding store")
    private final String embeddingStoreId;
    @UriParam
    private LangChain4jEmbeddingStoreConfiguration configuration;

    public LangChain4jEmbeddingStoreEndpoint(String endpointUri, Component component, String embeddingStoreId, LangChain4jEmbeddingStoreConfiguration configuration) {
        super(endpointUri, component);
        this.embeddingStoreId = embeddingStoreId;
        this.configuration = configuration;
    }

    public LangChain4jEmbeddingStoreConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getEmbeddingId() {
        return this.embeddingStoreId;
    }

    public Producer createProducer() throws Exception {
        return new LangChain4jEmbeddingStoreProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not implemented for this component");
    }

    public void doStart() throws Exception {
        super.doStart();
    }

    public void doStop() throws Exception {
        super.doStop();
    }
}

