/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.agent.api;

import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.tool.ToolProvider;
import org.apache.camel.component.langchain4j.agent.api.Agent;
import org.apache.camel.component.langchain4j.agent.api.AgentConfiguration;
import org.apache.camel.component.langchain4j.agent.api.AiAgentBody;
import org.apache.camel.component.langchain4j.agent.api.AiAgentWithoutMemoryService;

public class AgentWithoutMemory
implements Agent {
    private final AgentConfiguration configuration;

    public AgentWithoutMemory(AgentConfiguration configuration) {
        this.configuration = configuration;
    }

    public String chat(AiAgentBody aiAgentBody, ToolProvider toolProvider) {
        AiAgentWithoutMemoryService agentService = this.createAiAgentService(toolProvider);
        return aiAgentBody.getSystemMessage() != null ? agentService.chat(aiAgentBody.getUserMessage(), aiAgentBody.getSystemMessage()) : agentService.chat(aiAgentBody.getUserMessage());
    }

    private AiAgentWithoutMemoryService createAiAgentService(ToolProvider toolProvider) {
        AiServices builder = AiServices.builder(AiAgentWithoutMemoryService.class).chatModel(this.configuration.getChatModel());
        if (toolProvider != null) {
            builder.toolProvider(toolProvider);
        }
        if (this.configuration.getRetrievalAugmentor() != null) {
            builder.retrievalAugmentor(this.configuration.getRetrievalAugmentor());
        }
        if (this.configuration.getInputGuardrailClasses() != null && !this.configuration.getInputGuardrailClasses().isEmpty()) {
            builder.inputGuardrailClasses(this.configuration.getInputGuardrailClasses());
        }
        if (this.configuration.getOutputGuardrailClasses() != null && !this.configuration.getOutputGuardrailClasses().isEmpty()) {
            builder.outputGuardrailClasses(this.configuration.getOutputGuardrailClasses());
        }
        return (AiAgentWithoutMemoryService)builder.build();
    }
}

